package ca.tecreations.apps._actions;

import ca.tecreations.TColor;
import ca.tecreations.ImageTool;
import ca.tecreations.components.Button;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.net.URL;
/**
 *
 * @author tim
 */
public class ScreenshotButton extends Button {
    boolean canDo = true;
    
    public ScreenshotButton() {
    }
   
    public boolean isHeadless() {
        return !canDo;
    }
    
    public void paint(Graphics g) {
        if (getImage() == null) {
            URL url = RefreshButton.class.getResource("/ca/tecreations/icons/camera.png");
            BufferedImage image = ImageTool.getImageAsResource(url);
            setImage(image);
        }
        super.paint(g);
        if (!canDo) {
            g.setColor(TColor.red);
            
            int low = -1;
            int high = 1;
            int w = getWidth();
            int h = getHeight();
            for(int x = low; x < high;x++) {
                g.drawLine(x, 0, w + x, h);
                g.drawLine(w + x, 0, x, h);
            }
        }
    }
    
    public void setCanScreenshot(boolean flag) {
        canDo = flag;
        repaint();
    }
    
}
 