package ca.tecreations;

import static ca.tecreations.Unicode.toHex;

import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */
public class UnicodeToken extends Token {
    List<String> unicodes = new ArrayList<>();
    
    public UnicodeToken(List<String> unicodes) { // remember from Unicode.java
                    // that a unicode is a 4 to 5 character representation, in hex,
                    // of a given Unicode character. We use this representation to
                    // get an actual Unicode character for use in a String using the
                    // code in getText() or Unicode.toString()
        super("");
        this.unicodes = unicodes;
    }
    
    public UnicodeToken(String unicode) {
        super("");
        unicodes.add(unicode);
    }
    
    public UnicodeToken(int a, int b, int c, int d) {
        super("");
        unicodes.add(toHex(a) + toHex(b) + toHex(c) + toHex(d));
    }
    
    public UnicodeToken(int z, int a, int b, int c, int d) {
        super("");
        unicodes.add(toHex(z) + toHex(a) + toHex(b) + toHex(c) + toHex(d));
    }
    
    public void add(List<String> unicodes) {
        for(int i = 0;i < unicodes.size();i++) {
            this.unicodes.add(unicodes.get(i));
        }
    }
    
    public void add(String unicode) {
        this.unicodes.add(unicode);
    }

    public void add(int a, int b, int c, int d) {
        unicodes.add(toHex(a) + toHex(b) + toHex(c) + toHex(d));
    }
    
    public void add(int z, int a, int b, int c, int d) {
        unicodes.add(toHex(z) + toHex(a) + toHex(b) + toHex(c) + toHex(d));
    }
    
    public String getFirst() {
        return unicodes.get(0); // always construct with at least one token
    }
    
    // in Unicode.toString(), we convert a single Unicode representatino, here
    // we process many unicodes into a multi-Unicode(s) String
    public String getText() { 
        String unicodeString = "";
        for(int i = 0;i  < unicodes.size();i++) {
            unicodeString += Unicode.toString(unicodes.get(i));
        }
        return unicodeString;
    }
    
    public static void main(String[] args) {
        UnicodeToken left = new UnicodeToken(2,9,13,6);
        left.print();
    }
    
    public void print() {
        System.out.println(getText());
    }
     
    public void print(String prefix) {
        System.out.println(prefix + text);
    }
    
    public void print(String prefix,String postfix) {
        System.out.println(prefix + text + postfix);
    }

    public void setText(List<String> unicodes) {
        this.unicodes = unicodes;
    }

}
