package ca.tecreations;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
 
/**
 *  
 * @author Tim de Vries
 */ 
public class Properties extends java.util.Properties {
    public static final String SN = Properties.class.getSimpleName();
    private static HashMap<String,List<Properties>> instances = new HashMap<>();
    public static List<Properties> reloaders = new ArrayList<>();
    
    java.util.Properties parent;
    private final Object lock = new Object();
    boolean debug = false;
    boolean debugWrite = false;
    boolean verbose = false;
    String absPath;
    boolean delayWrite = false;
    List<String> keys = new ArrayList<>();  
    List<String> values = new ArrayList<>();
    boolean created = false;
    boolean output = true;
    boolean autoCreate = true;

    // -------------------------------------------------------------------------
    // For Instantiation
    // -------------------------------------------------------------------------
    
    public Properties(File file) {
        this(file,false,true);
    }
    
    public Properties(String absPath) {
        this(new File(absPath),false,true);
    }
    
    public Properties(List<String> lines, boolean output) {
        _doInstanceAddition();
        parent = (java.util.Properties)this;
        this.output = output;
        for(int i = 0;i < lines.size();i++) {
            parse(lines.get(i));
        }
    }
    
    public List<String> instanceNames = new ArrayList<>();
    
    private final void _doInstanceAddition() {
        List<Properties> list = null;
        String trgtPropsFN = absPath;
        if (!instanceNames.contains(absPath)) {
            instanceNames.add(absPath);
            list = new ArrayList<>();
            list.add(this);
        } else {
            list = instances.get(absPath);
            list.add(this);
        }
        instances.put(absPath,list);
    }
    
    //--------------------------------------------------------------------------
    // Convenience entry points.
    //--------------------------------------------------------------------------
    public Properties(File file,boolean output,boolean autoCreate) {
        _doInstanceAddition();
        parent = (java.util.Properties)this;
        absPath = file.getAbsolutePath(); // remember? Double quoted
        this.output = output;
        this.autoCreate = autoCreate;
        read(output);
    }
    
    // END CONSTRUCTORS, DESTRUCTORS -------------------------------------------
    //========================for-machine-use===================================
    // -- tim's use ->[{(...)}]<- End.// /* tim */ /** tim debug 3 */ // test 8...
    //========================END machine use.===================================
    
    public void checkDebugPrint() {
        if (debug) {
            System.out.println("--------------------------------------------");
            print(); // calls checkReload();
            System.out.println("--------------------------------------------");
        }
    }

    public void checkReload() {
        if (reloaders.contains(this)) {
            read(false);
            reloaders.remove(this);
        }
    }
    
    public void clearCreated() {
        created = false;
    }

    public void decrement(String key, int amount) {
        int val;
        String sVal = (String) get(key); // calls checkReload
        if (sVal == null) {
            val = 0;
        } else {
            val = Integer.parseInt(sVal);
        }
        val -= amount;
        set(key, val);
        setReload();
    }

    public boolean deleteByKey(String key) {
        // reload chould be false, although that may result in stale key usage
        int index = getKeyIndex(key);
        if (index >= 0) {
            keys.remove(index);
            values.remove(index);
            write();
            setReload();
            return true;
        }
        return false;
    }

    // this will actually need a List<List<Properties>>, sorting instances by filename
    
    public boolean deleteByValue(String value) {
        setReload();
        int index = getValueIndex(value);
        if (index >= 0) {
            keys.remove(index);
            values.remove(index);
            write();
            setReload();
            return true;
        }
        return false;
    }

    public void deleteFile() {
        new File(absPath).delete();
    }
    
    /**
     *
     * @param key
     * @return value or null if not found.
     */
    public String get(String key) {
        checkReload();
        for (int i = 0; i < keys.size(); i++) {
            if (keys.get(i).equals(key)) {
                return values.get(i);
            }
        }
        return null;
    }

    public String get(int key) {
        checkReload();
        for (int i = 0; i < keys.size(); i++) {
            if (keys.get(i).equals("" + key)) {
                return values.get(i);
            }
        }
        return null;
    }

    public String getAbsPath() { return absPath; }
    
    public Boolean getBoolean(String key) {
        String value = get(key); // calls checkReload
        if (value != null) {
            if (value.toUpperCase().equals("TRUE")) return true;
            if (value.toUpperCase().equals("FALSE")) return false;
        }
        return null; // either unset or not a boolean
    }

    public Boolean getBooleanOrFalse(String key) {
        String value = get(key); // calls checkReload
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public Boolean getBooleanOrTrue(String key) {
        String value = get(key); // calls checkReload
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return true;
    }

    public Color getColor(String key) {
        String value = get(key); // calls checkReload
        if (value == null) return null;
        int rStart = value.indexOf("[") + 1;
        int rStop = value.indexOf(",");
        int gStart = rStop + 1;
        int gStop = value.indexOf(',',gStart + 1);
        int bStart = gStop + 1;
        int bStop = value.indexOf(",",bStart + 1);
        int aStart = bStop + 1;
        int aStop = value.length() - 1;
        int r = Integer.parseInt(value.substring(rStart,rStop));
        int g = Integer.parseInt(value.substring(gStart,gStop));
        int b = Integer.parseInt(value.substring(bStart,bStop));
        int a = Integer.parseInt(value.substring(aStart,aStop));
        return new Color(r,g,b,a);
    }
    
    public List<String> getCSV(String key) {
        String val = get(key); // calls checkReload();
        StringBuffer buf = new StringBuffer();
        List<String> result = new ArrayList<>();
        char ch;
        boolean insideQuotes = false;
        for(int i = 0; i < val.length();i++) {
            ch = val.charAt(i);
            if (ch == '\"' && !insideQuotes) {          // start working
                insideQuotes = true;                  
            } else if (insideQuotes && ch != '\"') {    // add until unquoted
                buf.append(ch);                       
            } else if (insideQuotes && ch == '\"') {    //unquoted add the buf to list
                result.add(buf.toString());                              
                buf = new StringBuffer();
                insideQuotes = false;
            } else if (ch == ',' && !insideQuotes) {    // skip commas inside quotes
                // do nothing, just skip over
            }
        }
        return result;
    }
    
    public double getDouble(String key) {
        String value = get(key); // calls checkReload
        return Double.parseDouble(value);
    }

    public String getFilename() {
        return absPath;
    }

    public Integer getInt(String key) {
        String sVal = (String) get(key); // calls checkReload
        // handle null
        if (sVal == null) {
            return null;
        }
        // return stored, write when setting
        return Integer.valueOf(sVal);
    }

    public int getIntOrZero(String key) {
        String sVal = (String) get(key); // calls checkReload
        if (sVal == null) {
            return 0;
        }
        return Integer.parseInt(sVal);
    }

    public String getKey(int index) {
        checkReload();
        return keys.get(index);
    }

    public List<String> getKeys() {
        checkReload();
        return keys;
    }

    /**
     *
     * @param key the 'key'
     * @return the 0 based index or -1 if not found
     */
    public int getKeyIndex(String key) {
        checkReload();
        for (int i = 0; i < keys.size(); i++) {
            if (keys.get(i).equals(key)) {
                return i;
            }
        }
        return -1;
    }

    public List<String> getList(String key) {
        String value = get(key); // calls checkReload
        if (value == null || value.equals("")) {
            return new ArrayList<String>();
        }
        return StringTool.explode(value, ',');
    }
    
    
    
    public Long getLong(String key) {
        String value = get(key); // already calls reload
        if (value != null) {
            return Long.valueOf(value);
        } else {
            return null;
        }
    }
    
    public Integer getIntOr0(String key) {
        Integer i = getInt(key); // getInt calls get, calls reload
        if (i == null) {
            return 0;
        } else {
            return (int) i;
        }
    }

    public List<String> getOutputList(boolean includeSystem) {
        checkReload(); // update to current data, if necessary
        List<String> output = new ArrayList<>();
        if (includeSystem) {
            String key;
            Enumeration javaKeys = System.getProperties().keys();
            while (javaKeys.hasMoreElements()) {
                key = (String)javaKeys.nextElement();
                if (key.equals("line.separator")) {
                    String val = System.getProperty(key);
                    if (val.equals("\n")) {
                        val = "\\n";
                    } else if (val.equals("\r\n")) {
                        val = "\\r\\n";
                    } else {
                        val = StringTool.replaceAll(val,'\n',"\\n");
                        val = StringTool.replaceAll(val,'\r',"\\r");
                    }
                    output.add(key + ": " + val);
                } else {
                    output.add(key + ": " + System.getProperty(key));
                }
            }
        }

        for (int i = 0; i < keys.size(); i++) {
            output.add(keys.get(i) + ": " + values.get(i));
        }
        return Sort.sort(output);
    }
    
    public Point getPoint(String key) {
        String value = get(key); // calls checkReload
        if (value != null && value.contains(",")) {
            String x = value.substring(0,value.indexOf(","));
            String y = value.substring(value.indexOf(",") + 1);
            return new Point(x,y);
        } else {
            return null;
        }
    }
    
    public String getPrintOutput() {
        checkReload();
        String s = "";
        for (int i = 0; i < keys.size(); i++) {
            s += i + ": Key: " + keys.get(i) + ": Value: " + values.get(i);
        }
        return s;
    }
    
    @Override
    public String getProperty(String key) {
        checkReload();
        return super.getProperty(key);
    }
    
    @Override
    public String getProperty(String key,String defaultValue) {
        checkReload();
        return super.getProperty(key,defaultValue);
    }

    public List<String> getSorted(boolean includeSystem) {
        List<String> data = Sort.getSorted(
                                     getOutputList(includeSystem) // calls checkReload
        );
        return data;
    }
    
    public java.util.Properties getSystem() {
        return parent;
    }
    
    public TColor getTColor(String key) {
        // return Color.BLACK if null
        Color c = getColor(key); // calls checkReload via get()
        if (c == null) {
            set(key,TecData.DEFAULT_COLOR);
            return new TColor(TecData.DEFAULT_COLOR);
        }
        return new TColor(c);
    } 

    public String getValue(int index) {
        checkReload();
        return values.get(index);
    }

    public List<String> getValues() {
        checkReload();
        return values;
    }

    /**
     *
     * @param index
     * @return the 0 based index or -1 if not found
     * @analysis does what it's told, huh. it!
     */
    public int getValueIndex(String value) {
        checkReload(); // always check for reload when accessing a key or value
        for (int i = 0; i < values.size(); i++) {
            if (values.get(i).equals(value)) {
                return i;
            }
        }
        return -1;
    }

    public boolean hasKey(String name) {
        return getKeys().contains(name); // getKeys calls checkReload
    }
    
    public boolean hasValue(String value) {
        return getValues().contains(value); // getValues call checkReload
    }
    
    public void increment(String key, int amount) {
        int val;
        String sVal = (String) get(key); // get calls checkReload
        if (sVal == null) {
            val = 0;
        } else {
            val = Integer.parseInt(sVal);
        }
//        System.out.println("Data.storage.increment: " + val);
        val += amount;
//        System.out.println("Data.storage.increment: " + val);
        set(key, val);
        setReload();
    }

    public void incrementLongString(Object src, String key) {
        set(key, StringTool.incrementLongString(get(key)));
        setReload();
    }

    public Boolean isStandalone() {
        return getBoolean("standalone"); // calls checkReload via get
    }
    
    public static void main(String[] args) {
        Properties props = new Properties(new File("\"C:\\Users\\tim\\Documents\\tecreations\\properties\\JavaLauncher_Apps.properties\""),true,true);
        System.out.println("Props: exists: " + new File(props.getFilename()));
        List<String> sorted = props.getSorted(true);
        Print.listString(sorted);
    }
 
    public void parse(String line) {
        // the key must start at the beginning of the line and be delimited by a colon.
        String key = "";
        if (line.contains(": ")) {
            key = line.substring(0, line.indexOf(": "));
        }
        // remove any whitespace
        try {
            String value = line.substring(line.indexOf(": ") + 2).trim();
            if (debug) {
                System.out.println("Parse: '" + line + "' : key: '" + key + "' : value: '" + value + "'");
            }
            for (int i = 0; i < keys.size(); i++) {
                if (keys.get(i).equals(key)) {
                    values.set(i, value);
                    return;
                }
            }
            keys.add(key);
            values.add(value); 
        } catch (StringIndexOutOfBoundsException sioobe) {
            keys.add(key);
            values.add("");
        }
        setReload();
    }
 
    public void print() {
        checkReload();
        for (int i = 0; i < keys.size(); i++) {
            System.out.println(i + ": Key: " + keys.get(i) + ": Value: " + values.get(i));
        }
    }

    public synchronized void read(boolean output) {
        if (debug) System.out.println("Reading properties file: '" + absPath + "'");
        File parent = new File(absPath).getDeepestDirectoryFile();
        
        if (!parent.exists()) {
            System.out.print("Creating parent directory: " + parent + " : " + parent.mkdirs() + " : Parent: " + parent.getAppPermissionsString());
            System.out.println();
        }
        if (!new File(absPath).exists()) {
            if (autoCreate) write();
            created = true;
        }
        if (new File(absPath).exists()) {
            synchronized (lock) {
                LineNumberReader reader = null;
                try {                              // here it might be wrapped, so unwrap the path
                    reader = new LineNumberReader(new FileReader(StringTool.getUnwrapped(absPath)));
                    //System.out.println("Reading: " + absPath);
                    try {
                        boolean done = false;
                        String line = "";
                        while (line != null) {
                            // so not a comment 
                            if (!line.startsWith("#")) {
                                // do we need to include comments?
                                if (!line.trim().equals("")) {
                                    // not an empty line, parse it
                                    parse(line);
                                }
                            }
                            line = reader.readLine();
                        }
                        reader.close();
                    } catch (IOException ioe) {
                        System.out.println("IO Exception: reading: " + absPath);
                    }
                } catch (FileNotFoundException fnfe) {
                    System.err.println("Properties: read: Unable to read file: " + absPath);
                }
            }
        }
        reloaders.remove(this);
    }
    
    public void reload() {
        keys = new ArrayList<>();
        values = new ArrayList<>();
        read(false); // removes reloader from list
    }
    
    public void reset() {
        keys = new ArrayList<>();
        values = new ArrayList<>();
        write();
        setReload();
    }

    public void reverse() {
        List<String> keys2 = new ArrayList<>();
        List<String> vals2 = new ArrayList<>();
        for (int i = keys.size() - 1; i >= 0; i--) {
            keys2.add(keys.get(i));
            vals2.add(values.get(i));
        }
        keys = keys2;
        values = vals2;
    }
    
    public void set(String key, String value) {
        set(key,value,true);
    }
        
    public void set(String key, String value, boolean write) {
        if (value == null) {
            value = "null";
        }
        int index = 0;
        boolean found = false;
        for (int i = 0; i < keys.size(); i++) {
            if (debug && verbose) {
                System.out.println("Checking[" + i + "/" + keys.size() + "]  : key: " + key + " value: " + value + " keys[i]: " + keys.get(i) + " values[i]: " + values.get(i));
            }
            if (keys.get(i).equals(key)) {
                index = i;
                found = true;     // and we found it
                break;
            }
        }
        if (debug) {
            System.out.println("delayWrite: " + delayWrite);
        }
        if (found) {
            values.set(index, value);
            super.put(key,value);
        } else {
            // add it
            keys.add(key);
            values.add(value);
            super.put(key,value);
            sortByKeys();
        }
        if (write) write();
        setReload();
    }
    
    public void set(String key, boolean val) {
        set(key, String.valueOf(val).toUpperCase());
    }

    public void set(String key, char val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, byte val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, int val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, short val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, long val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, float val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, double val) {
        set(key, String.valueOf(val));
    }

    public void set(String key, Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = c.getAlpha();
        set(key,"Color[" + r + "," + g + "," + b + "," + a + "]");
    }
    

    public void set(String key, Enumeration<String> enumeration) {
        String val = "";
        while (enumeration.hasMoreElements()) {
            val += enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                val += ",";
            }
        }
        set(key, val);
    }
    
    public void set(String key, List<String> list) {
        String value = "";
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size() - 1; i++) {
                value += list.get(i) + ",";
            }
            value += list.get(list.size() - 1);
        }
        set(key, value);
    }

    public void setEnumeration(String key, Enumeration<String> enumeration) {
        String val = "";
        while (enumeration.hasMoreElements()) {
            val += enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                val += ",";
            }
        }
        set(key, val);
    }

    public void set(String key, char[] chars) {
        StringBuffer value = new StringBuffer();
        for (int i = 0; i < chars.length; i++) {
            value.append(chars[i]);
        }
        set(key, value.toString());
    }

    public void setColors(String key, List<Color> colors) {
        String s = "";
        for (int i = 0; i < colors.size() - 1; i++) {
            s += colors.get(i) + "; ";
        }
        s += colors.get(colors.size() - 1);
        set(key, s);
    }

    public void set(String key, Point p) {
        set(key, p.toString());
    }

    public void setCreated(boolean flag) {
        created = flag;
    }

    public void setCSV(String key, List<String> vals) {
        String csv = "";
        String val;
        for(int i = 0; i < vals.size();i++) {
            val = vals.get(i);
            if (!val.startsWith("\"") && !val.endsWith("\"")) {
                csv += "\"" + val + "\"";
            } else {
                csv += val;
            }
            if (i < vals.size() - 1) csv += ",";
        }
        set(key,csv);
    }
    
    public void setDebug(boolean f) {
        debug = f;
    }

    /**
     * @param flag
     *
     * Sets or clears the delay write flag to postpone write()'s when setting.
     * Call storage.write() when done.
     */
    public void setDelayWrite(boolean flag) {
        delayWrite = flag;
    }

    public void setDelayWrite() {
        delayWrite = true;
    }

    public void setFilename(String absPath) {
        this.absPath = absPath;
        reload();
    }
    
    public void setListOfPoint(String key, List<Point> points) {
        String s = "";
        if (points.size() > 0) {
            for (int i = 0; i < points.size() - 1; i++) {
                s += points.get(i) + "; ";
            }
            s += points.get(points.size() - 1);
            set(key, s);
        }
    }

    public void setListOfPoint(String key, List<Point> points, boolean write) {
        String s = "";
        if (points.size() > 0) {
            for (int i = 0; i < points.size() - 1; i++) {
                s += points.get(i) + "; ";
            }
            s += points.get(points.size() - 1);
        }
        set(key, s,write);
    }

    public void setReload() {
        String path = absPath;
        List<Properties> newReloaders = new ArrayList<>();
        List<Properties> outdated = instances.get(path);
        for(int i = 0; i < reloaders.size();i++) newReloaders.add(reloaders.get(i));
        Properties props;
        if (outdated == null) outdated = new ArrayList<Properties>();
        for(int i = 0; i < outdated.size();i++) {
            props = outdated.get(i);
            if (!newReloaders.contains(props) && !props.equals(this)) {
                newReloaders.add(props);
            }
        }
        reloaders = newReloaders;
    }
    
    
    public void sortByKeys() {
        // x becomes --> names, so values gets placed there also, watch
        int j;
        boolean flag = true;  // will determine when the sort is finished
        String tempName, tempValue;
        while (flag) {
            flag = false;
            for (j = 0; j < keys.size() - 1; j++) {
                if (keys.get(j).compareToIgnoreCase(keys.get(j + 1)) > 0) {
                    // ascending sort
                    tempName = keys.get(j);
                    tempValue = values.get(j);
                    keys.set(j, keys.get(j + 1));
                    values.set(j, values.get(j + 1));     // swapping
                    keys.set(j + 1, tempName);
                    values.set(j + 1, tempValue);
                    flag = true;
                }
            }
        }
    }

    public String toString() {
        String s = "Properties: " + getFilename() + "\n";
        for (int i = 0; i < keys.size(); i++) {
            s += "Key: " + keys.get(i) + "  Value: " + values.get(i) + "\n";
        }
        return s;
    }

    public boolean wasCreated() {
        return created;
    }

    /**
     * Writes the keys & values to the data store and clears the delayWrite
     * flag, if set.
     */
    public void write() {
        synchronized (lock) {
            PrintWriter out = null;
            try {
                out = new PrintWriter(StringTool.getUnwrapped(absPath));
                for (int i = 0; i < keys.size(); i++) {
                    out.println(keys.get(i) + ": " + values.get(i));
                }
                out.flush();
                out.close();
                delayWrite = false; // written, clear delayWrite
                if (debugWrite) {
                    System.out.println("Properties: Wrote: " + absPath);
                }
            } catch (IOException ioe) {
                System.out.println("Unable to create/open: " + absPath);
            }
        }
    }
}
