package ca.tecreations;

import java.awt.Color;
import java.awt.Graphics;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Tim
 */
public class CursorData {

    public static int numCursors = 0;
    String name = "CursorData" + ++numCursors;
    public int width = -1;
    public int height = -1;
    List<Pixel> pixels = new ArrayList<>();
    List<Point> maskPoints = new ArrayList<>();
    Point hotSpot = new Point(0, 0);
    public static final TColor DEFAULT_OUTLINE_COLOR = TColor.black;
    TColor outlineColor = DEFAULT_OUTLINE_COLOR;

    public static boolean debug = true;
    public static boolean verbose = true;

    public CursorData(String name, int width, int height, List<Pixel> pixels,
            List<Point> maskPoints, Point hotSpot, Color outlineColor) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.maskPoints = maskPoints;
        this.hotSpot = hotSpot;
        this.outlineColor = new TColor(outlineColor);
    }

    public int getHeight() {
        return height;
    }

    public Point getHotSpot() {
        return hotSpot;
    }

    public List<Point> getMaskPoints() {
        return maskPoints;
    }

    public String getName() {
        return name;
    }

    public Color getOutlineColor() { return outlineColor; }
    
    public List<Pixel> getPixels() {
        return pixels;
    }

    public String getPixelsCSV() {
        String csv = "";
        for (int i = 0; i < pixels.size() - 2; i++) {
            csv += pixels.get(i).toExternal() + ",";
        }
        csv += pixels.get(pixels.size() - 1).toExternal();
        return csv;
    }

    public int getWidth() {
        return width;
    }

    public void paintAt(Graphics g, int x, int y) {
        int outlineRGB = outlineColor.getRGB();
        int defaultRGB = DEFAULT_OUTLINE_COLOR.getRGB();
        Pixel p;
        if (outlineRGB == defaultRGB) {
            for (int i = 0; i < pixels.size(); i++) {
                p = pixels.get(i);
                if (pixels.get(i).getColor().getRGB() == defaultRGB) {
                    int x2 = x + p.getX();
                    int y2 = y + p.getY();
                    g.setColor(DEFAULT_OUTLINE_COLOR);
                    g.drawLine(x2, y2, x2, y2);
                } else {
                    g.setColor(p.getColor());
                    g.drawLine(x + p.getX(), y + p.getY(), x + p.getX(), y + p.getY());
                }
            }
        } else {
            for (int i = 0; i < pixels.size(); i++) {
                p = pixels.get(i);
                if (pixels.get(i).getColor().equals(DEFAULT_OUTLINE_COLOR)) {
                    int x2 = x + p.getX();
                    int y2 = y + p.getY();
                    g.setColor(outlineColor);
                    g.drawLine(x2, y2, x2, y2);
                } else {
                    g.setColor(p.getColor());
                    g.drawLine(x + p.getX(), y + p.getY(), x + p.getX(), y + p.getY());
                }
            }
        }
    }

    public void setHeight(int height) { this.height = height; }

    public void setHotSpot(Point hotSpot) { this.hotSpot = hotSpot; }
    
    public void setMaskPoints(List<Point> maskPoints) { this.maskPoints = maskPoints; }
    
    public void setName(String name) { this.name = name; }
    
    public void setOutlineColor(Color c) { outlineColor = new TColor(c); }
    
    public void setPixels(List<Pixel> pixels) { this.pixels = pixels; }
    
    public void setWidth(int width) { this.width = width; }
    
    
    
    public String toString() { 
        String result = "\nCursor  : " + name + 
                        "\n  width : " + width +
                        "\n  height: " + height + 
                        "\nPixels  : " + pixels + 
                        "\nMask Pts: ";
        for(int i = 0;i < maskPoints.size() - 1;i++) {
            result += maskPoints.get(i) + ",";
        }
        if (maskPoints.size() > 0) {
            result += maskPoints.get(maskPoints.size() - 1);
        }
        result += "\nHotSpot : " + hotSpot + "\n" +
                  "\nOutline  : " + outlineColor;
        return result;
    }
}
