package ca.tecreations.wip.toy.editors;

import ca.tecreations.*;
import ca.tecreations.components.*;
import ca.tecreations.text.*;

import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class TextEditor extends JPanel implements Editor {
    public static TextPoints points = CodeEdit.points;
    public static final String SN = TextEditor.class.getSimpleName();
    public static boolean debug = true;
    
    TextPanel textPanel;
    JScrollPane scroller;
    JScrollBar hsb;
    JScrollBar vsb;

    
    
    public TextEditor(int width, int height) {
        super(true); //width,height);
        setLayout(new BorderLayout());
        textPanel = new TextPanel(this, width*2,height*2);
        scroller = new JScrollPane(textPanel, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        scroller.setSize(width,height);
        add(scroller,BorderLayout.CENTER);
        validate();
        hsb = scroller.getHorizontalScrollBar();
        vsb = scroller.getVerticalScrollBar();
        hsb.setUnitIncrement(16);
        vsb.setUnitIncrement(16);
    }
    
    public void computeScrollerValues() {
        double hPercent;
        double hVisible;
        double hOnePercent;
        double hScrollerOnePercent;
        
        double vPercent;
        double vVisible;
        double vOnePercent;
        double vScrollerOnePercent;
        
        vOnePercent = (double) textPanel.getSize().height / (double) 100;
        vScrollerOnePercent = (double) vsb.getSize().height / (double) 100;
        vVisible = (double) vsb.getSize().height / vOnePercent;

        hOnePercent = (double) textPanel.getSize().width / (double) 100;
        hScrollerOnePercent = (double) hsb.getSize().width / (double) 100;
        hVisible = (double) hsb.getSize().width / hOnePercent;

        if (hVisible > 100.0) hVisible = 100.0;
        if (vVisible > 100.0) vVisible = 100.0;
        
        //System.out.println("hVisible: " + hVisible + " vVisible: " + vVisible);                    
        hsb.setValues(hsb.getValue(),(int)hVisible,0,100 - (int)hVisible);
        vsb.setValues(vsb.getValue(),(int)vVisible,0,100 - (int)vVisible);
    }
    
    public JScrollBar getHSB() { return hsb; }

    public int getLineCount() { return textPanel.getPainters().size(); }
    
    public JPanel getPanel() { return textPanel; }
    
    public TextPoints getPoints() { return points; }

    public JScrollPane getScroller() { return scroller; }
    
    public JScrollBar getVSB() { return vsb; }

    public void open(String path) {
        if (!new File(path).exists()) {
            System.err.println("Path does not exist: " + path);
            return;
        }
        TextFile file = new TextFile(path);
        List<String> lines = file.getLines();
        while (scroller == null) Platform.sleep(125);
        for(int i = 0; i < lines.size();i++) {
            //System.out.println("Lines[" + (i+1) + "]: " + lines.get(i));
            tokenizeAndAdd(lines.get(i));
        }
        computeScrollerValues();
        repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
    }
    
    public void tokenizeAndAdd(String s) {
        LineOfTextTokenPainter painter = new LineOfTextTokenPainter(points);
        TextToken token = new TextToken();
        for(int i = 0;i < s.length();i++) {
            if (s.charAt(i) == ' ') {
                if (token.length() > 0) {
                    painter.addPainter(new TextTokenPainter(points,token,textPanel.getForeground()));
                    token = new TextToken();
                }
                painter.addPainter(new TextTokenPainter(points, new TextToken(" "),textPanel.getForeground()));
            } else {
                token.add(s.charAt(i));
            }
        }
        if (token.length() > 0) {
            painter.addPainter(new TextTokenPainter(points,token,textPanel.getForeground()));
        }
        painter.setBackground(textPanel.getBackground());
        textPanel.addLine(painter);
    }
    
    
}
