package ca.tecreations.misc;

import ca.tecreations.Platform;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Tim
 */
public class TString {

    public static String ASCII = "";
    static {
        for(int i = 0; i < 256;i++) {
            ASCII += (char)i;
        }
    }
    
    public static final int BIG_ALPHA_NUM = 0;
    public static final int BRUTE_FORCE =   1;
    public static final int GOOGLE_PASSES = 2;
    public static final int MYSQL_PASSES =  3;
    public static final int MYSQL_TEXT =    4;
    public static final int TECREMENTER =   5;

    public static final String digits = "0123456789";
    public static final String lower = "abcdefghijklmnopqrstuvwxyz";
    public static final String upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String symbols = ".,/?\\|&^%$#@!=-_*[]{}()<>`" + "\'\";:";
    
    private static String bigAlphaNum = digits + lower + upper;
    private static String bruteForce = ASCII;
    private static String googlePasses = digits + lower + upper + "$";
    private static String linuxPasses = digits + lower + upper + "$";
    private static String mysqlPasses = digits + lower + upper + "$";
    private static String mysqlText = digits + lower + upper + "$";
    private static String tecrementer = "$" + digits + lower + upper;

    int compatibility = TECREMENTER;
    public String string = "";

    public TString() {
        string = "" + tecrementer.charAt(0);
    }

    public TString(int compatibility) {
        this.compatibility = compatibility;
        if (compatibility == BIG_ALPHA_NUM) {
            string = "" + bigAlphaNum.charAt(0);
        } else if (compatibility == BRUTE_FORCE) {
            string = "" + bruteForce.charAt(0);
        } else if (compatibility == GOOGLE_PASSES) {
            string = "" + googlePasses.charAt(0);
        } else if (compatibility == MYSQL_PASSES) {
            string = "" + mysqlPasses.charAt(0);
        } else if (compatibility == MYSQL_TEXT) {
            string = "" + mysqlText.charAt(0);
        } else if (compatibility == TECREMENTER) {
            string = "" + tecrementer.charAt(0);
        } else {
            throw new IllegalArgumentException("TString(" + compatibility + "): Unknown Compatibility");
        }
    }

    public TString(int compatibility, String string) {
        this.compatibility = compatibility;
        this.string = string;
        if (string.length() == 0) {
            if (compatibility == BIG_ALPHA_NUM) {
                string = "" + bigAlphaNum.charAt(0);
            } else if (compatibility == BRUTE_FORCE) {
                string = "" + bruteForce.charAt(0);
            } else if (compatibility == GOOGLE_PASSES) {
                string = "" + googlePasses.charAt(0);
            } else if (compatibility == MYSQL_PASSES) {
                string = "" + mysqlPasses.charAt(0);
            } else if (compatibility == MYSQL_TEXT) {
                string = "" + mysqlText.charAt(0);
            } else if (compatibility == TECREMENTER) {
                string = "" + tecrementer.charAt(0);
            } else {
                throw new IllegalArgumentException("TString(" + compatibility + "): Unknown Compatibility");
            }
        }
    }

    public TString(int compatibility, int length) {
        this.compatibility = compatibility;
        this.string = getRandom(compatibility,length).toString();
    }
    
    public void add(char ch) {
        string += ch;
    }

    public void add(String s) {
        string += s;
    }

    public char getFirstChar() {
        if (compatibility == BIG_ALPHA_NUM) {
            return bigAlphaNum.charAt(0);
        } else if (compatibility == BRUTE_FORCE) {
            return bruteForce.charAt(0);
        } else if (compatibility == GOOGLE_PASSES) {
            return googlePasses.charAt(0);
        } else if (compatibility == MYSQL_PASSES) {
            return mysqlPasses.charAt(0);
        } else if (compatibility == MYSQL_TEXT) {
            return mysqlText.charAt(0);
        } else if (compatibility == TECREMENTER) {
            return tecrementer.charAt(0);
        }
        return (char) -1;
    }

    public char getNextChar(int index) {
        char ch = '\0';
        if (compatibility == BIG_ALPHA_NUM) {
            int repIndex = bigAlphaNum.indexOf(string.charAt(index));
            if (repIndex < bigAlphaNum.length() - 1) {
                ch = bigAlphaNum.charAt(repIndex + 1);
            } else {
                ch = getFirstChar();
            }
        } else if (compatibility == BRUTE_FORCE) {
            int repIndex = bruteForce.indexOf(string.charAt(index));
            if (repIndex < bruteForce.length() - 1) {
                ch = bruteForce.charAt(repIndex + 1);
            } else {
                ch = getFirstChar();
            }
        } else if (compatibility == GOOGLE_PASSES) {
            int repIndex = googlePasses.indexOf(string.charAt(index));
            if (repIndex < googlePasses.length() - 1) {
                ch = googlePasses.charAt(repIndex + 1);
            } else {
                ch = getFirstChar();
            }
        } else if (compatibility == MYSQL_PASSES) {
            int repIndex = mysqlPasses.indexOf(string.charAt(index));
            if (repIndex < mysqlPasses.length() - 1) {
                ch = mysqlPasses.charAt(repIndex + 1);
            } else {
                ch = getFirstChar();
            }
        } else if (compatibility == MYSQL_TEXT) {
            int repIndex = mysqlText.indexOf(string.charAt(index));
            if (repIndex < mysqlText.length() - 1) {
                ch = mysqlText.charAt(repIndex + 1);
            } else {
                ch = getFirstChar();
            }
        } else if (compatibility == TECREMENTER) {
            int repIndex = tecrementer.indexOf(string.charAt(index));
            if (repIndex < tecrementer.length() - 1) {
                ch = tecrementer.charAt(repIndex + 1);
            } else {
                ch = getFirstChar();
            }
        } else {
            throw new IllegalArgumentException("TimString.getNextChar: invalid compatibility: " + compatibility);
        }
        return ch;
    }

    public static TString getRandom(int compatibility, int length) {
        TString tString = new TString(compatibility);
        for (int i = 0; i < length - 1; i++) {
            if (compatibility == BIG_ALPHA_NUM) {
                tString.add(bigAlphaNum.charAt(Platform.getRandom(bigAlphaNum.length())));
            } else if (compatibility == BRUTE_FORCE) {
                tString.add(bruteForce.charAt(Platform.getRandom(bruteForce.length())));
            } else if (compatibility == GOOGLE_PASSES) {
                tString.add(googlePasses.charAt(Platform.getRandom(googlePasses.length())));
            } else if (compatibility == MYSQL_PASSES) {
                tString.add(mysqlPasses.charAt(Platform.getRandom(mysqlPasses.length())));
            } else if (compatibility == MYSQL_TEXT) {
                tString.add(mysqlText.charAt(Platform.getRandom(mysqlText.length())));
            } else if (compatibility == TECREMENTER) {
                tString.add(tecrementer.charAt(Platform.getRandom(tecrementer.length())));
            }
        }
        return tString;

    }

    public void increment() {
        String result = "";
        int index = string.length() - 1;
        while (index > 0 && isCompatMax(index)) {
            index--;
        }
        if (index == 0) {
            String s = "";
            for (int i = 0; i < string.length() + 1; i++) {
                s += getFirstChar();
            }
            string = s;
        } else if (!isCompatMax(index)) {
            setCharAt(index, getNextChar(index));
            index++;
            for (int i = index; i < string.length(); i++) {
                setCharAt(i, getNextChar(i));
            }
        } else {
            int idx = string.length() - 1;
            setCharAt(idx, getNextChar(idx));
        }
    }

    public int indexOf(char ch) {
        return string.indexOf(ch);
    }

    public boolean isCompatMax(int index) {
        if (compatibility == BIG_ALPHA_NUM) {
            if (string.charAt(index) == bigAlphaNum.charAt(bigAlphaNum.length() - 1)) {
                return true;
            }
        } else if (compatibility == BRUTE_FORCE) {
            if (string.charAt(index) == bruteForce.charAt(bruteForce.length() - 1)) {
                return true;
            }
        } else if (compatibility == GOOGLE_PASSES) {
            if (string.charAt(index) == googlePasses.charAt(googlePasses.length() - 1)) {
                return true;
            }
        } else if (compatibility == MYSQL_PASSES) {
            if (string.charAt(index) == mysqlPasses.charAt(mysqlPasses.length() - 1)) {
                return true;
            }
        } else if (compatibility == MYSQL_TEXT) {
            if (string.charAt(index) == mysqlText.charAt(mysqlText.length() - 1)) {
                return true;
            }
        } else if (compatibility == TECREMENTER) {
            if (string.charAt(index) == tecrementer.charAt(tecrementer.length() - 1)) {
                return true;
            }
        }
        return false;
    }

    public int length() {
        return string.length();
    }

    public static void main(String[] args) {
        System.out.println(getRandom(TString.BRUTE_FORCE, 18));
        
         
        //TimString timString = new TimString();
        //while (timString.length() < 8) {
        //    timString.increment();
        //    System.out.println(timString);
        //}
    }

    public void setCharAt(int index, char ch) {
        String tmp = string.substring(0, index); // add previous
        tmp += ch;   // index position
        if (index < string.length() - 1) { // add trailing
            tmp += string.substring(index + 1, string.length());
        }
        string = tmp;
    }

    public String toRandom() {
        String result = "";
        if (compatibility == BIG_ALPHA_NUM) {
            for (int i = 0; i < string.length(); i++) {
                result += bigAlphaNum.charAt(Platform.getRandom(bigAlphaNum.length()));
            }
        } else if (compatibility == BRUTE_FORCE) {
            for (int i = 0; i < string.length(); i++) {
                result += bruteForce.charAt(Platform.getRandom(bruteForce.length()));
            }
        } else if (compatibility == GOOGLE_PASSES) {
            for (int i = 0; i < string.length(); i++) {
                result += googlePasses.charAt(Platform.getRandom(googlePasses.length()));
            }
        } else if (compatibility == MYSQL_PASSES) {
            for (int i = 0; i < string.length(); i++) {
                result += mysqlPasses.charAt(Platform.getRandom(mysqlPasses.length()));
            }
        } else if (compatibility == MYSQL_TEXT) {
            for (int i = 0; i < string.length(); i++) {
                result += mysqlText.charAt(Platform.getRandom(mysqlText.length()));
            }
        } else if (compatibility == TECREMENTER) {
            for (int i = 0; i < string.length(); i++) {
                result += tecrementer.charAt(Platform.getRandom(tecrementer.length()));
            }
        }
        string = result;
        return string;
    }

    public String toString() {
        return string;
    }

    public String toZeros() {
        String result = "";
        for (int i = 0; i < string.length(); i++) {
            result += "0";
        }
        string = result;
        return string;
    }

}
