package ca.tecreations.lang.java;
import ca.tecreations.StringTool;
/**
 *
 * @author tim
 */
public class ShortPackageAndName {
    public static String getFor(String fqcn) {
        String newString = "";
        while (fqcn.contains(".")) {
            newString += fqcn.charAt(0) + ".";
            fqcn = fqcn.substring(fqcn.indexOf(".") + 1); // skip the dot, take what's left
        }
        newString += fqcn; // now it's just the name
        return newString;
    }
    
    
    public static String getClassName(String fqcn) {
        return fqcn.substring(fqcn.lastIndexOf(".") + 1);
    }
    
    public static String getFor(String fqcn,int maxLength) {
        int halfWidth = maxLength / 2;
        String className = getClassName(fqcn);
        String classInitials = getClassInitials(className);
        String classPart;
        String pkg = "";
        
        // do for class
        if (fqcn.contains(".")) pkg = fqcn.substring(0,fqcn.lastIndexOf("."));
        if (className.length() > halfWidth) {
            classPart = classInitials;
            if (classPart.length() > halfWidth) {
                classPart = classPart.substring(0,halfWidth - 1);
            }
        } else {
            classPart = className;
        }
        
        // do for package
        int lastIndex = fqcn.lastIndexOf(".");
        if (lastIndex > 0) pkg = fqcn.substring(0,lastIndex);
        int newMaxLength = maxLength - classPart.length();
        //System.out.println("New MaxLength: " + newMaxLength);
        if (pkg.length() > 0) {
            pkg = getShortenedPackage(pkg,newMaxLength - 1); // don't forget the dot separator
        }
        if (pkg.length() > 0) {
            return pkg + "." + classPart;
        } else {
            return classPart;
        }
    }
    
    public static char getNextChar(String data,String current) {
        if (data.length() < current.length()) throw new IllegalArgumentException("Data string must be longer than current string: " + data + " : " + current);
        return data.charAt(current.length());
    }
    
    public static String getPackageName(String fqcn) {
        //System.out.println("ShortPackageAndName.GetPackageName: " + fqcn);
        return fqcn.substring(0,fqcn.lastIndexOf("."));
    }
    
    public static boolean hasRoomToAdd(String[] parts,String[] ids) {
        for(int i = 0; i < parts.length;i++) {
            if (parts[i].length() > ids[i].length()) return true;
        }
        return false;
    }
    
    public static String getClassInitials(String target) {
        if (target == null) throw new IllegalArgumentException("You must provide a non-null string of length > 0");
        if (target.length() == 0) throw new IllegalArgumentException("You must provide a non-null string of length > 0");
        String result = "";
        char ch;
        for(int i = 0; i < target.length();i++) {
            ch = target.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                result += target.charAt(i);
            }
        }
        return result;
    }
    
    public static String getPackageInitials(String pkg, int countPerPkg) {
        String result = "";
        int dotCount = StringTool.getCount(pkg,'.');
        
        return result;
    }
    
    public static String getShortPackage(String pkg, int pkgIndex, int count) {
        //System.out.println("Pkg: " + pkg + " Count: " + StringTool.getCount(pkg,'.'));
        if (!(pkgIndex <= StringTool.getCount(pkg,'.'))) throw new IllegalArgumentException("Pkg(" + pkg + "): Must contain at least pkgIndex: " + pkgIndex + " dots");
        String remainder = pkg;
        int index;
        String longPackage = "";
        for(int i = 0; i <= pkgIndex - 1;i++) {
            index = remainder.indexOf('.');
            longPackage = remainder.substring(0,index);
            remainder = remainder.substring(index + 1);
            //System.out.println("LongPackage: " + longPackage + " Remainder: " + remainder + " Index: " + index);
        }
        if (remainder.contains(".")) {
            longPackage = remainder.substring(0,remainder.indexOf("."));
        } else {
            longPackage = remainder;
        }
        return longPackage.substring(0,Math.min(longPackage.length(),count));
    }
    
    public static String getShortenedPackage(String pkg, int maxLength) {
        int dotCount = StringTool.getDotCount(pkg);
        int blocks = dotCount + 1;
        int maxPerBlock = (maxLength - dotCount) / blocks;
        //System.out.println("Pkg: " + pkg + " Max: " + maxLength + " DotCount: " + dotCount + " MaxPerBlock: " + maxPerBlock);
        String result = "";
        String shortened;
        for(int i = 0; i < dotCount;i++) {
            shortened = getShortPackage(pkg,i,maxPerBlock);
            result += shortened + ".";
        }
        maxPerBlock = maxLength - result.length();
        shortened = getShortPackage(pkg,dotCount,maxPerBlock);
        result += shortened;
        return result;
    }
    
    public static void main(String[] args) {
        
//        System.out.println("ca.tecreations.BlameTim: " + ShortPackageAndName.getFor("ca.tecreations.BlameTim"));
//        System.out.println("ca.tecreations.BuildProject(24): " + ShortPackageAndName.getFor("ca.tecreations.BuildProject",24));
        //System.out.println("ca.tecreations.BuildProject(24): " + ShortPackageAndName.getFor("ca.tecreations.BuildProject",24,Left_To_Right_GREEDY));
        //System.out.println("ca.tecreations.BuildProject(24): " + ShortPackageAndName.getFor("ca.tecreations.BuildProject",24,Left_To_Right_PROPORTIONAL));
        
//        System.out.println("ca.tecreations.BuildProject: " + ShortPackageAndName.getFor("ca.tecreations.BuildProject"));
        // transpose to::: -vVyyY
//        System.out.println("BuildThisDir");
//        System.out.println("BuildThisProject");
        // is your cycle changing this data?
//        System.out.println("GetShortest: BuildThisDir: expecting: BTD: actual: " + getClassInitials("BuildThisDir"));
//        System.out.println("BuildThisDir: " + getFor("BuildThisDir"));

//        System.out.println("Expecting: 'tec' : " + getShortPackage("ca.tecreations.apps.javacompiler.JavaCompilerController",2,3));
//        System.out.println("Expecting: 'ap' : " + getShortPackage("ca.tecreations.apps.javacompiler.JavaCompilerController",3,2));
//        System.out.println("Expecting: 'ca' : " + getShortPackage("ca.tecreations.apps.javacompiler.JavaCompilerController",1,5)); // first for..., upto max 5
       
//        System.out.println("GetNextChar: abcdefghi: abcd: e?: " + getNextChar("abcdefghi","abcd"));
        
//        System.out.println("Expecting: 'ca.tec.ap.ja.JCC' : " + getFor("ca.tecreations.apps.javacompiler.JavaCompilerController",16));
        System.out.println("Expecting: 'ca.tecreations.SystemTool' : " + getFor("ca.tecreations.SystemTool",22));

//        System.out.println("GetShortPackage: ca.tecreations.apps.[java]compiler: " + 
//                getShortPackage("ca.tecreations.apps.javacompiler",3,4));
//        System.out.println("GetShortenedPackage: ca.tecreations.apps.javacompiler: " + 
//                getShortenedPackage("ca.tecreations.apps.test.javacompiler",20));
    }
}
