package ca.tecreations.lang.java;

import ca.tecreations.File;
import ca.tecreations.Pair;
import ca.tecreations.ProjectPath;

import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 */
public class GetJarFiles {
    List<File> jarsFiles = new ArrayList<>();
    
    public GetJarFiles(String projectPath) {
        String jarsPath = new ProjectPath("GetJarFiles",projectPath).getJarsPath();
        process(jarsPath);
    }
    
    public List<File> getFiles() { return jarsFiles; }
    
    public void process(String absPath) {
        Pair pair = new Pair(absPath);
        List<File> dirs = pair.getDirs();
        List<File> files = pair.getFiles();
        List<File> jars = new ArrayList<>();
        for(int i = 0; i < files.size();i++) {
            if (files.get(i).getExtension().equals("jar")) {
                jars.add(files.get(i));
            }
        }
        for(int i = 0; i < jars.size();i++) {
            jarsFiles.add(jars.get(i));
        }
        
        for(int i = 0; i < dirs.size();i++) process(dirs.get(i).getAbsolutePath());
    }
    
    public static void main(String[] args) {
        List<File> jars = new GetJarFiles("auth-server-5").getFiles();
        for(int i = 0; i < jars.size();i++) {
            System.out.println(i + ": " + jars.get(i).getUnwrapped());
        }
    }
}
