package ca.tecreations.interfaces;

import ca.tecreations.text.TextPoints;

import java.awt.Color;
import java.awt.Graphics;
/**
 *
 * @author Tim
 */
public interface TextPainter extends Paintable {
    public int getFontSize();
    
    public int getMaxDescent(); // should be roughly equivalent to Font.getSize()
    
    public String getText();
    
    public int getTextWidth();
    
    public void paintAt(Graphics g, int x, int y);
    
    public void setBackground(Color c);
    
    public void setFillColor(Color c);

    public void setLineColor(Color c);
    
    public void setPoints(TextPoints points);
    
    public void setText(String text);
}
