package ca.tecreations.db.mysql;

import ca.tecreations.Platform;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/**
 *
 * @author tim
 */
public class GetMySQLConnection {
    MySQL mysql;

    public GetMySQLConnection(MySQL mysql) {
        this.mysql = mysql;
    }

    public Connection getConnection() {
        Connection connection = null;
        for (int i = 0; i < 10; i++) {
            String err = "";
            System.out.print("GetMySQLConnection");
            System.out.print(": Attempting to connect(" + i + ") : ");
            if (mysql.isDataSource) {
                try {
                    mysql.setConnection(mysql.dataSource.getConnection());
                } catch (SQLException sqle) {
                    mysql.setSQLException(sqle);
                    err = "Exception: attempt to connect to DataSource failed: " + sqle;
                }
            } else {
                try {
                    mysql.setConnection(DriverManager.getConnection(mysql.url));
                } catch (SQLException sqle) {
                    mysql.setSQLException(sqle);
                    err = "Exception: attempt to connect to URL failed: "  + sqle;
                }
            }
            SQLException sqle = mysql.getSQLException();
            if (sqle != null) {
                String eStr = sqle.toString();
                if (eStr.contains("Access denied")) {
                    System.out.println(err);
                    System.err.println("Invalid credentials.");
                    return null;
                }
            }
            if (!err.equals("")) {
                System.out.println(": Error:");
                System.out.print(err);
            } else {
                if (mysql.getConnection() == null) {
                    System.out.print(": null : sleeping(125)...");
                    Platform.sleep(125);
                } else {
                    System.out.print(": connected.");
                }
            }
            System.out.println();
            if (mysql.getConnection() != null) return mysql.getConnection();
        }
        if (mysql.getConnection() == null) {
            System.err.println("After 10 attempts, Connection is still NULL!!!");
        }
        return null;
    }
    
    public static void main(String[] args) {
        char[] pass = "hnQ4]0U.51Ycs41B".toCharArray();
        MySQL mysql = new MySQL("tecreations.ca",3306,"sitedb","user",pass);
        
        char[] pass2 = "bW$(X8x4|QT~oYq8".toCharArray();
        MySQL mysql2 = new MySQL("tecreations.ca",3306,"sitedev_demo","sitedev_demo_user",pass2);
        
        char[] pass3 = "X[Mq5_r6D_na=cW8".toCharArray();
        MySQL mysql3 = new MySQL("tecreations.ca",3306,"sitesec_dev","sitesec_user",pass3);
        
        GetMySQLConnection getter = new GetMySQLConnection(mysql);
        GetMySQLConnection getter2 = new GetMySQLConnection(mysql2);
        GetMySQLConnection getter3 = new GetMySQLConnection(mysql3);
        
    }
}