package ca.tecreations.apps._gui.renderer;

import ca.tecreations.TColor;
import ca.tecreations.FileEntry;

import java.awt.Component;

import javax.swing.*;
import javax.swing.table.TableCellRenderer;

/**
 *
 * @author tim
 */
public class FileSizeRenderer extends JLabel implements TableCellRenderer {

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected,
            boolean hasFocus, int row, int column) {
        setOpaque(true);
        FileEntry entry = (FileEntry) value;
        String sizeString = "";
        if (entry != null) {
            sizeString = entry.getSizeString();
            if (sizeString.equals("GET") && entry.getSizeLong() == -1) {
                setText("Getting...");
                setHorizontalAlignment(SwingConstants.CENTER);
                setForeground(TColor.TEC_LIGHT_GREEN);
            } else if (entry.getSizeLong() != -1) {
                String newSize = getHumanReadable(Long.toString(entry.getSizeLong()));
                setText(newSize);
                setHorizontalAlignment(SwingConstants.RIGHT);
                setForeground(TColor.BLACK);
            }
            if (entry.isSelected()) {
                setOpaque(true);
                setBackground(TColor.TEC_SELECTED);
            } else {
                setOpaque(false);
                setBackground(table.getBackground());
            }
        }
        return this;
    }

    public static String getHumanReadable(String sizeAsLong) {
        if (sizeAsLong.equals("")) return "";
        long longSize = Long.parseLong(sizeAsLong);
        long KB = longSize / 1024;
        long remainder = 0L;
        String decimal = "";
        if (KB < 1024) {
            remainder = longSize - (KB * 1024);
            decimal = "" + remainder;
            return KB + "." + decimal.charAt(0) + " KB";
        } else {
            long MB = longSize / (long) Math.pow(1024, 2);
            remainder = longSize - (MB * (long) Math.pow(1024, 2));
            decimal = "" + remainder;
            if (MB < 1024) {
                return MB + "." + decimal.charAt(0) + " MB";
            } else {
                long GB = longSize / (long) Math.pow(1024, 3);
                remainder = longSize - (GB * (long) Math.pow(1024, 3));
                decimal = "" + remainder;
                return GB + "." + decimal.charAt(0) + " GB";
            }
        }
    } 
    
    public static void main(String[] args) {
        
    }
}
