package ca.tecreations;

import java.awt.*;
import javax.swing.*;
/**
 *
 * @author Tim
 */
public class Sizer {
    public static final Rectangle screenSize = Platform.getDesktopSize();
    public static Sizer SIZER = new Sizer();

    public JFrame sizerFrame = new JFrame();
    public JPanel sizerPanel = new JPanel(new BorderLayout(0,0));
    
    public static Dimension MAX_CONTENT_SIZE;
    
    public static int TASK_BAR_HEIGHT = 0;
    public static int TASK_BAR_WIDTH = 0;
    
    public static int FRAME_THICKNESS = 0;
    public static int TITLE_HEIGHT = 0;
    
    public static boolean debug = false;
    
    public Sizer() {
        sizerFrame.setVisible(true);
        sizerFrame.toBack();
        sizerFrame.setExtendedState(JFrame.MAXIMIZED_BOTH);
        sizerFrame.add(sizerPanel,BorderLayout.CENTER);
        sizerFrame.validate();
        MAX_CONTENT_SIZE = sizerPanel.getSize();
        if (MAX_CONTENT_SIZE.width != screenSize.width) {
            TASK_BAR_WIDTH = screenSize.width - MAX_CONTENT_SIZE.width;
        }
        if (MAX_CONTENT_SIZE.height != screenSize.height) {
            TASK_BAR_HEIGHT = screenSize.height - MAX_CONTENT_SIZE.height;
        }
        sizerFrame.setExtendedState(JFrame.NORMAL);
        sizerFrame.setSize(320,240);
        sizerFrame.revalidate();
        FRAME_THICKNESS = (320 - sizerPanel.getSize().width) / 2;
        TITLE_HEIGHT = (240 - sizerPanel.getSize().height) - (2 * FRAME_THICKNESS);
        sizerFrame.setVisible(false);
        sizerFrame.dispose();
        System.gc();
        if (debug) {
            System.out.println("ScreenSize      : " + screenSize);
            System.out.println("TASKBAR_HEIGHT  : " + TASK_BAR_HEIGHT);
            System.out.println("TASKBAR_WIDTH   : " + TASK_BAR_WIDTH);
            System.out.println("MAX_CONTENT_SIZE: " + MAX_CONTENT_SIZE);
            System.out.println("FRAME_THICKNESS : " + FRAME_THICKNESS);
            System.out.println("TITLE_HEIGHT    : " + TITLE_HEIGHT);
        }
    }
    
    public static int getFrameThickness() { return FRAME_THICKNESS; }
    
    public static Dimension getMaxContentSize() { return MAX_CONTENT_SIZE; }
    
    public static int getTaskBarHeight() { return TASK_BAR_HEIGHT; }
    
    public static int getTaskBarWidth() { return TASK_BAR_WIDTH; }
    
    public static int getTitleBarHeight() { return TITLE_HEIGHT; }
    
    public static void main(String[] args) {
        debug = true;
        new Sizer();
        
    }
}
