package ca.tecreations.wip.toy;

import java.time.LocalDate;
import java.time.Year;
/**
 *
 * @author tim
 */
public class CalendarDate {
    LocalDate date;
    
    public CalendarDate(LocalDate date) {
        this.date = date;
    }
    
    public CalendarDate(int year, int month) {
        LocalDate now = LocalDate.now();
        this.date = now.withYear(year).withMonth(month);
    }
    
    public static int getCurrentMonth() {
        LocalDate now = LocalDate.now();
        return now.getMonthValue();
    }
    
    public static int getCurrentMonthPlus(int numMonths) {
        LocalDate now = LocalDate.now();
        return now.plusMonths(numMonths).getMonthValue();
    }
    
    public static int getCurrentMonthIndex() {
        return getCurrentMonth() - 1;
    }
    
    public static String getCurrentMonthName() {
        return getMonthName(getCurrentMonth());
    }
    
    public static Integer getCurrentTecDayOfWeekIndex() {
        LocalDate now = LocalDate.now();
        int day = now.getDayOfWeek().getValue(); // monday == 1, sunday == 7
        if (day == 7) return 0;
        return day;
    }

    public static String getDayInitial(int tecIndex) {
        if (tecIndex == 0) return "S";
        if (tecIndex == 1) return "M";
        if (tecIndex == 2) return "T";
        if (tecIndex == 3) return "W";
        if (tecIndex == 4) return "T";
        if (tecIndex == 5) return "F";
        return "S";
    }
    
    public static String getDayName(int tecIndex) {
        switch (tecIndex) {
            case 0: return "Sunday";
            case 1: return "Monday";
            case 2: return "Tuesday";
            case 3: return "Wednesday";
            case 4: return "Thursday";
            case 5: return "Friday";
            case 6: return "Saturday";
        }
        return "Time.getDayName: Out of Range: tecIndex: " + tecIndex;
    }
    
    public int getDayOfWeekForDayOfMonth(int dayOfMonth) {
        LocalDate when = date.withDayOfMonth(dayOfMonth);
        int dayValue = when.getDayOfWeek().getValue(); // monday == 1, sunday == 7
        if (dayValue == 7) return 0;
        return dayValue;
    }
    
    public static int getDaysInMonth(int year, int month) {
        LocalDate now = LocalDate.now();
        LocalDate target = now.withYear(year).withMonth(month);
        int i = target.getMonthValue();
        if (i == 2) {
            if (target.isLeapYear()) return 29;
            else return 28;
        } 
        else if (i == 4) return 30;
        else if (i == 6) return 30;
        else if (i == 9) return 30;
        else if (i == 11) return 30;
        return 31;
    }

    public static int getFirstDayIndex(int year, int month) {
        LocalDate now = LocalDate.now();
        LocalDate target = now.withYear(year).withMonth(month).withDayOfMonth(1);
        int day = target.getDayOfWeek().getValue(); // monday == 1, sunday == 7
        if (day == 7) return 0;
        return day;
    }
    
    public LocalDate getLocalDate() { return date; }
    
    public int getMonth() { return date.getMonthValue(); }
    
    public int getMonth(String month) {
        if (month.equals("January")) return 1;
        if (month.equals("February")) return 2;
        if (month.equals("March")) return 3;
        if (month.equals("April")) return 4;
        if (month.equals("May")) return 5;
        if (month.equals("June")) return 6;
        if (month.equals("July")) return 7;
        if (month.equals("August")) return 8;
        if (month.equals("September")) return 9;
        if (month.equals("October")) return 10;
        if (month.equals("November")) return 11;
        return 12; //if (month.equals("December"))
    }
    
    public static String getMonthName(int month) {
        switch (month) {
            case 1: return "January";
            case 2: return "February";
            case 3: return "March";
            case 4: return "April";
            case 5: return "May";
            case 6: return "June";
            case 7: return "July";
            case 8: return "August";
            case 9: return "September";
            case 10: return "October";
            case 11: return "November";
            case 12: return "December";
        }
        String msg = "Failure in Time.java: getMonthName returned an invalid: " + " month: " + month;
        System.err.println(msg);
        return msg;
    }
    
    public static String getShortDay(int tecIndex) {
        if (tecIndex == 0) return "Sun";
        if (tecIndex == 1) return "Mon";
        if (tecIndex == 2) return "Tue";
        if (tecIndex == 3) return "Wed";
        if (tecIndex == 4) return "Thu";
        if (tecIndex == 5) return "Fri";
        return "Sat";
    }
    
    public static Integer getTecDayOfWeekIndex(int year, int month, int day) {
        LocalDate date = LocalDate.now().withYear(year).withMonth(month).withDayOfMonth(day);
        int dayValue = date.getDayOfWeek().getValue(); // monday == 1, sunday == 7
        if (dayValue == 7) return 0;
        return dayValue;
    }

    public int getYear() {
        return date.getYear();
    }
    
    public static void main(String[] args) {
        System.out.println("Short Day: " + CalendarDate.getShortDay(CalendarDate.getCurrentTecDayOfWeekIndex()));
        System.out.println("GetFirstDayIndex: " + CalendarDate.getFirstDayIndex(2024,5));
        CalendarDate time = new CalendarDate(2024,6);
        System.out.println("Time: June 18: " + time.getShortDay(time.getTecDayOfWeekIndex(2024,6,18)));
        time.monthForward();
        System.out.println("      July 18: " + time.getShortDay(time.getDayOfWeekForDayOfMonth(18)));
    }

    public void monthBackward() {
        int month = date.getMonthValue() - 1;
        System.out.println("CalendarDate.monthBackward: " + month);
        if (month == 0) {
            month = 12;
            int prevYear = date.getYear() - 1;
            System.out.println("PrevYear: " + prevYear);
            date = date.withYear(prevYear);
            date = date.withMonth(month);
        } else {
            date = date.withMonth(month);
        }
    }
    
    public void monthForward() {
        int month = date.getMonthValue() + 1;
        if (month == 13) {
            month = 1;
            int nextYear = date.getYear() + 1;
            System.out.println("NextYear: " + nextYear);
            date = date.withYear(nextYear);
            date = date.withMonth(month);
        } else {
            date = date.withMonth(month);
        }
    }
    
}
