package ca.tecreations.time;

import ca.tecreations.StringTool;

import java.nio.file.attribute.FileTime;
import java.time.temporal.ChronoUnit;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
/**
 *
 * @author Tim
 */ 
/** 
 * 
 * General notes: 
 * Use isNegativeOffset() to determine if the zone offset is a negative value.
 * getOffsetMinutes() will only produce POSITIVE value. @see: isNegativeOffset()
 * isBC() denotes a TimsTime before Christ's birth.
 * The default TimsTime is when Christ was born.
 */
public class TimsTime {
    boolean isBC = false;
    String date = "1-1-1";
    Integer year = 1;
    Integer month = 1;
    Integer day = 1;
    String time = "00:00:00";
    Integer hours = 0;
    Integer minutes = 0;
    Integer seconds = 0;
    Long nanos = 0L;
    String offset = "+0000";
    
    public String atInstantiation;
    public static String current;
    
    public static boolean debug = false;
    
    public TimsTime() {
        LocalDateTime ldt = LocalDateTime.now();
        year = ldt.getYear();
        month = ldt.getMonthValue();
        day = ldt.getDayOfMonth();
        hours = ldt.getHour();
        minutes = ldt.getMinute();
        seconds = ldt.getSecond();
        nanos = (long)ldt.getNano();
        offset = getTimezoneOffset();
        offset = StringTool.replaceAll(offset,":","");
    }
    
    public TimsTime(FileTime ft) {
        String dateTime = ft.toString();
        int index = 0;
        int firstHyphen = dateTime.indexOf("-");
        String years = dateTime.substring(0,firstHyphen);
        year = Integer.parseInt(years);
        index += years.length() + 1;
        int secondHyphen = dateTime.indexOf("-",index);
        String months = dateTime.substring(index,secondHyphen);
        month = Integer.parseInt(months);
        index += months.length() + 1;
        int tIndex = dateTime.indexOf("T",index);
        String days = dateTime.substring(index,tIndex);
        day = Integer.parseInt(days);
        index += days.length() + 1; // for the "T"
        int firstColonIndex = dateTime.indexOf(":",index);
        String hours = dateTime.substring(index,firstColonIndex);
        this.hours = Integer.parseInt(hours);
        index += hours.length() + 1;
        int secondColonIndex = dateTime.indexOf(":",index);
        String minutes = dateTime.substring(index,secondColonIndex);
        this.minutes = Integer.parseInt(minutes);
        index += minutes.length() + 1;
        int dotIndex = dateTime.indexOf(".",index);
        String seconds;
        if (dotIndex == -1) {
            seconds = dateTime.substring(index,dateTime.lastIndexOf("Z"));
            this.seconds = Integer.parseInt(seconds);
        } else {
            seconds = dateTime.substring(index,dotIndex);
            this.seconds = Integer.parseInt(seconds);
            index += seconds.length() + 1;
            String nanos = dateTime.substring(index,dateTime.lastIndexOf("Z"));
            this.nanos = Long.parseLong(nanos);
            
        }
        this.date = years + "-" + months + "-" + days;
        this.time = hours + ":" + minutes + ":" + seconds;
        this.offset = new Time().getTimeZoneOffsetString();
//        System.out.println("Years  : " + years);
//        System.out.println("Months : " + months);
//        System.out.println("Days   : " + days);
//        System.out.println("Hours  : " + hours);
//        System.out.println("Minutes: " + minutes);
//        System.out.println("Seconds: " + seconds);
//        System.out.println("Nanos  : " + nanos);
    }

    public TimsTime(String date, String time, String zoneOffset) {
        this("D" + date + "T" + time + "Z" + zoneOffset);
    }
    
    public TimsTime(String timsTime) {
        String date = timsTime.substring(1,timsTime.indexOf("T"));
        String time = timsTime.substring(timsTime.indexOf("T") + 1,timsTime.indexOf("Z"));
        String zone = timsTime.substring(timsTime.indexOf("Z") + 1);
        System.out.println("Date: " + date);
        System.out.println("Time: " + time);
        System.out.println("Zone: " + zone);
                 
        int dateFirst = date.indexOf("-");
        int dateSecond = date.indexOf("-",dateFirst + 1);
        int timeFirst = time.indexOf(":");
        int timeSecond = time.indexOf(":",timeFirst + 1);
        String year = date.substring(0,dateFirst);
        String month = date.substring(dateFirst + 1, dateSecond);
        String day = date.substring(dateSecond + 1);
        String hours = time.substring(0,timeFirst);
        String minutes = time.substring(timeFirst + 1, timeSecond);
        String seconds = time.substring(timeSecond + 1, time.indexOf("."));
        String nanos = time.substring(time.indexOf(".") + 1);
        this.year = Integer.parseInt(year);
        this.month = Integer.parseInt(month);
        this.day = Integer.parseInt(day);
        this.hours = Integer.parseInt(hours);
        this.minutes = Integer.parseInt(minutes);
        this.seconds = Integer.parseInt(seconds);
        this.nanos = Long.parseLong(nanos);
        this.offset = zone;
    }
    
    public TimsTime(DateCarrier ymd,Time hms) {
        this.year = ymd.year;
        this.month = ymd.month;
        this.day = ymd.day;
        date = year + "-" + month + "-" + day;
        this.hours = hms.getHours();
        this.minutes = hms.getMinutes();
        this.seconds = hms.getSeconds();
        time = hours + ":" + minutes + ":" + seconds;
    }
    
    public TimsTime(long millis) {
        long bigSeconds = millis / 1000;
        System.out.println("TimsTime(" + millis + "): bigSeconds: " + bigSeconds);
        System.exit(0);
    }
    
    
    
    public TimsTime(int year, int month, int day, int hours, int minutes, int seconds, String zoneOffset) {
        this(year,month,day,hours,minutes,seconds,0L,zoneOffset);
    }
    
    public TimsTime(int year, int month, int day, int hours, int minutes, int seconds, Long nanos, String zoneOffset) {
        if (zoneOffset.length() < 5) {
            throw new IllegalArgumentException("invalid zone offset: must be in format: [+|-]DDDD : length must be 4 or 5 characters");
        }
        date += year + "-";
        if (month < 10) date += "0" + month + "-";
        else date += month + "-";
        if (day < 10) date += "0" + day;
        else date += day;
        if (hours < 10) time += "0" + hours + ":";
        else time += hours + ":";
        if (minutes < 10) time += "0" + minutes + ":";
        else time += minutes + ":";
        if (seconds < 10) time += "0" + seconds;
        else time += seconds;
        this.nanos = nanos;
        this.offset = zoneOffset;
    }
    
    public TimsTime(int days, int hours, int minutes, int seconds, long nanos, String zoneOffset) {
        this.day = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.nanos = nanos;
        this.offset = zoneOffset;
    }
    
    public TimsTime getAltered(String expression) {
        List<String> expressions = new ArrayList<>();
        expressions.add(expression);
        return getAltered(expressions);
    }
    
    public TimsTime getAltered(List<String> expressions) {
        TimsTime newTT = new TimsTime(toString());
        String expression;
        for(int i = 0;i < expressions.size();i++) {
            expression = expressions.get(i).toLowerCase();
            if (expression.contains("y")) {
                if (expression.contains("-")) {
                    newTT.year -= Integer.parseInt(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.year += Integer.parseInt(expression.substring(2));
                } else {
                    newTT.year = Integer.parseInt(expression.substring(1));
                }
            }
            if (expression.contains("m")) {
                if (expression.contains("-")) {
                    newTT.month -= Integer.parseInt(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.month += Integer.parseInt(expression.substring(2));
                } else {
                    newTT.month = Integer.parseInt(expression.substring(1));
                }
            } 
            if (expression.contains("d")) {
                if (expression.contains("-")) {
                    newTT.day = day - Integer.parseInt(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.day = day + Integer.parseInt(expression.substring(2));
                } else {
                    newTT.day = day + Integer.parseInt(expression.substring(1));
                }
            }
            if (expression.contains("h")) {
                if (expression.contains("-")) {
                    newTT.hours -= Integer.parseInt(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.hours += Integer.parseInt(expression.substring(2));
                } else {
                    newTT.hours = Integer.parseInt(expression.substring(1));
                }
            }
            if (expression.contains("i")) {
                if (expression.contains("-")) {
                    newTT.minutes -= Integer.parseInt(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.minutes += Integer.parseInt(expression.substring(2));
                } else {
                    newTT.minutes = Integer.parseInt(expression.substring(1));
                }
            }
            if (expression.contains("s")) {
                if (expression.contains("-")) {
                    newTT.seconds -= Integer.parseInt(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.seconds += Integer.parseInt(expression.substring(2));
                } else {
                    newTT.seconds = Integer.parseInt(expression.substring(1));
                }
            }
            if (expression.contains("n")) {
                if (expression.contains("-")) {
                    newTT.nanos -= Long.parseLong(expression.substring(2));
                } else if (expression.contains("+")) {
                    newTT.nanos += Long.parseLong(expression.substring(2));
                } else {
                    newTT.nanos = Long.parseLong(expression.substring(1));
                }
            }
            if (expression.contains("z")) {
                if (expression.length() < 5) {
                    throw new IllegalArgumentException("invalid zone offset: must be in format: (Z|z)(+|-)DDDD : length must be 5 characters");
                }
                newTT.offset = expression.substring(1);
            }
        }
        return newTT;
    }

    public String getAtInstantiation() { return atInstantiation; }
    
    public static TimsTime getCurrent() {
        return new TimsTime();
    }
    
    public String getDate() {
        return year + "-" + month + "-" + day;
    }
    
    public String getDiff(TimsTime tt2) {
        LocalDateTime start = getLocalDateTime();
        LocalDateTime end = tt2.getLocalDateTime();

        long days = ChronoUnit.DAYS.between(start,end);
        long seconds = ChronoUnit.SECONDS.between(start, end);
        long nanos1 = nanos;
        long nanos2 = tt2.getNanos();
        long nanos = 0L;
        if (nanos1 != nanos2) {
            if (isLessThan(tt2)) {
                nanos += 1000000000 - nanos1;
                nanos += nanos2;
            } else {
                nanos += 1000000000 - nanos2;
                nanos += nanos1;
            }
        }
        System.out.println(nanos); 
        return "getDiff(): Done";
    }
    
    public LocalDateTime getLocalDateTime() {
        LocalDateTime time = LocalDateTime.of(year,month,day,hours, minutes, seconds);
        return time;
    }
    
    public String getLongTime() {
        return time + "." + nanos;
    }
    
    public Long getNanos() {
        return nanos;
    }
    
    public String getNow() {
        return new TimsTime().getTimsTime();
    }
    
    public String getTime() {
        return time;
    }
    
    public String getTimeForFilename() {
        String time = hours + ".";
        if (minutes < 10) time += "0";
        time += minutes + ".";
        if (seconds < 10) time += "0";
        time += seconds;
        return time;
    }
    
    public static String getTimezoneOffset() {
        TimeZone tz = TimeZone.getDefault();  
        Calendar cal = GregorianCalendar.getInstance(tz);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());

        String offset = String.format("%02d:%02d", Math.abs(offsetInMillis / 3600000), Math.abs((offsetInMillis / 60000) % 60));
        offset = (offsetInMillis >= 0 ? "+" : "-") + offset;

        return offset;
    } 
    
    public String getTimsTime() {
        return "D" + date + "T" + time + "Z" + offset;
    }
    
    public String getZoneOffset() {
        return "Z" + offset; 
                   // formatted: 0 : Preceeding 'Z';
                   //          : 1 : Example: "Z+0215" == + 2 hrs, 15 minutes
                   //          : 2 : Only uses a 24 hour clock.
                   //          : 3 : Negative gradations are acceptable.
                   //          : 3 : Format:
                   //          : 3b: '+' or '-' : Mandatory
                   //          : 3c: time offset from GMT of day
    }
    
    public boolean isGreaterThan(TimsTime compare) {
        if (year > compare.year) return true;
        else if (year < compare.year) return false;
        else /* year == compare.year */ {
            if (month > compare.month) return true;
            else if (month < compare.month) return false;
            else /* month == compare.month */ {
                if (day > compare.day) return true;
                else if (day < compare.day) return false;
                else /* day == compare.day */ {
                    if (hours > compare.hours) return true;
                    else if (hours < compare.hours) return false;
                    else /* hours == compare.hours) */ {
                        if (minutes > compare.minutes) return true;
                        else if (minutes < compare.minutes) return false;
                        else {
                            if (seconds > compare.seconds) return true;
                            else if (seconds < compare.seconds) return false;
                            else {
                                if (nanos > compare.nanos) return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }
    
    public boolean isLessThan(TimsTime compare) {
        if (year < compare.year) return true;
        else if (year > compare.year) return false;
        else /* year == compare.year */ {
            if (month < compare.month) return true;
            else if (month > compare.month) return false;
            else /* month == compare.month */ {
                if (day < compare.day) return true;
                else if (day > compare.day) return false;
                else /* day == compare.day */ {
                    if (hours < compare.hours) return true;
                    else if (hours > compare.hours) return false;
                    else /* hours == compare.hours) */ {
                        if (minutes < compare.minutes) return true;
                        else if (minutes > compare.minutes) return false;
                        else {
                            if (seconds < compare.seconds) return true;
                            else if (seconds > compare.seconds) return false;
                            else {
                                if (nanos < compare.nanos) return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }
    
    public static void main(String[] args) {
        TimsTime afterInstantiation = new TimsTime();
        TimsTime tom = afterInstantiation.getAltered("d+1");
        System.out.println("Now           : " + afterInstantiation.toString());
        System.out.println("Tomorrow @ Now: " + tom.toString());
        System.out.println("Less Than     : " + tom.isLessThan(afterInstantiation));
        System.out.println("Greater Than  : " + tom.isGreaterThan(afterInstantiation));
        System.out.println("Diff: " + afterInstantiation.getDiff(tom));
    }
    
    // input -- a date in Y*-MM-DD format where Y can be any positive whole number
    public void setDate(String date) {  
        if (StringTool.count(date,'-') != 2) {
            throw new IllegalArgumentException("Dates must contain two hyphens.");
        }
        int first = date.indexOf("-");
        int second = date.indexOf("-",first + 1);
        String year = date.substring(0,first);
        String month = date.substring(first+1,second);
        String day = date.substring(second + 1);
        int iDay = Integer.parseInt(day);
        int iMonth = Integer.parseInt(month);
        if (iMonth < 1 | iMonth > 12) {
            throw new IllegalArgumentException("Month(" + iMonth + ") must be between 1 and 12 inclusive.");
        }
        int iYear = Integer.parseInt(year);
        if (iDay < 10) {
            day = "0" + iDay;
        }
        if (iMonth < 10) {
            month = "0" + iMonth;
        }
        this.date = year + "-" + month + "-" + day;
        this.year = iYear;
        this.month = iMonth;
        this.day = iDay;
    }
    
    // input -- a time in HH:MM:SS format
    public void setTime(String time) {  
        if (StringTool.count(date,'-') != 2) {
            throw new IllegalArgumentException("Dates must contain two hyphens.");
        } 
        int first = date.indexOf("-");
        int second = date.indexOf("-",first + 1);
        String year = date.substring(0,first);
        String month = date.substring(first+1,second);
        String day = date.substring(second + 1);
        int iDay = Integer.parseInt(day);
        int iMonth = Integer.parseInt(month);
        if (iDay < 10) {
            day = "0" + iDay;
        }
        if (iMonth < 10) {
            month = "0" + iMonth;
        }
    }
    
    // input -- a zone offset in {+|-}XXXX format where X can be 0 to 9 inclusive
    //       -- a zone offset should be in the range of 0000 to +/- 2359 inclusive
    public void setZoneOffset(String zone) {  
        this.offset = offset;
    } 
    
    public String toString() {
        return "D" + year + "-" + month + "-" + day + "T" + hours + ":" + minutes + ":" + seconds + "." + nanos + "Z" + offset;
    }
    
}
