package ca.tecreations.time;

import ca.tecreations.Platform;
import ca.tecreations.Sort;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.*;

/**
 *
 * @author Tim 
 */ 
public class Time {
//    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(Time.class);
 
    LocalDate localDate;
    LocalTime localTime;
    private String zone;
    private String zoneId;
    private int hour;
    private String hours = ""; // if we set a string to empty, we can use 'val += int;' and it will work, it's a nice shortcut from casting
    private int minute;
    private String minutes = "";
    private int second;
    private String seconds = "";
    private int nano;
    private String nanos = "";
    private String segment;

    public static boolean debug = true;
 
    public Time() {
        localDate = LocalDate.now();
        localTime = LocalTime.now();
        //if (debug) log.info("Time: " + time.toString());
        zone = getLocalZone();
        TimeZone tz = TimeZone.getTimeZone(zone);
        zoneId = getLocalZoneID();
        hour = localTime.getHour();
        hours = "" + hour;
        minute = localTime.getMinute();
        second = localTime.getSecond();
        nano = localTime.getNano();
        if (hour < 12) {
            segment = "AM";
        } else {
            segment = "PM";
        }
        minutes = "";
        if (minute == 0) {
            minutes = "00";
        } else if (minute < 10) {
            minutes += "0" + minute;
        } else {
            minutes += minute;
        }
        if (second == 0) {
            seconds = "00";
        } else if (second < 10) {
            seconds = "0" + second;
        } else {
            seconds = "" + second;  
        }                         
        this.nanos = "" + nano;
        nanos = "" + nano;
    }

    public Time(int hours, int minutes, int seconds) {
        this.hours = "" + hours;
        this.minutes = "" + minutes;
        this.seconds = "" + seconds;
        if (hour < 12) {
            segment = "AM";
        } else {
            segment = "PM";
        }
    }

    public Time clone() {
        Time time = new Time();
        time.zone = this.zone;
        time.zoneId = this.zoneId;
        time.hours = this.hours;
        time.minutes = this.minutes;
        time.seconds = this.seconds;
        time.nanos = this.nanos;
        time.segment = this.segment;
        return time;
    }

    public Time decrementHours(int hours) {
        if (hours > 24) throw new IllegalArgumentException("Hours > 24: " + hours);
        if (hours == 24) hours = 0;
        Time time = clone();
        time.setHours(time.getHours() - hours);
        return time;
    }
    
    public Time decrementMinutes(int minutes) {
        if (minutes > 60) throw new IllegalArgumentException("Minutes > 60: " + minutes);
        if (minutes == 60) minutes = 0;
        Time time = clone();
        time.setMinutes(time.getMinutes() - minutes);
        return time;
    }
    
    public Time decrementSeconds(int seconds) {
        if (seconds > 60) throw new IllegalArgumentException("Seconds > 60: " + seconds);
        if (seconds == 60) seconds = 0;
        Time time = clone();
        time.setMinutes(time.getMinutes() - seconds);
        return time;
    }
    
    public String getAppEventTime() {
        Time time = new Time();
        int hours = time.getHours();
        if (time.segment.equals("PM") && hours < 12) {
            hours += 12;
        }
        if (hours < 10) {
            return "0" + hours + ":" + minutes + ":" + seconds + "." + nanos.substring(0, 3);
        }
        return hours + ":" + minutes + ":" + seconds + "." + nanos.substring(0, 3);
    }

    public String getCompressedFullHMS24() {
        String h = hours;
        String m = minutes;
        String s = seconds;
        if (Integer.parseInt(h) < 10) {
            if (h.startsWith("0") && h.length() == 1) h = "0" + h; // make '00'
            else if (!h.startsWith("0") && h.length() != 1) h = "0" + h; // make '0h'
        } 
        if (Integer.parseInt(m) < 10) {
            if (m.startsWith("0") && m.length() == 1) m = "0" + m; // make '00'
            else if (!m.startsWith("0") && m.length() != 1) m = "0" + m; // make '0m'
        }
        if (Integer.parseInt(s) < 10) {
            if (s.startsWith("0") && s.length() == 1) s = "0" + s; // make '00'
            else if (!s.startsWith("0") && s.length() != 1) s = "0" + s; // make '0s'
        }
        return "" + h + m + s;
    }
    
    public static String getCurrentTime() {
        String time = getTimsTime();
        int index1 = time.indexOf("T") + 1;
        int index2 = time.indexOf("Z");
        return time.substring(index1,index2);
    }
    
    public static String getDateDiff(java.util.Date date1, java.util.Date date2) {
        long seconds = Math.abs((date2.getTime()-date1.getTime())/1000);
        int h = 0;
        int m = 0;
        int s = 0;
        while (seconds > 3600) {
            seconds -= 3600;
            h++;
        }
        while (seconds > 60) {
            seconds -= 60;
            m++;
        }
        s = (int)seconds;
        return h + ":" + m + ":" + s;
    }

    public static int getDay() {
        java.util.Date date = new java.util.Date();
        DateFormat format = new SimpleDateFormat("dd");
        return Integer.parseInt(format.format(date));
    }
    
    public int getDayNumOfMonth() {
        return localDate.getDayOfMonth();
    }
    
    public static int getDayOfMonth() {
        String timsTime = getTimsTime();
        String date = timsTime.substring(1,timsTime.indexOf('T'));
        //System.out.println("Date: " + date);
        int dateIndex = date.lastIndexOf("-");
        String timsDate = date.substring(dateIndex + 1);
        return Integer.parseInt(timsDate);
    }
    
    public static String getDurationHMS(int seconds, String delimiter) {
        int hours = 0;
        int mins = 0;
        int secs = 0;
        if (seconds > 3600) {
            hours = seconds / 3600;
            seconds = seconds - (3600 * hours);
        }
        if (seconds >= 60) {
            mins = seconds / 60;
            seconds = seconds - (60 * mins);
        }
        secs = seconds;
        String result = "";
        if (secs == 60) {
            mins++;
            secs = 0;
        }
        if (mins == 60) {
            hours++;
            mins = 0;
        }
        if (hours > 0) {
            result = hours + delimiter;
            if (mins < 10) {
                result += "0" + mins + delimiter;
            } else {
                result += mins + delimiter; 
            }
            if (secs < 10) {
                result += "0" + secs;
            } else {
                result += secs; 
            }
        } else if (mins > 0) {
            result += mins + delimiter;
            if (secs < 10) {
                result += "0" + secs;
            } else {
                result += secs;
            }
        } else {
            result = secs + "";
        }
        return result;
    }  
    
    public static String getElapsedTimeYYYYMMDD_HmmssSSS(long start, long stop) {
        long total = stop - start;
        java.util.Date diff = new java.util.Date(total);
        SimpleDateFormat date = new SimpleDateFormat("YYYY-MM-DD");
        SimpleDateFormat time = new SimpleDateFormat("HH.mm.ss.SSSSSS"); 
        date.setTimeZone(TimeZone.getTimeZone("UTC"));           
        time.setTimeZone(TimeZone.getTimeZone("UTC"));           
        return "D" + date.format(diff) + "T" + time.format(diff) + "Z0000";
    }

    public static String getElapsedTimeHmmssSSS(long start, long stop) {
        long total = stop - start;
        java.util.Date date = new java.util.Date(total);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS"); // A time only -- don't include a 'T' for a ~TimsTime~
                                                                           // let the parser decide if the "Token" is a possible
                                                                           // Time value.
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String formatted = formatter.format(date);
        return formatted;
    }

    public static String getFormatted(long millis) {
        SimpleDateFormat format;
        if (millis >= 3600000) {
            format = new SimpleDateFormat("HH:mm:ss");
        } else {
            format = new SimpleDateFormat("mm:ss");
        }
        java.util.Date date = new java.util.Date(millis);
        return format.format(date);
    }
    
    public String getFormatted(boolean zone,
            boolean zoneId,
            boolean seconds,
            boolean nanos,
            boolean segment) {
        String result = "";
        if (zone) {
            result += this.zone + " : ";
        }
        if (zoneId) {
            result += this.zoneId + " : ";
        }
        int hours = Integer.parseInt(this.hours);
        if (hours > 12) {
            hours -= 12;
        }
        if (hours < 10) {
            result += "0" + hours + ":" + this.minutes;
        } else {
            result += hours + ":" + this.minutes;
        }
        if (seconds) {
            result += ":" + this.seconds;
        }
        if (nanos) {
            result += "." + this.nanos;
        }
        if (segment) {
            result += " " + this.segment;
        }
        return result;
    }

    public static String getFormatted24FromSeconds(long seconds) {
        int hour = (int)(seconds / 3600);
        seconds -= hour * 3600;
        int mins = (int)(seconds / 60);
        seconds -= mins * 60;
        return "" + hour + ":" + 
                (mins < 10 ? "0" : "") + mins + ":" + 
                (seconds < 10? "0" : "") + seconds;
    }
    
    public String getFormatted24(boolean zone, boolean zoneId, boolean seconds, boolean nanos) {
        return getFormatted24Hour(zone, zoneId, seconds, nanos);
    }

    public String getFormatted24Hr(boolean zone, boolean zoneId, boolean seconds, boolean nanos) {
        return getFormatted24Hour(zone, zoneId, seconds, nanos);
    }

    public String getFormatted24Hour(boolean zone,
            boolean zoneId,
            boolean seconds,
            boolean nanos) {
        String result = "";
        if (zone) {
            result += this.zone + " : ";
        }
        if (zoneId) {
            result += this.zoneId + " : ";
        }
        if (Integer.parseInt(this.hours) < 10) {
            result += "0" + this.hours + ":" + this.minutes;
        } else {
            result += this.hours + ":" + this.minutes;
        }
        if (seconds) {
            result += ":" + this.seconds;
        }
        if (nanos) {
            result += "." + this.nanos;
        }
        return result;
    }
    
    public static String getFormattedDateTime(long ms) {
        java.util.Date date = new java.util.Date(ms);  
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public String getHM24(String delimiter) {
        String h = hours;
        String m = minutes;
        if (Integer.parseInt(h) < 10) {
            if (h.startsWith("0") && h.length() == 1) h = "0" + h; // make '00'
            else if (!h.startsWith("0") && h.length() != 1) h = "0" + h; // make '0d'
        } 
        if (Integer.parseInt(m) < 10) {
            if (m.startsWith("0") && m.length() == 1) m = "0" + m; // make '00'
            else if (!m.startsWith("0") && m.length() != 1) m = "0" + m; // make '0d'
        }
        return "" + h + delimiter + m;
    }
    
    
    public String getHMS24(String delimiter) {
        String h = hours;
        String m = minutes;
        String s = seconds;
        if (Integer.parseInt(h) < 10) {
            if (h.startsWith("0") && h.length() == 1) h = "0" + h; // make '00'
            else if (!h.startsWith("0") && h.length() != 1) h = "0" + h; // make '0h'
        } 
        if (Integer.parseInt(m) < 10) {
            if (m.startsWith("0") && m.length() == 1) m = "0" + m; // make '00'
            else if (!m.startsWith("0") && m.length() != 1) m = "0" + m; // make '0m'
        }
        if (Integer.parseInt(s) < 10) {
            if (s.startsWith("0") && s.length() == 1) s = "0" + s; // make '00'
            else if (!s.startsWith("0") && s.length() != 1) s = "0" + s; // make '0s'
        }
        return "" + h + delimiter + m + delimiter + s;
    }
    
    
    public String getHMS24_Formatted() {
        return getFormatted24Hr(false,false,true,false);
    }
    
    public int getHours() {
        return Integer.parseInt(hours);
    }

    public static int getHoursToMidnight() {
        Time time = new Time();
        int hours = 23 - time.getHours();
        int mins = 59 - time.getMinutes();
        int secs = 60 - time.getSeconds();
        if (secs == 60) mins++;
        if (mins == 60) hours++;
        return hours;
    }

    public Time getIncrementedHours(int hours) {
        Time time = clone();
        while (hours >= 24) hours -= 24;
        if (hours == 24) hours -= 24;
        time.setHours(hours);
        return time;
    }
    
    public Time getIncrementedMinutesOfHour(int minutes) {
        Time time = clone();
        while (minutes >= 60) minutes -= 60;
        if (minutes == 60) minutes -= 60;
        int total = time.getMinutes() + minutes;
        if (minutes > 59) minutes -= 60;
        time.setMinutes(minutes);
        return time;
    }
    
    public Time getIncrementedSecondsOfHour(int seconds) {
        Time time = clone();
        while (seconds >= 60) seconds -= 60;
        if (seconds == 60) seconds -= 60;
        int total = time.getSeconds() + seconds;
        if (total > 59) total -= 60;
        // sure you can, if total > 60, uhh, library error
        time.setSeconds(total);
        return time;
    }
    
    public static String getLocalZone() {
        return TimeZone.getDefault().getID();
    }

    public static String getLocalZoneID() {
        return TimeZone.getDefault().getDisplayName();
    }
    
    public static String getLocalTimezone() {
        return "new Timezone('Alberta')"; 
    }
    
    public String getMachineTime() {
        String zoneOffset = getZoneOffset();
        return "D" + getYMD() + "T" + getHMS24(":") + "Z" + getZoneOffset();
    }
    
    public String getMD_ForDir() {
        return getMonthInt() + "-" + getDayOfMonth();
    }
    
    public int getMinutes() {
        return Integer.parseInt(minutes);
    }

    public static int getMinutesToNextHour() {
        Time time = new Time();
        int mins = 59 - time.getMinutes();
        int secs = 60 - time.getSeconds();
        if (secs == 60) mins++;
        return mins;
    }
    
    public static int getMonth() {
        java.util.Date date = new java.util.Date();
        DateFormat format = new SimpleDateFormat("MM");
        return Integer.parseInt(format.format(date));
    }
    
    public int getMonthInt() {
        return localDate.getMonthValue();
    }
    
    public String getNanos() {
        return nanos;
    }

    public String getNormalTime12() {
        Time time = new Time();
        int hours = time.getHours();
        if (time.segment.equals("PM") && hours < 12) {
            hours += 12;
        }
        String result = ":" + minutes;
        if (hours >= 12) result = (hours - 12) + result + " PM";
        else result = hours + result + " AM";
        return result;
    }

    public int getSeconds() {
        return Integer.parseInt(seconds);
    }

    public static long getSecondsTo(Time time1, Time time2) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        java.util.Date date1 = new java.util.Date();
        java.util.Date date2 = new java.util.Date();
        try {
            date1 = format.parse(time1.getFormatted24Hour(false, false, true, false));
            date2 = format.parse(time2.getFormatted24Hour(false, false, true, false));
        } catch (ParseException pe) {
            System.err.println("getSecondsTo: ParseException: " + pe);
        }
        return (date2.getTime() - date1.getTime()) / 1000;
    }

    public static int getSecondsToMidnight() {
        Time time = new Time();
        int hours = 23 - time.getHours();
        int mins = 59 - time.getMinutes();
        int secs = 59 - time.getSeconds();
        //System.out.println("Seconds To Midnight: hours: " + hours + " mins: " + mins + " secs: " + secs);
        if (secs == 60) {
            mins++;
            if (mins == 60) hours++; 
        }
        return (hours * 3600) + (mins * 60) + secs;
    }
    
    public static int getSecondsToNextMinute() {
        Time time = new Time();
        int secs = 60 - time.getSeconds();
        return secs;
    }
    
    public static int getSecondsToNoon() {
        Time time = new Time();
        int hours = 23 - time.getHours();
        if (hours > 11) hours -= 12;
        int mins = 59 - time.getMinutes();
        int secs = 59 - time.getSeconds();
        if (secs == 60) {
            mins++;
            if (mins == 60) hours++;
        }
        return (hours * 3600) + (mins * 60) + secs;
    }
    
    public static long getSecondsToWithMidnightCrossover(Time time1, Time time2) {
        System.out.println("Time.getSecondsToWithMidnightCrossover()");
        int t1s = 60 - time1.getSeconds();
        int t1m = 59 - time1.getMinutes();
        int t1h = 23 - time1.getHours();
        return t1h * 3600 + t1m * 60 + t1s + time2.getHours() * 3600 + time2.getMinutes() * 60 + time2.getSeconds();
    }

    public String getSegment() {
        return segment;
    }
    
    public String getSimpleLocal() {
        String s = "";
        LocalTime now = LocalTime.now();
        String time = getFormatted(false,
                false,
                false,
                false,
                true);
        if (time.startsWith("0")) {
            return time.substring(1);
        }
        return time;
    }

    public static List<String> getSortedZoneIds() {
        Set<String> ids = getZoneIds();
        List<String> names = new ArrayList<>();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            names.add((String)iter.next());
        }
        return Sort.sort(names);
    }
    
    public ZonedDateTime getStartOfDay(String date,String zoneId) {
        LocalDate ld = LocalDate.parse(date);
        ZoneId z = ZoneId.of( zoneId);
        return ld.atStartOfDay(z);
    }

    public String getSpringDateTime() {
        String offset = getTimeZoneOffsetString();
        java.util.Date date = new java.util.Date();
        DateFormat format = new SimpleDateFormat("YYYY-mm-dd");
        return format.format(date) + "T" + getAppEventTime() + offset;
    }
    
    public TimeZone getTimeZone(String zone) {
        return TimeZone.getTimeZone(zone);
    }
    
    public String getTimeZoneOffsetString() {
        TimeZone tz = getTimeZone(zone);  
        Calendar cal = GregorianCalendar.getInstance(tz);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());

        String offset = String.format("%02d%02d", Math.abs(offsetInMillis / 3600000), Math.abs((offsetInMillis / 60000) % 60));
        offset = (offsetInMillis >= 0 ? "+" : "-") + offset;

        return offset;
    }

    public String getTodaysShortDate() {
        String date = LocalDate.now().toString();
        return date;
    }
    
    public static String getTodaysShortDateTimeForDirName() {
        String name = new Time().getTodaysShortDate() + "_" + new Time().getHMS24(".");
        return name;
    }
    
    public static int getYear() {
        java.util.Date date = new java.util.Date();
        DateFormat format = new SimpleDateFormat("YYYY");
        return Integer.parseInt(format.format(date));
    }
    
    public static Set<String> getZoneIds() {
        return ZoneId.getAvailableZoneIds();
    }
    
    public static String getTimsTimeDiff(String t1, String t2) {
        int tIndex = t1.indexOf('T');
        int zIndex = t1.indexOf('Z');
        int tIndex2 = t2.indexOf('T');
        int zIndex2 = t2.indexOf('Z');
        System.out.println("T1: " + t1 + " T2: " + t2);
        String date1 = t1.substring(1,tIndex);
        String time1 = t1.substring(tIndex + 1,zIndex);
        String offset1 = t1.substring(zIndex + 1);
        String date2 = t2.substring(1,tIndex2);
        String time2 = t2.substring(tIndex2 + 1,zIndex2);
        if (time2.contains(".")) time2 = time2.substring(0,time2.indexOf("."));
        String offset2 = t2.substring(zIndex2 + 1);

        int d1Index1 = date1.indexOf("-");
        int d1Index2 = date1.lastIndexOf("-");
        int d2Index1 = date2.indexOf("-");
        int d2Index2 = date2.lastIndexOf("-");
        int years1 = Integer.parseInt(date1.substring(0,d1Index1));
        int months1 = Integer.parseInt(date1.substring(d1Index1 + 1, d1Index2));
        int days1 = Integer.parseInt(date1.substring(d1Index2 + 1));
        int years2 = Integer.parseInt(date2.substring(0,d2Index1));
        int months2 = Integer.parseInt(date2.substring(d2Index1 + 1, d2Index2));
        int days2 = Integer.parseInt(date2.substring(d2Index2 + 1));
        
        
        int t1Index1 = time1.indexOf(":");
        int t1Index2 = time1.lastIndexOf(":");
        int t2Index1 = time2.indexOf(":");
        int t2Index2 = time2.lastIndexOf(":");
        int h1 = Integer.parseInt(time1.substring(0,t1Index1));
        int m1 = Integer.parseInt(time1.substring(t1Index1 + 1, t1Index2));
        int s1 = Integer.parseInt(time1.substring(t1Index2 + 1));
        int h2 = Integer.parseInt(time2.substring(0,t2Index1));
        int m2 = Integer.parseInt(time2.substring(t2Index1 + 1, t2Index2));
        int s2 = Integer.parseInt(time2.substring(t2Index2 + 1));
        java.util.Date jd1 = new java.util.Date(years1,months1,days1,h1,m1,s1);
        java.util.Date jd2 = new java.util.Date(years2,months2,days2,h2,m2,s2);
        return getDateDiff(jd1,jd2);
    }

    public static LocalDate getLocalDate(String date) {
        int fi1 = date.indexOf("-");
        int si1 = date.lastIndexOf("-");
        int years = Integer.parseInt(date.substring(0,fi1));
        int months = Integer.parseInt(date.substring(fi1 + 1, si1));
        int days = Integer.parseInt(date.substring(si1 + 1));
        return LocalDate.of(years, months,days);
    }
    
    public static java.util.Date getJavaDate(String date) {
        int fi1 = date.indexOf("-");
        int si1 = date.lastIndexOf("-");
        int years = Integer.parseInt(date.substring(0,fi1));
        int months = Integer.parseInt(date.substring(fi1 + 1, si1));
        int days = Integer.parseInt(date.substring(si1 + 1));
        return ca.tecreations.time.Date.getJavas(years,months,days);
    }
    
    public static boolean isBefore(String date1, String date2) {
        LocalDate ld1 = getLocalDate(date1);
        LocalDate ld2 = getLocalDate(date2);
        return ld1.isBefore(ld2);
    }
    
    public static long getTimeDiff(java.util.Date d1,java.util.Date d2) {
        return (d2.getTime()-d1.getTime())/1000;    
    }
    
    public static String getTimsTime() {
        return new Time().getMachineTime();
    }
    
    public static String getTodaysDate() {
        String time = getTimsTime();
        int index1 = 1;
        int index2 = time.indexOf("T");
        String today = time.substring(index1,index2);
        return today;
    }
    
    public int getYearInt() {
        return localDate.getYear();
    }
    
    public String getYMD() {
        String s = getYearInt() + "-" + getMonthInt() + "-" + getDayNumOfMonth();
        return s;
    }
    
    public String getZone() {
        return zone;
    }

    public String getZoneID() {
        return zoneId;
    }

    public String getZoneOffset() {
        TimeZone offtime_zone 
            = TimeZone.getTimeZone(getZone()); 
        long zoneOffset = offtime_zone 
                                 .getOffset(Calendar.ZONE_OFFSET);
        //System.out.println("Zone: " + getZone());
        //System.out.println("The Offset Value is:"
        //                   + zoneOffset + " : " + 
        //                   (zoneOffset / 1000 / 3600));
        String offset = "" + (zoneOffset / 1000 / 3600);
        char sign = offset.charAt(0);
        String zone = offset.substring(1);
        if (zone.length() == 1) zone = "0" + zone + "00";
        else if (zone.length() == 2) zone = zone + "00";
        else if (zone.length() == 3) zone = "0" + zone;
        // for four digits we don't have to do anything
        return sign + zone;
    }
    
    public Time incrementSeconds(int count) {
        Time time = clone();
        while (count >= 60) count -= 60;
        int seconds = time.getSeconds() + count;
        if (seconds >= 60) seconds -= 60;
        time.setSeconds(seconds);
        return time;
    }
    
    public boolean isAM() { return segment.equals("AM"); }
    
    public static boolean isEqual_Strict(Time t1, Time t2) {
        if (!t1.zone.equals   (t2.zone)   ) return false;
        if (!t1.zoneId.equals (t2.zoneId) ) return false;
        if (!t1.hours.equals  (t2.hours)  ) return false;
        if (!t1.minutes.equals(t2.minutes)) return false;
        if (!t1.seconds.equals(t2.seconds)) return false;
        if (!t1.nanos.equals  (t2.nanos)  ) return false;
        if (!t1.segment.equals(t2.segment)) return false;
        return true;
    } 

    public static boolean isEqualHM(Time t1, Time t2) {
        return t1.hours.equals(t2.hours) && t1.minutes.equals(t2.minutes);
    }
    
    public static boolean isEqualHMS(Time t1, Time t2) {
        return (t1.hours.equals(t2.hours)) && (t1.minutes.equals(t2.minutes)) && (t1.seconds.equals(t2.seconds));
    }
    
    public static boolean isGreaterHMS24(Time t1, Time t2) {
        int t1Hours = t1.getHours();
        int t2Hours = t2.getHours();
        if (t1Hours > t2Hours) return true;
        else if (t1Hours == t2Hours) {
            int t1Minutes = t1.getMinutes();
            int t2Minutes = t2.getMinutes();
            if (t1Minutes > t2Minutes) return true;
            else if (t1Minutes == t2Minutes) {
                int t1Seconds = t1.getSeconds();
                int t2Seconds = t2.getSeconds();
                if (t1Seconds > t2Seconds) return true;
            }
        }
        return false;
    }
    
    public static boolean isGreaterHMSN(Time t1, Time t2) {
        int t1Hours = t1.getHours();
        int t2Hours = t2.getHours();
        if (t1Hours > t2Hours) return true;
        else if (t1Hours == t2Hours) {
            int t1Mins = t1.getMinutes();
            int t2Mins = t2.getMinutes();
            if (t1Mins > t2Mins) return true;
            else if (t1Mins == t2Mins) {
                int t1Seconds = t1.getSeconds();
                int t2Seconds = t2.getSeconds();
                if (t1Seconds > t2Seconds) return true;
                else if (t1Seconds == t2Seconds) {
                    long t1Nanos = Long.parseLong(t1.getNanos());
                    long t2Nanos = Long.parseLong(t2.getNanos());
                    if (t1Nanos > t2Nanos) return true;
                }
            }
        }
        return false;
    }

    public boolean isLeapYear() {
        int year = getYear();
        if ((year % 4 == 0 && year % 100 != 0)  
            || (year % 400 == 0)) { 
            return true; 
        } else { 
            return false; 
        } 
    }
    

    
    public static boolean isLessHMS(Time t1, Time t2) {
        int t1Hours = t1.getHours();
        int t2Hours = t2.getHours();
        if (t1Hours < t2Hours) return true;
        else if (t1Hours == t2Hours) {
            int t1Minutes = t1.getMinutes();
            int t2Minutes = t2.getMinutes();
            if (t1Minutes < t2Minutes) return true;
            else if (t1Minutes == t2Minutes) {
                int t1Seconds = t1.getSeconds();
                int t2Seconds = t2.getSeconds();
                if (t1Seconds < t2Seconds) return true;
            }
        }
        return false;
    }

    public static boolean isLessHMSN(Time t1, Time t2) {
        int t1Hours = t1.getHours();
        int t2Hours = t2.getHours();
        if (t1Hours < t2Hours) return true;
        else if (t1Hours == t2Hours) {
            int t1Minutes = t1.getMinutes();
            int t2Minutes = t2.getMinutes();
            if (t1Minutes < t2Minutes) return true;
            else {
                int t1Seconds = t1.getSeconds();
                int t2Seconds = t2.getSeconds();
                if (t1Seconds < t2Seconds) return true;
                else if (t1Seconds == t2Seconds) {
                    long t1Nanos = Long.parseLong(t1.getNanos());
                    long t2Nanos = Long.parseLong(t2.getNanos());
                    if (t1Nanos < t2Nanos) return true;
                }
            }
        }
        return false;
    }
    
    public boolean isPM() { return segment.equals("PM"); }

    public static String longToHMS(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);         
        java.util.Date d = (java.util.Date) c.getTime();        
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");       
        return format.format(d);
    }
    
    public static String longToHMS(String time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Long.parseLong(time));         
        java.util.Date d = (java.util.Date) c.getTime();        
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");       
        return format.format(d);
    }
    
    public static String longToYMD(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);         
        java.util.Date d = (java.util.Date) c.getTime();        
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");       
        return format.format(d);
    }
    
    public static String longToYMD(String time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Long.parseLong(time));         
        java.util.Date d = (java.util.Date) c.getTime();        
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");       
        return format.format(d);
    }
    
    public static String longToYMD_HMS(String time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Long.parseLong(time));         
        java.util.Date d = (java.util.Date) c.getTime();        
        String result = new SimpleDateFormat("yyyy-MM-dd").format(d)
                                  + " " +
                                  new SimpleDateFormat("HH:mm:ss").format(d);       
        return result;
    }
    
    public static String longToYMD_HMS(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);         
        java.util.Date d = (java.util.Date) c.getTime();        
        String result = new SimpleDateFormat("yyyy-MM-dd").format(d)
                                  + " " +
                                  new SimpleDateFormat("HH:mm:ss").format(d);       
        return result;
    }
    
    public static String longToYMD_T_HMS(String time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Long.parseLong(time));         
        java.util.Date d = (java.util.Date) c.getTime();        
        String result = new SimpleDateFormat("yyyy-MM-dd").format(d)
                                  + "T" +
                                  new SimpleDateFormat("HH:mm:ss").format(d);       
        return result;
    }
    
    public static String longToYMD_T_HMS(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        java.util.Date d = (java.util.Date) c.getTime();        
        String result = new SimpleDateFormat("yyyy-MM-dd").format(d)
                                  + "T" +
                                  new SimpleDateFormat("HH:mm:ss").format(d);       
        return result;
    }
    
    public static void main(String[] args) {
        System.out.println("SecondsToMidnight: " + getSecondsToMidnight());
        System.out.println("Day: " + getDayOfMonth());
        System.out.println(new Time().getHM24(":"));
        System.exit(0);
        int mins = getMinutesToNextHour();
        int secs = getSecondsToNextMinute();
        System.out.println("To Next Hour: mins: " + mins + " secs: " + secs);
        System.out.println("Total Seconds: " + ((mins * 60) + secs));
        Platform.sleep((mins * 60 + secs) * 1000);
        System.out.println("Time: " + new Time().getCompressedFullHMS24());
        
    }

    public static Time parseHMS24(String s) {
        Time time = new Time();
        String hours = s.substring(0, s.indexOf(":"));
        String minutes = s.substring(s.indexOf(":") + 1, s.lastIndexOf(":"));
        String seconds = s.substring(s.lastIndexOf(":") + 1);
        time.setHours(Integer.parseInt(hours));
        time.setMinutes(Integer.parseInt(minutes));
        time.setSeconds(Integer.parseInt(seconds));
        return time;
    }

    public static long secondsBetween(Time t1, Time t2) {
        if (isLessHMS(t2,t1)) {
            return getSecondsToWithMidnightCrossover(t1,t2);
        } else {
            return getSecondsTo(t1,t2);
        }
    }
    
    public void setLocalDate(LocalDate localDate) { this.localDate = localDate; }
    
    public void setLocalTime(LocalTime localTime) { this.localTime = localTime; }
    
    public void setZone(String zone) { this.zone = zone; }
    
    public void setZoneId(String zoneId) { this.zoneId = zoneId; }
     
    public void setHours(int hour) { 
        this.hour = hour; 
        this.hours = "" + hour;
    }
     
    public void setMinutes(int minute) { 
        this.minute = minute; 
        this.minutes = "" + minute;
    }
    
    public void setSeconds(int seconds) {
        this.second = seconds;
        this.seconds = "" + seconds;
    }
    
    public void setNanos(int nanos) {
        this.nano = nanos;
        this.nanos = "" + nanos;
    }
    
    public void startOfDayTest() {
        ZonedDateTime ammanStart = getStartOfDay("2021-03-26","Asia/Amman");
        System.out.println("startAmman: " + ammanStart);
    } 

}
 