package ca.tecreations.net;

import ca.tecreations.*;
import ca.tecreations.net.tsp.*;
import ca.tecreations.time.Time;

import java.awt.event.*;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;

import java.util.ArrayList;
import java.util.List;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext; 
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
/**
 *
 * @author tim
 */
public class Server implements Runnable, ActionListener {
    public static boolean exitOnStartupFailure = true;
    public static String SN = Server.class.getSimpleName();
    ca.tecreations.Properties properties;
    private int port = 52820;
    boolean encrypted = false;
    KeyStore keyStore = null;
    char[] keyStorePass;
    KeyStore trustStore = null;

    static ServerSocket serverSocket = null;
    static SSLServerSocket sslServerSocket = null;
    SSLContext sslContext;
    KeyManagerFactory keyMgrFact;
    SSLServerSocketFactory fact;

    private boolean running = true;

    Socket rawSocket = null;
    SSLSocket tlsSocket = null;
    String clientIP;
    String clientHostName;

    boolean trace = false;
    boolean debug = false;
    boolean verbose = false;

    public static String SCREENSHOT_PATH = ProjectPath.getTecImagesPath() + "ServerScreenshot.png";

    TLS_TSPS tsps = null;

    static List<Socket> clients = new ArrayList<>();

    Timer timer;
    
    Server_Blacklist blacklist = new Server_Blacklist();
     
    List<String> preamble = new ArrayList<>();
    
    public long startTime;
    
    public Server(Properties properties, boolean encrypt, char[] ksp, boolean withTSPS, boolean debug, boolean verbose) {
        String msg;
        this.properties = properties;
        if (this.properties.wasCreated()) {
            doInitialSetup(this.properties);
            System.exit(0);
        } else {
            msg = "Properties: " + this.properties.getFilename();
            doPreambleAction(msg);
            String sPort = properties.get(PKIData.REMOTE_PORT);
            if (sPort != null) port = Integer.parseInt(sPort);
        }
        encrypted = encrypt;
        try {
            if (encrypted) {
                if (ksp == null) {
                    // check properties for password
                    String pass = this.properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD);
                    if (pass == null || pass.toLowerCase().equals("prompt")) {
                        this.keyStorePass = Platform.requestPassword(null, "Enter the keystore pass for: localhost: [" + Internet.getWanIP() + "]:" + Internet.getLanIP() + " : " + port);
                    } else {
                        this.keyStorePass = pass.toCharArray();
                    }
                } else if (SharedCode.isPrompt(ksp)) {
                    this.keyStorePass = Platform.requestPassword(null, "Enter the keystore pass for: localhost: [" + Internet.getWanIP() + "]:" + Internet.getLanIP() + " : " + port);
                } else {
                    this.keyStorePass = ksp;
                }
                Boolean makeSecure = this.properties.getBoolean("make.secure");
                if (makeSecure == null || makeSecure) {
                    if (ksp != null) {
                        for (int i = 0; i < ksp.length; i++) {
                            ksp[i] = '\0';
                        }
                    }
                }
                doOpenTLSSocket();
            } else {
                serverSocket = new ServerSocket(port);
                msg = SN + "(): Server socket opened on port: " + port;
                doPreambleAction(msg);
            }
            if (serverSocket != null) {
                newListener(); // start waiting for connections
                msg = "Started " + SN + " on port: " + port + " " + (encrypted ? "Encrypted" : "Un-encrypted");
                doPreambleAction(msg);
            } else {
                msg = "ServerSocket is NULL";
                doPreambleAction(msg);
            }
        } catch (IOException ioe) { 
            msg = ExceptionHandler.handleIO(SN + ".run", "Opening serverSocket Failed. Exiting.", ioe, false);
            doLogAction(msg);
            System.exit(0);
        }
        this.debug = debug; 
        this.verbose = verbose;
        timer = new Timer(this,333);
        timer.start(); 
        properties.set("is.running",true);
        startTime = System.currentTimeMillis();
        properties.set("shutdown",false);
        if (withTSPS) {
            tsps = new TLS_TSPS(properties,preamble);
            tsps.start();
        } 
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == timer) {
            properties.read(debug);
            if (properties.getBoolean("shutdown")) {
                shutdown();
            }
        }
    }
    
    public final void doInitialSetup(ca.tecreations.Properties properties) {
        properties.setDelayWrite(true);
        properties.set(PKIData.DEBUG_SSL, "false");
        properties.set(PKIData.MAKE_SECURE, "true");
        boolean isWin = Platform.isWin();
        properties.set(PKIData.REMOTE_KEYSTORE, (isWin ? "S:\\" : "/") + "security" + File.separator + "server_keystore");

        properties.set(PKIData.REMOTE_KEYSTORE_PASSWORD, "prompt");
        properties.set(PKIData.REMOTE_PORT, port);
        properties.set(PKIData.REMOTE_TRUSTSTORE, (isWin ? "S:\\" : "/") + "security" + File.separator + "server_truststore");
        properties.write();
        doLogAction(SN + ".doInitialSetup: Configure properties and re-run: " + properties.getFilename());
    }

    public final void doLogAction(String s) {
        System.out.println(s);
        if (tsps != null) tsps.out(s);
    }

    public final void doLogAction(int sysStreamType, String s) {
        if (sysStreamType == TecData.SYS_ERR) {
            System.err.println(s);
            if (tsps != null) tsps.err(s);
        } else {
            System.out.println(s);
            if (tsps != null) tsps.out(s);
        }
    }

    public final void doPreambleAction(String s) {
        preamble.add(s);
        System.out.println(s);
    }

    public final void doOpenTLSSocket() {
        try {
            String ksPath = ProjectPath.getActual(properties.get(PKIData.REMOTE_KEYSTORE));
            if (ksPath == null) {
                doInitialSetup(properties);
                System.err.println("Invalid configuration: " + properties.getFilename());
                System.err.println("Please validate. Exiting.");
                System.exit(0);
            }
            if (!new File(ksPath).exists()) {
                System.err.println("Keystore file does not exist: " + ksPath);
                System.err.println("Properties: " + properties.getFilename());
                System.exit(0);
            }
            keyStore = ca.tecreations.net.bc.SecurityTool.openKeyStore(ca.tecreations.net.bc.SecurityTool.JKS, ksPath, keyStorePass);
            sslContext = SSLContext.getInstance(ca.tecreations.net.bc.SecurityTool.TLS, ca.tecreations.net.bc.SecurityTool.BCJSSE);
            keyMgrFact = KeyManagerFactory.getInstance(ca.tecreations.net.bc.SecurityTool.PKIX, ca.tecreations.net.bc.SecurityTool.BCJSSE);
            keyMgrFact.init(keyStore, keyStorePass);
            sslContext.init(keyMgrFact.getKeyManagers(), null, null);
            fact = sslContext.getServerSocketFactory();
        } catch (Exception e) {
            doPreambleAction(ExceptionHandler.handle(SN, e));
            doLogAction(SN + ".doOpenTLSSocket: Properties File: " + properties.getFilename());
            doLogAction(SN + ".doOpenTLSSocket: No Keystore: " + properties.get(PKIData.REMOTE_KEYSTORE) + " pass: " + TypeToType.toString(keyStorePass));
            doLogAction(SN + ".doOpenTLSSocket: properties: " + properties.getFilename());
            doLogAction(SN + ".doOpenTLSSocket: Exiting.");
            if (properties.getBoolean(PKIData.MAKE_SECURE)) {
                properties.set(PKIData.REMOTE_KEYSTORE_PASSWORD, "");
            }
            System.exit(0);
        }
        for (int i = 0; i < keyStorePass.length; i++) {
            keyStorePass[i] = '\0';
        }
        if (properties.getBoolean(PKIData.MAKE_SECURE)) {
            properties.set(PKIData.REMOTE_KEYSTORE_PASSWORD, "");
        } 
        String tsPath = ProjectPath.getActual(properties.get(PKIData.REMOTE_TRUSTSTORE));
        if (tsPath == null) {
            doInitialSetup(properties);
            doLogAction(TecData.SYS_ERR, "Invalid configuration: " + properties.getFilename());
            doLogAction(TecData.SYS_ERR, "Please validate. Exiting.");
            System.exit(0);
        }
        if (!new File(tsPath).exists()) {
            doLogAction(TecData.SYS_ERR, "Truststore file does not exist: " + tsPath);
            doLogAction(TecData.SYS_ERR, "Properties: " + properties.getFilename());
            System.exit(0);
        }
        trustStore = ca.tecreations.net.bc.SecurityTool.openTrustStore(ca.tecreations.net.bc.SecurityTool.JKS, tsPath);
        if (keyStore == null || trustStore == null) {
            doLogAction(TecData.SYS_ERR, SN + ".doOpenTLSSocket: Unable to open keyStore or trustStore. Cannot continue.");
            doLogAction(TecData.SYS_ERR, SN + ".doOpenTLSSocket: Verify setup and re-run: " + properties.getFilename());
            System.exit(0);
        }
        try {
            serverSocket = (SSLServerSocket) fact.createServerSocket(port);
            doLogAction(SN + ".doOpenTLSSocket: TLS Server socket opened on port: " + port);
        } catch (Exception e) {
            if (e instanceof java.net.BindException) {
                doLogAction(TecData.SYS_ERR, SN + ".doOpenTLSSocket: port: " + port + " Bind exception: " + e);
                if (exitOnStartupFailure) {
                    System.exit(0);
                }
            } else {
                ExceptionHandler.handle("TLSServer.openServerSocket", e);
            }
        }

    }
    
    public String getCommsType() { return (encrypted ? "encrypted" : "plain-text"); }
    
    public Socket getSocket() {
        if (encrypted) return tlsSocket;
        else return rawSocket;
    }
     
    public String getUpTime() {
        long now = System.currentTimeMillis();
        return Time.getElapsedTimeYYYYMMDD_HmmssSSS(startTime,now);
    }
    
    public static void launch(Properties properties, boolean encrypt, char[] ksp, boolean withTSPS, boolean debug, boolean verbose) {
        new Server(properties,encrypt,ksp,withTSPS,debug,verbose);
    }
    
    public static void main(String[] args) {
        Properties properties = new Properties(ProjectPath.getTecPropsPath() + "Server.properties");
        boolean encrypt = true;
        boolean withTSPS = true;
        boolean debug = true;
        boolean verbose = true;
        launch(properties, encrypt, null, withTSPS,debug,verbose);
    }
    
    public final void newListener() {
        new Thread(this).start();
    }

    public void run() {

        // wait for a connection
        try {
            if (encrypted) tlsSocket = (SSLSocket)serverSocket.accept();
            else rawSocket = serverSocket.accept();
            clientIP = getSocket().getInetAddress().toString();
            if (clientIP.contains("127.0.0.1")) {
                clientIP = Internet.getLanIP();
            } else {
                clientIP = clientIP.substring(clientIP.indexOf("/") + 1); 
            }  
            clientHostName = Internet.getHostname(clientIP);
            if (blacklist.contains(clientIP)) {
                doLogAction(TecData.SYS_OUT, "BLOCKED: " + clientIP + " host: " + clientHostName);
                getSocket().close();
            } else { 
                doLogAction(TecData.SYS_OUT, "ALLOWED: " + clientIP + " host: " + clientHostName);
                clients.add(getSocket());
            } 
            //in = clientSocket.getInputStream();
            //out = clientSocket.getOutputStream();
        } catch (IOException ioe) {
            ExceptionHandler.handleIO(SN + ".run", "opening clientSocket", ioe, false);
        }
         
        // create a new thread to accept the next connection
        newListener(); 
  
        new Thread(new ClientHandler(this, getSocket(), clientIP, clientHostName, debug)).start();
    }
     
    public void shutdown() { 
        properties.set("is.running",false);
        properties.set("shutdown",false);
        System.exit(0);
    }
    
     
}
