package ca.tecreations.net;

import ca.tecreations.ExceptionHandler;
import ca.tecreations.File;
import ca.tecreations.Pair;

import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 */
public class GetDirSize extends Thread {
    public static final String SN = GetDirSize.class.getSimpleName();
    public Client client;
    public String absPath;
    boolean running = false;
    List<GetDirSize> subs = new ArrayList<>();


    
    public GetDirSize(Client client, String absPath, boolean autoStart) {
        try {
            this.client = new Client(client);
        } catch (NoTLSConnectionException ntlsce) {
            ExceptionHandler.handle(SN + "(): No TLS Connection",ntlsce);
        }
        this.absPath = absPath;
        if (autoStart) start();
    }
    
    public void run() {
        Pair pair = new Pair(absPath);
        List<File> dirs = pair.getDirs();
        List<GetDirSize> subs = new ArrayList<>();
        for(int i = 0; i < dirs.size();i++) {
            subs.add(new GetDirSize(client,dirs.get(i).getAbsolutePath(),true));
        }
        while (running) {
            
        }
    }
    
    @Override
    public void start() {
        running = true;
        super.start();
    }
    
    
}
