// https://stackoverflow.com/questions/1092411/java-checking-if-a-bit-is-0-or-1-in-a-long


package ca.tecreations.misc;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
public class BitSet {
    List<Integer> bitSet = new ArrayList<>();
    
    public BitSet() {}
    
    public BitSet(int initialValue) {
        int val;
        for(int i = 0; i < 32;i++) { 
            val = initialValue >> i & 0x01;
            bitSet.add(val);
        }
    }
    
    public BitSet(long initialValue) {
        long val;
        for(int i = 0; i < 64;i++) { 
            val = initialValue >> i & 0x01;
            if (val > 0) bitSet.add(1);
            else bitSet.add(0);
        }
    }
    
    public void add(int bitVal) {
        if (bitVal > 1 || bitVal < 0) throw new IllegalArgumentException("Invalid bit value: Must be 1 or 0: " + bitVal);
        bitSet.add(bitVal); 
    }
    
    public void add(int index, int bitVal) {
        if (bitVal > 1 || bitVal < 0) throw new IllegalArgumentException("Invalid bit value: Must be 1 or 0: " + bitVal);
        bitSet.add(index,bitVal); 
    }
    
    public int get(int index) {
        return bitSet.get(index);
    }
    
    public boolean isSet(int index) {
        return bitSet.get(index) > 0;
    }
    
    public static void main(String[] args) {
        BitSet bitSet;
        
        for(int i = 0; i < 8; i++) {
            bitSet = new BitSet(i);
            //bitSet = bitSet.reverse(bitSet);
            System.out.print(i + ": ");
            System.out.print((bitSet.isSet(0) ? "r" : "-"));
            System.out.print((bitSet.isSet(1) ? "w" : "-"));
            System.out.print((bitSet.isSet(2) ? "x" : "-"));
            System.out.println();
        }
    }
    
    public void println() {
        for(int i = 0; i < bitSet.size();i++) {
            System.out.print(bitSet.get(i));
        }
        System.out.println();
    }
    
    public static BitSet reverse(BitSet src) {
        BitSet copy = new BitSet();
        for(int i = src.size() - 1; i >= 0; i--) {
            copy.add(src.get(i));
        }
        return copy;
    }
    
    public int size() { return bitSet.size(); }
}
