package ca.tecreations.graphics;

import ca.tecreations.*;
import ca.tecreations.apps.capturetool.CaptureTool;
import ca.tecreations.components.*;
import ca.tecreations.db.mysql.MySQL;
import ca.tecreations.graphics.*;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.*;
import java.awt.image.*;
import java.util.*;

import javax.swing.*;

/**
 *
 * @author tim
 */
public class WebExtractor extends CaptureTool
        implements Runnable, ActionListener, MouseListener, MouseMotionListener {

    Robot robot;
    public static final String SN = WebExtractor.class.getSimpleName();
    public static WebExtractor app;

    public static final String createTable
            = "CREATE TABLE unicode_points (\n"
            + "    id INT AUTO_INCREMENT NOT NULL PRIMARY KEY,\n"
            + "    description varchar(32) NOT NULL DEFAULT '',\n"
            + "    z VARCHAR(1) NOT NULL,\n"
            + "    a VARCHAR(1) NOT NULL,\n"
            + "    b VARCHAR(1) NOT NULL,\n"
            + "    c VARCHAR(1) NOT NULL,\n"
            + "    d VARCHAR(1) NOT NULL,\n"
            + "    points VARCHAR(6144)\n"
            + ")";

    public static ca.tecreations.Properties engineProperties = new ca.tecreations.Properties(ProjectPath.getTecPropsPath() + "Engine.properties");
    private static char[] pass = engineProperties.get("mysql.pass").toCharArray();
    private static MySQL mysql = new MySQL("tecreations.ca", 3306, "sitesec_dev", "sitesec_user", pass);

    BufferedImage capture;

    TColor maskColor = TColor.TEC_PURPLE;

    boolean running = false;

    WebExtractorMenuBar menubar = null;
    Status status;

    BoundingBox box;

    public Magnifier magnifier = new Magnifier();

    List<Integer> xStarts = new ArrayList<>();
    List<Integer> xEnds = new ArrayList<>();
    List<Integer> yStarts = new ArrayList<>();
    List<Integer> yEnds = new ArrayList<>();

    JPopupMenu popup = new JPopupMenu();
    JMenuItem extract = new JMenuItem("Capture and Extract");

    BufferedImage table;
    Point tableTL;
    Point tableBR;

    BufferedImage sample;
    Point stl; // sample top left (includes column/row tags)
    Point sbr; // sample bottom right

    BufferedImage target;
    Point ttl;
    Point tbr;

    public WebExtractor() {
        super();
        try {
            robot = new Robot();
        } catch (AWTException awte) {
            System.err.println("Robot unavailable...");
        }
        display.overrideMouse();
        menubar = new WebExtractorMenuBar(this);
        setJMenuBar(menubar);
        status = new Status(true, true, true, false, true);
        add(status, BorderLayout.SOUTH);
        box = display.getBoundingBox();
        display.addMouseListener(this);
        display.addMouseMotionListener(this);
        box.addMouseListener(this);
        box.addMouseMotionListener(this);
        validate();
        popup.add(extract);
        extract.addActionListener(this);
        Platform.sleep(2000);
        recapture();
        scrollToBottomLeft();
        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == status.getCommand()) {
            String command = status.getCommandText();
            String lower = command.toLowerCase();
            List<String> parts = StringTool.explode(command, ' ');
            if (lower.contains("size box ")) { // size box width# height #
                int w = Integer.parseInt(parts.get(1));
                int h = Integer.parseInt(parts.get(2));
                box.setSize(w, h);
            } else if (lower.contains("locate box ")) { // locate box x# y#
                int x = Integer.parseInt(parts.get(1));
                int y = Integer.parseInt(parts.get(2));
                box.setLocation(x, y);
            } else if (lower.contains("move ")) {
                int lr = Integer.parseInt(parts.get(1));
                int ud = Integer.parseInt(parts.get(2));
                java.awt.Point p = box.getLocation();
                box.setLocation(p.x + lr, p.y + ud);
            } else if (lower.contains("print box data")) {
                System.out.println("Box: loc: " + box.getLocation() + " size: " + box.getSize());
            } else if (lower.trim().equals("exit")) {
                System.exit(0);
            } else if (lower.startsWith("locate")) { // locate x# y#
                int x = Integer.parseInt(parts.get(1));
                int y = Integer.parseInt(parts.get(2));
                Graphics g = getGlassPane().getGraphics();
                GraphicsUtil.locatePoint(g, x, y);
                display.repaint();
            }
        } else if (e.getSource() == extract) {
            extract();
        }
        repaint();
    }

    public void extract() {
        BufferedImage target = getImageToProcess();
        magnifier = new Magnifier(target);
        //magnifier.setImage(target);
        magnifier.setVisible(true);
        magnifier.toFront();
        magnifier.rescale();
        process(target);
    }

    public int getBottomCrop() {
        Pixel[] row;
        for (int i = 0; i < capture.getHeight(); i++) {
            row = ImageTool.extractPixels(capture, 0, capture.getHeight() - 1 - i, capture.getWidth(), 1);
            if (isMixed(row, TColor.TEC_ORANGE)) {
                return i;
            }
        }
        return 0;
    }

    public int getBorderThickness() {
        BufferedImage cropped = sample;
        int count = 0;
        int target = ImageTool.getTopLeftColor(sample).getRGB();
        while (ImageTool.isSurrounded(cropped) && ImageTool.getRGB(sample, count, count) == target) {
            count++;
            cropped = ImageTool.getCropped(cropped, 1);
        }
        return count;
    }

    public List<Rectangle> getCellIndices(BufferedImage target) {
        xStarts = new ArrayList<>();
        xEnds = new ArrayList<>();
        yStarts = new ArrayList<>();
        yEnds = new ArrayList<>();
        int[] row = ImageTool.getRow(target, target.getHeight() - 5);
        int[] col = ImageTool.getCol(target, target.getWidth() - 5);
        int orange = TColor.TEC_ORANGE.getRGB();
        int index = row.length - 1;
        for (int i = 0; i < 16; i++) {
            while (row[index] == orange) {
                index--;
            }
            xEnds.add(index + 1);
            while (row[index] != orange) {
                index--;
            }
            xStarts.add(index + 1);
        }
        index = col.length - 1;
        for (int i = 0; i < 16; i++) {
            while (col[index] == orange) {
                index--;
            }
            yEnds.add(index + 1);
            while (col[index] != orange) {
                index--;
            }
            yStarts.add(index + 1);
        }
        xStarts = TypeToType.reverse(xStarts);
        xEnds = TypeToType.reverse(xEnds);
        yStarts = TypeToType.reverse(yStarts);
        yEnds = TypeToType.reverse(yEnds);
        boolean verbose = false;
        if (debug && verbose) {
            System.out.println("xStarts: " + xStarts);
            System.out.println("xEnds  : " + xEnds);
            System.out.println("yStarts: " + yStarts);
            System.out.println("yEnds  : " + yEnds);
        }
        List<Rectangle> cellIndices = new ArrayList<>();
        int w;
        int h;
        for (int y = 0; y < 16; y++) {
            h = yEnds.get(y) - yStarts.get(y);
            for (int x = 0; x < 16; x++) {
                w = xEnds.get(x) - xStarts.get(x);
                cellIndices.add(new Rectangle(xStarts.get(x), yStarts.get(y), w, h));
            }
        }
        return cellIndices;
    }

    public BufferedImage getFor(BufferedImage target, Rectangle r) {
        int[] pix = ImageTool.extract(target, r);
        return ImageTool.getImageFromIntArray(pix, r.width, r.height);
    }

    public BufferedImage getImageToProcess() {
        int absY = Math.abs(display.getLocation().y);
        scrollToBottomLeft();
        toFront();

        Point tl = Point.getTopLeftCoordinate(capture, TColor.TEC_ORANGE);
//        System.out.println("topLeft: " + tl.toString());
        //locatePoint(tl.x, tl.y - absY + menubar.getSize().height);

        int w = capture.getWidth();
        int h = capture.getHeight();

        Point br = Point.getBottomRightCoordinate(capture, TColor.TEC_ORANGE);
//        System.out.println("botRght: " + br.toString());

        //locatePoint(br.x, br.y - absY + menubar.getSize().height);
        int targetWidth = br.x - tl.x;
        int targetHeight = br.y - tl.y;
        BufferedImage target
                = ImageTool.getImageFromIntArray(
                        ImageTool.extract(capture, tl.x, tl.y, targetWidth, targetHeight),
                        targetWidth, targetHeight);
        return target;
    }

    public int getLeftCrop() {
        Pixel[] row;
        for (int i = 0; i < capture.getWidth(); i++) {
            row = ImageTool.extractPixels(capture, i, 0, 1, capture.getHeight());
            if (isMixed(row, TColor.TEC_ORANGE)) {
                return i;
            }
        }
        return 0;
    }

    public int getRightCrop() {
        Pixel[] row;
        for (int i = 0; i < capture.getWidth(); i++) {
            row = ImageTool.extractPixels(capture, capture.getWidth() - 1 - i, 0, 1, capture.getHeight());
            if (isMixed(row, TColor.TEC_ORANGE)) {
                return i;
            }
        }
        return 0;
    }

    public BufferedImage getSampleImage() {
        return sample;
    }

    public BufferedImage getSquashed(BufferedImage src, Color exclude) {
        BufferedImage trimmed = getTrimmedLeft(src, exclude);
        if (trimmed != null) {
            trimmed = getTrimmedTop(trimmed, exclude);
        }
        if (trimmed != null) {
            trimmed = getTrimmedBottom(trimmed, exclude);
        }
//                    Magnifier mag = new Magnifier(trimmed);
//                    mag.setDisposeOnClose(true);
//                    mag.setVisible(true);
//                    mag.rescale(16);
//                    mag.setTitle("Magnifier: trimmed: bottom");

        if (trimmed != null) {
            trimmed = getTrimmedRight(trimmed, exclude);
        }
//                    Magnifier mag2 = new Magnifier(trimmed);
//                    mag2.setDisposeOnClose(true);
//                    mag2.setVisible(true);
//                    mag2.rescale(16);
//                    mag2.setTitle("Magnifier: trimmed: right");
        return trimmed;
    }

    public BufferedImage getTargetImage() {
        return target;
    }

    public int getTopCrop() {
        Pixel[] row;
        for (int i = 0; i < capture.getHeight(); i++) {
            row = ImageTool.extractPixels(capture, 0, i, capture.getWidth(), 1);
            if (isMixed(row, TColor.TEC_ORANGE)) {
                return i + 1;
            }
        }
        return 0;
    }

    public BufferedImage getTopLeftContainment(BufferedImage src) {
        BufferedImage result;
        ImageScanner scanner = new ImageScanner(src);
        scanner.moveTo(10, 10);
        Point br = scanner.collideSE(TColor.TEC_ORANGE);
        //Point br = scanner.collideE(TColor.TEC_ORANGE);
        return ImageTool.getImageFromIntArray(ImageTool.extract(sample, 0, 0, br.x, br.y), br.x, br.y);
    }

    public Point getTopLeftPageCoordinate() {
        int w = capture.getWidth();
        int h = capture.getHeight();
        int tec_mid_gray = new TColor(127, 127, 127, 255).toIntARGB();

        for (int y = 0; y < h; y++) {
            int[] row = ImageTool.getRow(capture, y);
            for (int x = 0; x < w; x++) {
                if (row[x] == tec_mid_gray) {
                    return new Point(x, y);
                }
            }
        }
        return null; // not found
    }

    public BufferedImage getTrimmedBottom(BufferedImage src, Color exclude) {
        Pixel[] row;
        int bottom = 0;
        row = ImageTool.extractPixels(src, 0, src.getHeight() - 1, src.getWidth(), 1);
        while (bottom < src.getHeight() && !isMixed(row, exclude)) {
            bottom++;
            row = ImageTool.extractPixels(src, 0, src.getHeight() - bottom, src.getWidth(), 1);
        }
        if (bottom < src.getHeight()) {
            int newHeight = src.getHeight() - bottom + 1;
            int[] pix = ImageTool.extract(src, 0, 0, src.getWidth(), newHeight);
            return ImageTool.getImageFromIntArray(pix, src.getWidth(), newHeight);
        } else {
            return null;
        }
    }

    public BufferedImage getTrimmedLeft(BufferedImage src, Color exclude) {
        Pixel[] col;
        int left = 0;
        col = ImageTool.extractPixels(src, 0, 0, 1, src.getHeight());
        while (left < src.getWidth() && !isMixed(col, exclude)) {
            left++;
            col = ImageTool.extractPixels(src, left, 0, 1, src.getHeight());
        }
        if (left < src.getWidth()) {
            int newWidth = src.getWidth() - left;
            int[] pix = ImageTool.extract(src, left, 0, newWidth, src.getHeight());
            return ImageTool.getImageFromIntArray(pix, newWidth, src.getHeight());
        } else {
            return null;
        }
    }

    public BufferedImage getTrimmedRight(BufferedImage src, Color exclude) {
        Pixel[] col;
        int mixed = 0;
        col = ImageTool.extractPixels(src, 0, 0, 1, src.getHeight());
        while (!isAllTheSame(col, exclude) && mixed < src.getWidth()) {
            mixed++;
            col = ImageTool.extractPixels(src, mixed, 0, 1, src.getHeight());
        }
        if (mixed < src.getWidth()) {
            int[] pix = ImageTool.extract(src, 0, 0, mixed, src.getHeight());
            return ImageTool.getImageFromIntArray(pix, mixed, src.getHeight());
        } else {
            return null;
        }
    }

    public BufferedImage getTrimmedTop(BufferedImage src, Color exclude) {
        Pixel[] row;
        int top = 0;
        row = ImageTool.extractPixels(src, 0, 0, src.getWidth(), 1);
        while (top < src.getHeight() && !isMixed(row, exclude)) {
            top++;
            row = ImageTool.extractPixels(src, 0, top, src.getWidth(), 1);
        }
        if (top < src.getHeight()) {
            int newHeight = src.getHeight() - top;
            int[] pix = ImageTool.extract(src, 0, top, src.getWidth(), newHeight);
            return ImageTool.getImageFromIntArray(pix, src.getWidth(), newHeight);
        } else {
            return null;
        }
    }

    public boolean isAllTheSame(Pixel[] pixels, Color target) {
        int targetRGB = target.getRGB();
        for (int i = 0; i < pixels.length; i++) {
            if (pixels[i].getColor().getRGB() != targetRGB) {
                return false;
            }
        }
        return true;
    }

    public boolean isMixed(Pixel[] pixels, Color target) {
        for (int i = 0; i < pixels.length; i++) {
            if (!pixels[i].getColor().equals(target)) {
                return true;
            }
        }
        return false;
    }

    public static void launch() {
        SwingUtilities.invokeLater(() -> {
            app = new WebExtractor();
            app.start();
        });
    }

    public void locatePoint(int x, int y) {
        Graphics g = getGlassPane().getGraphics();
        GraphicsUtil.locatePoint(g, x, y);
        display.repaint();
    }

    public void locatePoint(Point p) {
        locatePoint(p.x, p.y);
    }

    public void magnify(BufferedImage img) {
        Magnifier magnifier = new Magnifier(img);
        magnifier.setVisible(true);
    }

    public static void main(String[] args) {
        launch();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        BufferedImage topLeft = getTopLeftContainment(sample);
        //Magnifier magnifier = new Magnifier(topLeft);
        //magnifier.setVisible(true);

        int headerW = topLeft.getWidth();
        int headerH = topLeft.getHeight();

        if (SwingUtilities.isRightMouseButton(e)) {
            scrollToBottomLeft();
            toFront();

            TColor tecGray = ImageTool.getTColor(capture, 310, 310);
            //System.out.println("Color[310,310]: " + tecGray + " rgba: " + tecGray.toIntARGB());
            Point tl = getTopLeftPageCoordinate();
            //System.out.println("PageTL: " + tl);
            java.awt.Point locOnScreen = e.getLocationOnScreen();
            setVisible(false);
            robot.mouseMove(e.getX(), e.getY());
            robot.mousePress(InputEvent.BUTTON1_DOWN_MASK);
            robot.mouseRelease(InputEvent.BUTTON1_DOWN_MASK);
            robot.mouseMove(locOnScreen.x, locOnScreen.y);
            Platform.sleep(1000);
            recapture();
            setVisible(true);
            repaint();
            popup.show(this, e.getX(), e.getY());
        } else if (withinTarget(e.getX(), e.getY())) {
            System.err.println("within target");
            int surroundedThickness = ImageTool.getSurroundedThickness(table);
            doClickComputations(e.getX(),e.getY(),headerW, headerH, surroundedThickness);
        } else if (withinSample(e.getX(), e.getY())) {
            int surroundedThickness = ImageTool.getSurroundedThickness(table);

            //System.err.println("within sample");
            System.err.println("header width: " + headerW);
            System.err.println("header height: " + headerH);
            doClickComputations(e.getX(),e.getY(),headerW,headerH,surroundedThickness);
            //System.err.println("border thickness: " + getBorderThickness());
            //System.err.println("surrounded count: " + surroundedThickness);
            //for(int i = 0; i < sideStarts.size();i++) {
            //    int start = sideStarts.get(i);
            //    int end = sideEnds.get(i);
            //System.out.println("Start: " + start + " End: " + end);
            //Magnifier mag = new Magnifier(ImageTool.getRegion(sideBar,0,start,sideBar.getWidth(),end - start));
            //mag.setVisible(true);
            //}
        }
    }

    BufferedImage topBar;
    BufferedImage sideBar;
    
    public void doClickComputations(int x, int y, int hWidth, int hHeight, int border) {
        Point pageTL = getTopLeftPageCoordinate();
        //System.out.println("ptl: " + getTopLeftPageCoordinate());
        //System.out.println("stl: " + stl);
        int minX = stl.x;
        int minY = pageTL.y + stl.y;
        topBar = ImageTool.getRegion(sample, hWidth, 0, target.getWidth(), hHeight);
        sideBar = ImageTool.getRegion(sample, 0, hHeight, hWidth, target.getHeight());
        Magnifier m1 = new Magnifier(topBar);
        m1.setVisible(true);
        Magnifier m2 = new Magnifier(sideBar);
        m2.setVisible(true);
        
        int[] row = ImageTool.getRow(topBar, topBar.getHeight() / 2);
        List<Integer> topStarts = new ArrayList<>();
        List<Integer> topEnds = new ArrayList<>();
        int index = 0;
        int orangeRGB = TColor.TEC_ORANGE.getRGB();
        topStarts.add(0);
        while (index < row.length) {
            while (index < row.length && row[index] != orangeRGB) {
                index++;
            }
            topEnds.add(index);
            while (index < row.length && row[index] == orangeRGB) {
                index++;
            }
            if (index < row.length) {
                topStarts.add(index);
            }
        }

        int[] col = ImageTool.getCol(sideBar, sideBar.getWidth() / 2);
        List<Integer> sideStarts = new ArrayList<>();
        List<Integer> sideEnds = new ArrayList<>();
        sideStarts.add(0);
        index = 0;
        while (index < col.length) {
            while (index < col.length && col[index] != orangeRGB) {
                index++;
            }
            sideEnds.add(index);
            while (index < col.length && col[index] == orangeRGB) {
                index++;
            }
            if (index < col.length) {
                sideStarts.add(index);
            }
        }

        int xIndex = 0;
        int yIndex = 0;
        int tgt = x - (stl.x + + hWidth + border);
        for (int i = 0; i < topStarts.size(); i++) {
            if (topStarts.get(i) <= tgt 
                    && topEnds.get(i) >= tgt) {
                xIndex = i;
                i = topStarts.size();
            }
        }
        for (int i = 0; i < sideStarts.size(); i++) {
            System.out.println("Side: " + i + ": " + sideStarts.get(i) + "," + sideEnds.get(i));
        }
        tgt = y - (stl.y + hHeight + border);
        for (int i = 0; i < sideStarts.size(); i++) {
            if (sideStarts.get(i) <= tgt
                    && sideEnds.get(i) >= tgt) {
                yIndex = i;
                i = sideStarts.size();
            }
        }
        System.out.println("XY: " + xIndex + "," + yIndex);

    }

    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == display) {
            status.updateMouse(e.getX(), e.getY());
            int[] pix = ImageTool.extract(capture, e.getX(), e.getY(), 1, 1);
            Color color = new TColor(pix[0]);
            status.setColor(color);
        } else {
            java.awt.Point loc = box.getLocation();
            status.updateMouse(e.getX() + loc.x, e.getY() + loc.y);
            int[] pix = ImageTool.extract(box.getImage(), e.getX(), e.getY(), 1, 1);
            Color color = new TColor(pix[0]);
            status.setColor(color);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == display) {
            status.updateMouse(e.getX() + Math.abs(display.getLocation().x), e.getY() + Math.abs(display.getLocation().y));
            int[] pix = ImageTool.extract(capture, e.getX(), e.getY(), 1, 1);
            Color color = new TColor(pix[0]);
            status.setColor(color);
        } else {
            java.awt.Point loc = box.getLocation();
            status.updateMouse(e.getX() + loc.x, e.getY() + loc.y);
            int[] pix = ImageTool.extract(box.getImage(), e.getX(), e.getY(), 1, 1);
            Color color = new TColor(pix[0]);
            status.setColor(color);
        }
    }

    public void mousePressed(MouseEvent e) {
        int absY = Math.abs(display.getLocation().y);
        locatePoint(e.getX(), e.getY() - (absY - menubar.getSize().height));
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void paint(Graphics g) {
        super.paint(g);
        //display.repaint();
        //status.repaint();
    }

    public void process(BufferedImage target) {
        List<Rectangle> cellIndices = getCellIndices(target);
        for (int i = 0; i < cellIndices.size(); i += 16) {
            BufferedImage full = getFor(target, cellIndices.get(i));
//                    Magnifier mag = new Magnifier(full);
//                    mag.setDisposeOnClose(true);
//                    mag.setVisible(true);
//                    mag.rescale(16);
//                    mag.setTitle("Magnifier: full");
            BufferedImage squashed = getSquashed(full, TColor.WHITE);
//                    Magnifier mag2 = new Magnifier(squashed);
//                    mag2.setDisposeOnClose(true);
//                    mag2.setVisible(true);
//                    mag2.rescale(16);
//                    mag2.setTitle("Magnifier: squashed");
            if (squashed != null) {
                List<Pixel> pixels = ImageTool.getPixelsExcluding(squashed, TColor.white);
                BufferedImage processed = ImageTool.getNewBufferedImage(pixels, Color.cyan);
                //if (i % 16 == 0) {
                Magnifier magnifier2 = new Magnifier(processed);
                magnifier2.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                magnifier2.setVisible(true);
                magnifier2.rescale(16);
                magnifier2.setTitle("Magnifier: " + processed.getWidth() + "," + processed.getHeight());
                //}
                // save processed to disk  ...tecreations/fonts/Unicode/z/a/b/c/d/?code?.properties;
                // hhhhh: {pixel_list}
            }
        }
    }

    public void recapture() {
        display.capture(false);
        capture = display.getImage();
        tableTL = Point.getTopLeftCoordinate(capture, TColor.TEC_ORANGE);
        tableBR = Point.getBottomRightCoordinate(capture, TColor.TEC_ORANGE);
        int w = tableBR.x - tableTL.x;
        int h = tableBR.y - tableTL.y;
        table = ImageTool.getImageFromIntArray(ImageTool.extract(capture, tableTL.x, tableTL.y, w, h), w, h);

        int surroundedThickness = ImageTool.getSurroundedThickness(table);
        int st = surroundedThickness;
        stl = tableTL.add(st, st);
        sbr = tableBR.minus(st, st);
        w = w - (2 * st);
        h = h - (2 * st);
        sample = ImageTool.getImageFromIntArray(ImageTool.extract(table, st, st, w, h), w, h);

        ttl = Point.getTopLeftCoordinate(sample, Color.WHITE);
        tbr = Point.getBottomRightCoordinate(sample, Color.WHITE);
        w = tbr.x - ttl.x;
        h = tbr.y - ttl.y;
        target = ImageTool.getImageFromIntArray(ImageTool.extract(sample, ttl.x, ttl.y, w, h), w, h);
        repaint();
    }

    public void run() {
        //Platform.sleep(2000);
        //while (running) {
        //    captureAndExtract();
        //process(target);

        //magnifier = new Magnifier(target);
        //magnifier.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        //magnifier.setVisible(true);
        //Platform.sleep(15000);
        //recapture();
        //}
    }

    public void start() {
        running = true;
        new Thread(this).start();
    }

    public void stopRunning() {
        running = false;
    }

    public boolean withinSample(int x, int y) {
        return stl.x <= x && sbr.x >= x && stl.y <= y && sbr.y >= y;
    }

    public boolean withinTarget(int x, int y) {
        int xOff = stl.x + ttl.x;
        int maxX = xOff + (tbr.x - ttl.x);
        int yOff = stl.y + ttl.y;
        int maxY = yOff + (tbr.y - ttl.y);
        return x >= xOff && x <= maxX && y >= yOff && y <= maxY;
    }

}
