package ca.tecreations.graphics;

import ca.tecreations.Point;

import java.awt.*;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */
public class BezierCurve extends DrawObject {
    public static int curveNum = 0;
    public static final int START = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    public static final int UP_LEFT = 0;
    public static final int UP_RIGHT = 1;
    public static final int DOWN_LEFT = 2;
    public static final int DOWN_RIGHT = 3;
    public static final int LEFT_UP = 4;
    public static final int LEFT_DOWN = 5;
    public static final int RIGHT_UP = 6;
    public static final int RIGHT_DOWN = 7;
    //JPanel container;
    Line l1 = new Line();
    Line l2 = new Line();
    Line l3 = new Line();
    //Handle start = new Handle(Handle.NONE);
    //Handle middle = new Handle(Handle.NONE);
    //Handle end = new Handle(Handle.NONE);
    boolean firstRun = true;
    List<Point> curvePoints;
    boolean drawLines = true;
    
    public BezierCurve(Color lineColor,int orientation) {
        setName("BezierCurve" + ++curveNum);
        //this.view = view;
        setLineColor(lineColor);
        l1.setLineColor(lineColor);
        l2.setLineColor(lineColor);
        l3.setLineColor(lineColor);
        setOrientation(orientation);
        //view.addObject(this);
        //view.add(start);
        //view.add(middle);
        //view.add(end);
        //view.addObject(this); 
        //view.addObject(l1);
        //view.addObject(l2);
        //view.addObject(l3);
    //    l1.drawInterpolated = true;
    //    l2.drawInterpolated = true;
    //    l3.drawInterpolated = true;
        //start.addMouseListener(this);
        //start.addMouseMotionListener(this);
        //middle.addMouseListener(this);
        //middle.addMouseMotionListener(this);
        //end.addMouseListener(this);
        //end.addMouseMotionListener(this);
        //start.setName("Start" + start.getName());
        //middle.setName("Middle" + middle.getName());
        //end.setName("End" + end.getName());
        //view.addAnimated(new BezierInterpolation(l1,l2,l3));
        
        compute();
    }

/*    public BezierCurve(View view,Handle start,Color lineColor,int orientation) {
        this.start = start;
        setName("BezierCurve" + ++curveNum);
        this.view = view;
        l1.setTranslation(new Point(start.getCX(),start.getCY()));
        setLineColor(lineColor);
        l1.setLineColor(lineColor);
        l2.setLineColor(lineColor);
        setOrientation(orientation);
        view.addObject(this);
        //view.add(start);
        view.add(middle);
        view.add(end);
        view.addObject(this);
        view.addObject(l1);
        view.addObject(l2);
        view.addObject(l3);
        l1.setLineColor(Color.pink);
        l2.setLineColor(Color.pink);
        l3.setLineColor(Color.green);
        l1.drawInterpolated = true;
        l2.drawInterpolated = true;
        l3.drawInterpolated = true;
        start.addMouseListener(this);
        start.addMouseMotionListener(this);
        middle.addMouseListener(this);
        middle.addMouseMotionListener(this);
        end.addMouseListener(this);
        end.addMouseMotionListener(this);
        //start.setName("Start" + start.getName());
        middle.setName("Middle" + middle.getName());
        end.setName("End" + end.getName());
        view.addAnimated(new BezierInterpolation(l1,l2,l3));
        
        compute();
    }
*/    
    public void compute() {
        curvePoints = new ArrayList<>();
        Point txy = getTXY();
        double max = Math.min(l1.getLinePoints().size(),l2.getLinePoints().size());
        for(int i = 0; i < max;i++) {
            l1.setInterpolated(i,max);
            l2.setInterpolated(i,max);
            l3.setTranslation(l1.getInterpolatedWithTXY());
            l3.setEndPoint(getEndPoint(l1.getInterpolatedWithTXY(),l2.getInterpolatedWithTXY()));
            l3.setInterpolated(i,max);
            Point p = l3.getInterpolatedWithTXY();
            curvePoints.add(new Point(txy.x + p.x,txy.y + p.y));
        }
        curvePoints = reinterpolate(curvePoints);
    }

    public void draw(Graphics g) {
        draw(g,getTX(),getTY());
    }
    
    public void draw(Graphics g, int x,int y) {
        if (drawLines) {
            l1.draw(g,x,y,lineColor,null);
            l2.draw(g,x,y,lineColor,null);
            l3.draw(g,x,y,lineColor,null);
        }
        if (firstRun) {
            setHandleLocations();
            firstRun = false;
        }
        g.setColor(lineColor);
        drawPoints(g,new Point(x,y),curvePoints);
    }

    public void draw(Graphics g, int x, int y,Color lineColor) {
        setLineColor(lineColor);
        draw(g,x,y);
    }
    
    public void draw(Graphics g, int x,int y,Color lineColor, Color fillColor) {
        setLineColor(lineColor);
        setFillColor(fillColor);
    }
    
//    public BezierCurve getConnected(Handle h,Color lineColor, int orientation) {
//        BezierCurve curve = new BezierCurve(view,h,lineColor,orientation);
//        return curve;
//    }
    
/*    public Point getEndPoint(Handle h1, Handle h2) {
        int x;
        int y;
        int x1 = h1.getLeft();
        int y1 = h1.getTop();
        int x2 = h2.getLeft();
        int y2 = h2.getTop();
        if (x1 < x2) {
            x = x2 - x1;
            if (y1 < y2) {
                y = (y2 - y1);
            } else {
                y = -(y1 - y2);
            }
        } else {
            // reversed
            x = -(x1 - x2);
            if (y1 < y2) {
                y = y2 - y1; 
            } else {
                y = -(y1 - y2);
            }
        }
        return new Point(x,y);
    }

*/    
    public Point getEndPoint(Point p1, Point p2) {
        int x;
        int y;
        int x1 = p1.x;
        int y1 = p1.y;
        int x2 = p2.x;
        int y2 = p2.y;
        if (x1 < x2) {
            x = x2 - x1;
            if (y1 < y2) {
                y = (y2 - y1);
            } else {
                y = -(y1 - y2);
            }
        } else {
            // reversed
            x = -(x1 - x2);
            if (y1 < y2) {
                y = y2 - y1; 
            } else {
                y = -(y1 - y2);
            }
        }
        return new Point(x,y);
    }

    @Override
    public List<Point> getLinePoints() { return curvePoints; }
    
/*
    
    public Point getH1TXY() {
        Point txy = l1.getTXY();
        //System.out.println("H1: " + txy);
        return new Point(txy.x - Handle.half,txy.y - Handle.half);
    }
    
    public Point getH2TXY() {
        Point txy = l1.getEndPointTXY();
        //System.out.println("H2: " + txy);
        return new Point(txy.x - Handle.half,txy.y - Handle.half);
    }
    
    public Point getH3TXY() {
        Point txy = l2.getEndPointTXY();
        //System.out.println("H3: " + txy);
        return new Point(txy.x - Handle.half,txy.y - Handle.half);
    }
  
*/    
    
    public int getPaintingWidth() {
        int min = 0;
        int max = 0;
        Point p;
        for(int i = 0; i < curvePoints.size();i++) {
            p = curvePoints.get(i);
            min = Math.min(p.x,min);
            max = Math.max(p.x,max);
        }
        return max - min;
    }

    public boolean hasFillPoint(Point p) {
        return hasPoint(p);
    }
    
    public boolean hasPoint(Point p) {
        Point txy = getTXY();
        Point current;
        for(int i = 0; i < curvePoints.size();i++) {
            current = curvePoints.get(i);
            int p1XMin = txy.x + current.x - Point.PICK_SIZE;
            int p1XMax = txy.x + current.x + Point.PICK_SIZE;
            int p1YMin = txy.y + current.y - Point.PICK_SIZE;
            int p1YMax = txy.y + current.y + Point.PICK_SIZE;
            if (p1XMin <= p.x && p.x <= p1XMax && p1YMin <= p.y && p.y <= p1YMax) {
                return true;
            }
        }
        return false;
    }
    
    public List<Point> interpolateBetween(Point p1, Point p2) {
        List<Point> points = new ArrayList<>();
        Line line = new Line();
        line.setTranslation(p1);
        int xOff = getXOffset(p1,p2);
        int yOff = getYOffset(p1,p2);
        line.setEndPoint(xOff,yOff);
        return line.getTranslatedPoints();
    }
    
/*    public void mouseDragged(MouseEvent e) {
        Handle source = (Handle)e.getSource();
        Point p = source.getDXY();
        if (source == start) {
            l1.addTranslation(p);
            l1.setEndPoint(getEndPoint(start,middle));
        } else if (source == middle) {
            // process middle handle
            l1.setEndPoint(getEndPoint(start,middle));
            l2.addTranslation(middle.getDXY());
            l2.setEndPoint(getEndPoint(middle,end));
        } else if (source == end) {
            // process end handle
            l2.setEndPoint(getEndPoint(middle,end));
        }
        compute();
    }

    public void mouseClicked(MouseEvent e) {
        Handle src = (Handle)e.getSource();
        MouseInterpreter mi = new MouseInterpreter(e);
        if (mi.isRightButton()) {
            BezierMenu menu = new BezierMenu(src,this);
            menu.show(Platform.getTopLevelContainer(src),src.getCX(),src.getCY());
        } 
    }
    
    public void mouseEntered(MouseEvent e) {}

    public void mouseExited(MouseEvent e) {}

    public void mousePressed(MouseEvent e) {}

    public void mouseReleased(MouseEvent e) {}

    public void mouseMoved(MouseEvent e) {
    }
  
*/
    
    public void paintElement(Graphics g) {
        draw(g);
    }
    
    public List<Point> reinterpolate(List<Point> source) {
        List<Point> points = new ArrayList<>();
        for(int i = 0;i < source.size() - 1;i++) {
            DrawObject.add(interpolateBetween(source.get(i),source.get(i+1)),points);
        }
        return points;
    }
    
    public void setDrawLines(boolean state) {
        drawLines = state;
    }
    
    public void setHandleLocations() {
//        Point h1 = getH1TXY();
//        Point h2 = getH2TXY();
//        Point h3 = getH3TXY();
//        start.setLocation(h1.x,h1.y);
        //System.out.println(start.getLocation());
//        middle.setLocation(h2.x,h2.y);
        //System.out.println(middle.getLocation());
//        end.setLocation(h3.x,h3.y);
        //System.out.println(end.getLocation());
    }

    public void setLineColor(Color c) {
        l1.setLineColor(c);
        l2.setLineColor(c);
        l3.setLineColor(c);
    }
    
    public void setOrientation(int orientation) {
        if (orientation == UP_RIGHT) {
            //l1.addTranslation(-100,0);
            l1.setEndPoint(100,-100);
            l2.setTranslation(l1.getEndPointTXY());
            l2.setEndPoint(100,100);
        } else if (orientation == UP_LEFT) {
            //l1.addTranslation(-100,0);
            l1.setEndPoint(-100,-100);
            l2.setTranslation(l1.getEndPointTXY());
            l2.setEndPoint(-100,100);
        } else if (orientation == DOWN_LEFT) {
            //l1.addTranslation(100,0);
            l1.setEndPoint(-100,100);
            l2.setTranslation(l1.getEndPointTXY());
            l2.setEndPoint(-100,-100);
        } else if (orientation == DOWN_RIGHT) {
            //l1.addTranslation(100,0);
            l1.setEndPoint(100,100);
            l2.setTranslation(l1.getEndPointTXY());
            l2.setEndPoint(100,-100);
        } else if (orientation == LEFT_UP) {
            //l1.addTranslation(0,100);
            l1.setEndPoint(-100,-100);
            l2.setTranslation(l1.getEndPointTXY());
            l2.setEndPoint(100,-100);
        } else if (orientation == LEFT_DOWN) {
            //l1.addTranslation(0,100);
            l1.setEndPoint(-100,100);
            l2.setTranslation(l1.getEndPointTXY());
            l2.setEndPoint(100,100);
        } else if (orientation == RIGHT_UP) {
            //l1.addTranslation(0,-100);
            l1.setEndPoint(100,-100);
            l2.setTranslation(l1.getEndPointTXY());
            l2.setEndPoint(-100,-100);
        } else if (orientation == RIGHT_DOWN) {
            //l1.addTranslation(0,-100);
            l1.setEndPoint(100,100);
            l2.setTranslation(l1.getEndPointTXY());
            l2.setEndPoint(-100,100);
        }
    }
    
    public String toString() {
        return name + ": " + l1 + "\n" + l2 + "\n" + l3;
    }
    

}
