package ca.tecreations.apps.filetool;

import ca.tecreations.*;
import ca.tecreations.net.Client;

import java.awt.event.*;

/**
 *
 * @author Tim
 */
public class ScreenRefresher implements ActionListener {
    public static final String SN = ScreenRefresher.class.getSimpleName();
    public static int MS_BETWEEN_CAPTURES = 3000;
    RemoteControl remote;
    Client client;
    boolean running = false;
    boolean paused = false;
    
    public Timer timer;
    public boolean restarted = false;
    
    public ScreenRefresher(RemoteControl rc, Client client) {
        this.remote = rc;
        this.client = client;
        timer = new Timer(this,MS_BETWEEN_CAPTURES);// This is inherently where an issue lies. 
        timer.start(); // The class (simple) name should indicate it does NOT start the thread.
        // The burden for starting the thread should be placed on the programmer, after all it is THEIR code.
        // So some would say, we still want to start it later. To which I say, that's fine, then you should 
        // still have to provide the code that starts it for you. Even if only for a sample of how to do it. ][:) DEMODEMON.IT
    }
    
    public void actionPerformed(ActionEvent e) {
        new ScreenRefresher_DoesOp_AutoStarts(remote,client);
    }
    
    public boolean isRunning() { return running; }

    public boolean isPaused() { return paused; }
    
    public void refreshNow() {
        timer.stop();
        new ScreenRefresher_DoesOp_AutoStarts(remote,client);
        timer = new Timer(this,MS_BETWEEN_CAPTURES);
    }
    
    public void setPaused(boolean flag) { paused = flag; }
    
    public void stopRunning() {
        timer.stop();
        running = false;
    } 
}
