package ca.tecreations.apps.filetool;

import ca.tecreations.Drag;
import ca.tecreations.File;
import ca.tecreations.ImageTool;
import ca.tecreations.Mouse;
import ca.tecreations.MouseWheel;
import ca.tecreations.Platform;
import ca.tecreations.Point;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.Timer;
import ca.tecreations.components.TFrame;
import ca.tecreations.graphics.GraphicsUtil;
import ca.tecreations.net.Client;
import ca.tecreations.net.NoTLSConnectionException;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class RemoteControl extends TFrame implements ActionListener, 
        MouseListener, MouseMotionListener, MouseWheelListener 
{
    public static ScreenRefresher screenRefresher;
    public static RemoteControl instance;
    Client client;
    JScrollPane scroller;
    EventsPanel eventsPanel;
    String screenshotPath;
    
    
    boolean mouseUp = true;
    boolean mouseMoving = false;
    Timer clickTimer = null;
    Timer moveTimer = null;
    
    Point mouseLocation = new Point(0,0); 
    
    boolean dragged = false;
    Mouse down = null;
    Mouse up = null;

    Point previousLoc;

    public static boolean debug = true;
    public static boolean verbose = false;
    public static boolean trace = false;
    
    public RemoteControl(Client client, TFrame parent) {
        super(new Properties(ProjectPath.INSTANCE.getPropertiesPath() + "RemoteControl.properties"),"RemoteControl");
        this.client = client;
        screenshotPath = client.getClientScreenshotPath();
        synchronized (new Object()) {
            client.processGET(client.getServerScreenshotPath(),screenshotPath);
        }
        eventsPanel  = new EventsPanel(this,ImageTool.getImage(new File(screenshotPath)));
        setLayout(new BorderLayout());
        scroller = new JScrollPane(eventsPanel,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        scroller.getVerticalScrollBar().setUnitIncrement(16);
        scroller.getHorizontalScrollBar().setUnitIncrement(16);
        add(scroller,BorderLayout.CENTER);
        eventsPanel.addMouseListener(this);
        eventsPanel.addMouseMotionListener(this);
        eventsPanel.addMouseWheelListener(this);
        if (getProperties().wasCreated()) {
            setLocationRelativeTo(parent);
        }
        screenRefresher = new ScreenRefresher(this,client);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == moveTimer) {
            client.sendMouseMove(mouseLocation);
            screenRefresher.refreshNow();
        }
    }
    
    @Override
    public void close() {
        screenRefresher.stopRunning();
        super.close();
    }
    
    public static void createAndShowGUI(final Client client, final TFrame parent) {
        SwingUtilities.invokeLater(() -> {
            instance = new RemoteControl(client, parent);
            instance.setVisible(true);
        });
    }
    
    public void doPainting(java.awt.Graphics g, int x, int y) {
        Color oldColor = g.getColor();
        g.setColor(Color.red);
        for(int j = y - 3; j <= y + 3;j++) { // vertical line
            g.drawLine(x,j,x,j);
        }
        for(int i = x-3;i <= x + 3;i++) { // horizontal line
            g.drawLine(i,y,i,y);
        }
        g.setColor(oldColor);
    }
    
    public boolean getDebug() { return debug; }
    
    public EventsPanel getEventsPanel() { return eventsPanel; }
    
    public Point getMouseLocation() { return mouseLocation; }
    
    public static void launch(final Client client, final TFrame parent) {
        createAndShowGUI(client, parent);
    }

    public static void main(String[] args) {
        Properties  properties = new Properties(ProjectPath.INSTANCE.getPropertiesPath() + SN + ".properties");
        TFrame frame = new TFrame(properties,SN);
        Client client = null;
        try {
            client = new Client(properties,true,null);
        } catch (NoTLSConnectionException ntlsce) {
            System.err.println("No TLS Connection.\nExiting.\n");
            System.exit(0);
        }
        launch(client,frame);
    }
    
    @Override
    public void mouseClicked(MouseEvent e) {
        client.sendMouseClick(new Mouse(e,false));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!mouseMoving) {
            moveTimer = new Timer(this,250);
            mouseMoving = true;
        }
        mouseLocation = new Point(e.getX(),e.getY());
        repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        mouseLocation = new Point(e.getX(),e.getY());
        repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        mouseLocation = new Point(e.getX(),e.getY());
        mouseMoving = false;
        repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!mouseMoving) {
            moveTimer = new Timer(this,250);
            mouseMoving = true;
        }
        mouseLocation = new Point(e.getX(),e.getY());
        repaint();
    }
    
    @Override
    public void mousePressed(MouseEvent e) {
        down = new Mouse(e,true);
        client.sendMouseMove(down.getComponentPoint());
        client.sendMouseDown(down);
        if (clickTimer == null) {
            clickTimer = new Timer(this,160);
            clickTimer.start();
        }
        repaint();
    }

    private int clickCount = 0;
    
    @Override
    public void mouseReleased(MouseEvent e) {
        up = new Mouse(e,false);
        up.setDownMask(down.getDownMask());
        client.sendMouseMove(up.getComponentPoint());
        client.sendMouseUp(up);
        mouseUp = true;
        mouseMoving = false;
        repaint();
    }

    
    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        boolean alt = e.isAltDown();
        boolean ctrl = e.isControlDown();
        boolean shift = e.isShiftDown();
        boolean set = false;
        JScrollBar h = scroller.getHorizontalScrollBar();
        JScrollBar v = scroller.getVerticalScrollBar();
        int hInc = h.getUnitIncrement();
        int vInc = v.getUnitIncrement();
        int hVal = h.getValue();
        int vVal = v.getValue();
        if (notches > 0) {
            if (alt) {
                if (ctrl) {
                    h.setValue(hVal + (hInc * 10));
                } else {
                    h.setValue(hVal + hInc);
                }
            } else {
                if (ctrl) {
                    v.setValue(vVal + (vInc * 10));
                } else {
                    v.setValue(vVal + vInc);
                }
            }
        } else {
            if (alt) {
                if (ctrl) {
                    h.setValue(hVal - (hInc * 10));
                } else {
                    h.setValue(hVal - hInc);
                }
            } else {
                if (ctrl) {
                    v.setValue(vVal - (vInc * 10));
                } else {
                    v.setValue(vVal - hInc);
                }
            }
        }
        // send wheel up/down
        client.sendMouseWheel(new MouseWheel(notches,alt,ctrl,shift));
        System.err.println("WheelDown: " + e.paramString());
        
    }

    public void paint(Graphics g) {
        if (trace) System.out.println("RemoteControl.paint()");        
        super.paint(g);
        int x = mouseLocation.x;
        int y = mouseLocation.y;
        doPainting(g,x,y);
    }
    
//    public void paintComponent(Graphics g) {
//        if (trace) System.out.println("RemoteControl.paintComponent()");        
//        super.paintComponents(g);
//        int x = mouseLocation.x;
//        int y = mouseLocation.y;
//        doPainting(g,x,y);
//    }
    
    public void setImage(BufferedImage img) {
        eventsPanel.setImage(img);
        repaint(); 
    }
    
}
