package ca.tecreations.apps.filetool;

import ca.tecreations.File;
import ca.tecreations.StringTool;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;
import ca.tecreations.net.Client;

import java.util.List;
/**
 *
 * @author Tim
 */
public class CopyOnHostDropIn extends Thread {
    public static final String SN = CopyOnHostDropIn.class.getSimpleName();
    FileTool app;
    TextFile log;
    Client client;
    List<String> names;
    String dstPath;
    boolean doCopy = true;
    
    public CopyOnHostDropIn(FileTool app, TextFile log, Client client, List<String> names, String dstPath) {
        this.app = app;
        this.log = log;
        this.client = client;
        this.names = names;
        this.dstPath = dstPath;
    }

    public CopyOnHostDropIn(FileTool app, TextFile log, Client client, List<String> names, String dstPath, boolean doCopy) {
        this.app = app;
        this.log = log;
        this.client = client;
        this.names = names;
        this.dstPath = dstPath;
        this.doCopy = doCopy;
    }

    public void run() {
        String name;
        for(int i = 0;i < names.size();i++) {
            name = names.get(i);
            if (TecData.isDir(name)) {
                String unwrappedName = StringTool.getUnwrapped(name);
                String dirName = unwrappedName.substring(0,unwrappedName.length() - 1);
                if (unwrappedName.endsWith("\\")) {
                    dirName = dirName.substring(dirName.lastIndexOf("\\") + 1);
                } else {
                    dirName = dirName.substring(dirName.lastIndexOf("/") + 1);
                }
                String newDstDir = StringTool.getUnwrapped(dstPath) + dirName + client.getFileSeparator();
                log.add(SN + ".copyDir: " + name + " , " + newDstDir);
                //client.copyDirectory(name, newDstDir);
            } else {
                log.add(SN + ".copyFileToDir(" + name + " , " + dstPath);
                //client.copyFileToDir(name,dstPath);
            }
        }
    }
    
}

