package ca.tecreations.apps.filetool;

import ca.tecreations.File;
import ca.tecreations.StringTool;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;
import ca.tecreations.net.Client;

import java.util.List;
/**
 *
 * @author Tim
 */
public class CopyOnHost extends Thread {
    FileTool app;
    Client client;
    TextFile log;
    String srcPath;
    List<String> names;
    String dstPath;
    String fileSep;
    
    public CopyOnHost(FileTool app,TextFile log,Client client,String srcPath, List<String> names, String dstPath) {
        this.app = app;
        this.client = client;
        this.log = log;
        this.srcPath = srcPath;
        this.names = names;
        this.dstPath = dstPath;
        fileSep = client.getFileSeparator();
    }
    
    public void run() {
        String name;
        
        for(int i = 0; i < names.size();i++) {
            name = names.get(i);
            String unwrapped = StringTool.getUnwrapped(name);
            if (srcPath.equals(dstPath)) {
                if (!TecData.isDir(name)) {
                    // copy file
                    String nextFile = client.getNextFileName(name);
                    log.add("Equal: File: " + name + " Next: " + nextFile);
                    //client.copyFileToFile(name,nextFile);
                } else {
                    String nextDir = client.getNextDirectoryName(name);
                    log.add("Equal: Dir: " + name + " Next: " + nextDir);
                    //client.copyDirectory(name,StringTool.getDoubleQuoted(nextDir));
                }
            } else {
                if (TecData.isDir(name)) {
                    String rootSubPath = unwrapped.substring(0,unwrapped.length() - 1);
                    String deepest = unwrapped.substring(unwrapped.lastIndexOf(fileSep));
                    log.add("Dir: dst: " + dstPath + deepest + fileSep);
                    //client.copyDirectory(name,dstPath + deepest + fileSep);
                } else {
                    log.add("File: dst: "+ dstPath);
                    //client.copyFileToDir(name,dstPath);
                }
            }
            app.refreshLast();
        }
    }
    
}
