package ca.tecreations.apps.editors;

import ca.tecreations.*;
import static ca.tecreations.apps.editors.CodeEdit.SN;
import static ca.tecreations.apps.editors.CodeEdit.launch;
import ca.tecreations.components.*;
import ca.tecreations.interfaces.HasCursor;
import ca.tecreations.text.CursorTimer;
import ca.tecreations.text.LineOfTextTokenPainter;
import ca.tecreations.text.TextPoints;

import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;

/**
 *
 * @author Tim
 */
public class TextPanel extends SizedPanel
implements HasCursor {
    public static final String SN = TextPanel.class.getSimpleName();
    TextEditor textEditor; // the parent component
    List<String> lines = new ArrayList<>();
    public static final int BETWEEN = 2;
    
    int maxWidth = 0;
    
    TColor lineBg = Colors.currentLineBG;
    
    List<LineOfTextTokenPainter> painters = new ArrayList<>();
    
    int lineIndex = 0;
    int colNum = 0;
    
    Action doEnter;
    Action doSpace;

    private boolean isBackspace = false;
    private boolean isDelete = false;
    
    int dubWidth;
    
    
    CursorTimer cursorTimer;
    boolean cursorShown = false;
    TColor cursorColor = TColor.BLACK;
    boolean isInsert = true;
    int cursorX;
    int cursorY;
    
    int highlighted = 0;
    
    int selStartLine = 0;
    int selStartCol = 0;
       
    int lastLine = 0;
    int lastCol = 0;
    

    public static boolean debug = true;
    
    public static TextPoints points;
    
    public TextPanel(TextEditor textEditor, int width, int height) {
        super(width,height);
        this.textEditor = textEditor;
        points = textEditor.getPoints();
        cursorTimer = new CursorTimer(this,500);
        // no need to set layout because only receiving events and painting
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == cursorTimer) {
            if (!cursorShown) cursorShow();
            else cursorHide();
        }
    }
    
    public void addLine(LineOfTextTokenPainter painter) {
        painter.setBackground(TColor.SWING_DEFAULT_BG);
        painter.setForeground(getForeground());
        if (debug) painter.setDemarcationColor(TColor.BRIGHT_BLUE);
        painters.add(painter);
        conformPanelSize();
        repaint();
    }
    
    public void conformPanelSize() {
        maxWidth = 0;
        if (points.isMonospaced()) {
            for(int i = 0; i < painters.size();i++) {
                maxWidth = Math.max(maxWidth,painters.get(i).getPaintingWidth());
            }   
        } else {
            int tokensWidth = 0;
            for(int i = 0; i < painters.size();i++) {
                LineOfTextTokenPainter painter = painters.get(i);
                tokensWidth = painter.getTextWidth();
                maxWidth = Math.max(maxWidth,tokensWidth);
            }
        }
        //System.out.println("addLine: lnw: " + lnw + " tokens: " + tokensWidth + " max: " + maxWidth);
        int width = Math.max(maxWidth,textEditor.getHSB().getSize().width);
        width = Math.max(width,dubWidth * 90);
        int height = Math.max(painters.size() * points.getFontSize(),textEditor.getVSB().getSize().height);
        height = Math.max(height, points.getSize() * 28);
        setSize(width,height);
        LineNumbers ln = textEditor.getLineNumbers();
        ln.setSize(ln.getSize().width,height);
        ln.setLocation(0,getLocation().y);
    }
    
    @Override
    public void cursorHide() {
        cursorShown = false;
    }
    
    @Override
    public void cursorShow() {
        cursorShown = true;
    }
    
    public int getLineCount() { return painters.size(); }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
    
    public List<LineOfTextTokenPainter> getPainters() { return painters; }
    
    public int getYOffset() {
        int lineHeight = points.getFontSize();
        int absY = Math.abs(getLocation().y);
        int offset = absY - (absY - lineHeight);
        if (offset == lineHeight) return 0;
        else return offset;
    }
    
    public static void main(String[] args) {
        //new File(ProjectPath.getDownloadsPath() + TecData.TEC_VERSION + "_jars.jar").delete(true);
        //new File(ProjectPath.getTecreationsPath() + "images" + File.separator + "tec_brand.png").delete(true);
        Properties props = new Properties(ProjectPath.getPropertiesPath() + SN + ".properties");
        launch(props);
    }

    @Override
    public void paint(Graphics g) {
        if (trace) System.out.println(SN + ".paint");
        int fontSize = points.getFontSize();
        int absX = Math.abs(getLocation().x);
        int absY = Math.abs(getLocation().y);
        int minX = absX;
        int maxX = minX + textEditor.getHSB().getSize().width;
        int minY = absY - fontSize;
        int maxY = absY + textEditor.vsb.getSize().height + fontSize;

        int y = getYOffset();
        // paint the text area background
        
        g.setColor(TColor.SWING_DEFAULT_BG);
        g.fillRect(minX, minY, maxX - minX,maxY - minY);
        
        // draw NetBeans-style 80 column line, only if monospaced
        int dubWidth = points.getWidth("W");
        int eighty = 80 * (BETWEEN + dubWidth);
        LineOfTextTokenPainter painter = null;
        for (int i = 0; i < painters.size(); i++) {
            if (y >= minY && y <= maxY) {
                painter = painters.get(i);
                if (i == lineIndex) {
                    g.setColor(lineBg);
                    g.fillRect(0, y, getSize().width,fontSize);
                    painter.setBackground(lineBg);
                    painter.paintAt(g,BETWEEN,y);
                } else {
                    g.setColor(getBackground());
                    painter.paintAt(g,BETWEEN,y);
                }
                if (points.isMonospaced()) {
                    g.setColor(new TColor(210,173,204));
                    g.drawLine(eighty,y,eighty,y+points.getFontSize());
                }
                if (painter.getDemarcationColor() != null) {
                    g.setColor(painter.getDemarcationColor());
                    int demarcX = painter.getPaintingWidth() - BETWEEN - 1; // -1 for pen
                    g.drawLine(demarcX,y,demarcX,y+points.getFontSize());
                }
            }
            y += fontSize;
        }
    }

    
    public void setLines(List<LineOfTextTokenPainter> painters) {
        this.painters = painters;
        conformPanelSize();
    }
    
    public void setText(List<String> lines) {
        this.lines = lines;
        repaint();
    }
    
}
