package ca.tecreations.apps.editors;

import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.TColor;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import static ca.tecreations.apps.editors.LineNumbers.editor;
import static ca.tecreations.apps.editors.LineNumbers.numsPainter;
import static ca.tecreations.apps.editors.TextPanel.BETWEEN;
import static ca.tecreations.apps.editors.TextPanel.SN;
import static ca.tecreations.apps.editors.TextPanel.points;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.text.LineOfTextTokenPainter;
import ca.tecreations.text.TextPoints;
import ca.tecreations.text.TextTokenPainter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JPanel;
/**
 *
 * @author Tim
 */
public class LineNumbers extends SizedPanel {

    public static final String SN = LineNumbers.class.getSimpleName();
    static Editor editor;
    TextPoints points;
    static TextTokenPainter numsPainter;

    public LineNumbers(Editor editor) {
        super(1, 1);
        this.editor = editor;
        points = editor.getPoints();
        numsPainter = new TextTokenPainter(points, new TextToken(), TColor.black);
        numsPainter.setBackground(TColor.DEFAULT_SWING_BG);
        numsPainter.setToken(new TextToken("99999"));
        setSize(numsPainter.getTextWidth(), getSize().height);
    }

    public int getLength(int i) {
        if (i < 10) return 1;
        if (i < 100) return 2;
        if (i < 1000) return 3;
        if (i < 10000) return 4;
        if (i < 100000) return 5;
        if (i < 1000000) return 6;
        if (i < 10000000) return 7;
        if (i < 100000000) return 8;
        if (i < 1000000000) return 9;
        return 10;
    }

    public int getLineNumberLength(int num) {
        if (num < 10) return 1;
        if (num < 100) return 2;
        if (num < 1000) return 3;
        if (num < 10000) return 4;
        if (num < 100000) return 5;
        if (num < 1000000) return 6;
        if (num < 10000000) return 7;
        if (num < 100000000) return 8;
        if (num < 1000000000) return 9;
        return 10;
    }

    public TextToken getPaddedToken(int i) {
        String text = getPadding(getLineNumberLength(i + 1) - getLength(i)) + (i + 1) + ": ";
        return new TextToken(text);
    }

    public String getPadding(int count) {
        String s = "";
        for (int i = 0; i < count; i++) {
            s += ' ';
        }
        return s;
    }

    public int getYOffset() {
        int lineHeight = numsPainter.getPoints().getFontSize();
        int absY = Math.abs(getLocation().y);
        int offset = absY - (absY - lineHeight);
        if (offset == lineHeight) {
            return 0;
        } else {
            return offset;
        }
    }

    public static void main(String[] args) {
        Properties props = new Properties(ProjectPath.getPropertiesPath() + SN + ".properties");
        CodeEdit.launch(props);
    }

    @Override
    public void paint(Graphics g) {
        if (getSize().height != editor.getPanel().getSize().height) {
            setSize(getSize().width,editor.getPanel().getSize().height);
        }
        if (getLocation().y != editor.getPanel().getLocation().y) {
            setLocation(0,editor.getPanel().getLocation().y);
        }
        if (trace) System.out.println(SN + ".paint");
        int fontSize = points.getFontSize();
  //      int absX = Math.abs(getLocation().x);
        int absY = Math.abs(getLocation().y);
  //      int minX = absX;
  //      int maxX = minX + textEditor.getHSB().getSize().width;
        int minY = absY - fontSize;
        int maxY = absY + editor.getVSB().getSize().height + fontSize;

        int y = getYOffset();
        if (y == 0) y = 1;
        // paint the text area background
        
        g.setColor(TColor.SWING_DEFAULT_BG);
        g.fillRect(0, minY, getSize().width,maxY - minY);
        
        int width = getSize().width;
        for (int i = 0; i < editor.getLineCount(); i++) {
           if (y >= minY && y <= maxY) {
                int lineNum = i + 1;
                numsPainter.setText("" + lineNum);
                int textWidth = numsPainter.getTextWidth();
                int lineX = ((width - textWidth) / 2);
                numsPainter.paintAt(g, lineX, y);
           }
           y += fontSize;
        }
    }

}
