package ca.tecreations.apps.editors;

import ca.tecreations.*;
import ca.tecreations.interfaces.Paintable;
import ca.tecreations.components.*;
import ca.tecreations.graphics.*;
import ca.tecreations.text.*;

import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;

import javax.swing.*;

/**
 *
 * @author Tim
 */
public class CodeEdit extends SizedPanel implements ActionListener,
        MouseListener, 
        MouseMotionListener, MouseWheelListener, Paintable, Runnable,
        Editor {
    static TextPoints points = ca.tecreations.TecData.CODE_POINTS;
    static {
        points.setMonospaced(true);
    }
    public static final String SN = CodeEdit.class.getSimpleName();
    public static CodeEdit instance;

    public TextEditor textEditor;
    JScrollBar hsb;
    JScrollBar vsb;
    
    JPanel left = null;
    JPanel right = null;
    LineNumbers lineNumbers;
    SizedPanel underNums;
    LineLocator lineLocator;
    SizedPanel underLocator;
    Status status;
    
    boolean firstRun = true;

    public JScrollBar getHSB() { return textEditor.getHSB(); }
    
    public JScrollBar getVSB() { return textEditor.getVSB(); }
    
    public int getLineCount() { return textEditor.getLineCount(); }
    
    public LineNumbers getLineNumbers() { return lineNumbers; }
    
    public JPanel getPanel() { return textEditor.getPanel(); }
    
    public TextPoints getPoints() {
        return points;
    }
    
    public JScrollPane getScroller() { return textEditor.getScroller(); }
    
    public CodeEdit(int width, int height) {
        super(width,height,true);
        
        setLayout(new BorderLayout(0,0));

        lineNumbers = new LineNumbers(this);
        underNums = new SizedPanel(lineNumbers.getSize().width,15);
        
        lineLocator = new LineLocator(this);
        underLocator = new SizedPanel(lineLocator.getMaxWidth(),15);

        left = new SizedPanel(1,1);
        left.add(lineNumbers);
        left.add(underNums);
        add(left,BorderLayout.WEST);
        
        right = new SizedPanel(1,1);
        right.add(lineLocator,BorderLayout.CENTER);
        right.add(underLocator, BorderLayout.SOUTH);
        add(right, BorderLayout.EAST);

        textEditor = new TextEditor(this,width,height);
        add(textEditor,BorderLayout.CENTER);
        status = new Status(true,false,false,true,false);
        
//        lineLocator.setSize(lineLocator.getSize().width,lineNumbers.lnPoints.getSize());
        
        add(status,BorderLayout.SOUTH);
        validate();
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == status) {
            System.out.println("Command: " + status.getCommand());
        }
    }
    
    public int getPaintingWidth() {
        return getSize().width;
    }
    
//    public java.awt.Dimension getPreferredSize() {
//        return new Dimension(getSize().width,getSize().height);
//    }
    
    public static void launch(final Properties props) {
        
        SwingUtilities.invokeLater(() -> {
            
            TFrame app = new TFrame(props,SN);
            TPanel holder = new TPanel();
            app.setLayout(new BorderLayout(0,0));
            app.add(holder, BorderLayout.CENTER);
            app.setVisible(true);
            Dimension size = holder.getSize();
            instance = new CodeEdit(size.width,size.height);
            holder.add(instance,BorderLayout.CENTER);
            app.validate();
            app.setLocationRelativeTo(null);
            app.setExitOnClose(true);
            
            
            
            
            int yDiff = app.getSize().height - instance.getSize().height;
            int side = (int)(((double)app.getSize().width - (double)instance.getSize().width) / 2.0);
            int titleBar = yDiff - (2 * side);
            //System.out.println("yDiff: " + yDiff);
            //System.out.println("Side : " + side);
            //System.out.println("Title: " + titleBar);

            instance.open(ProjectPath.getProjectPath() + "ca\\tecreations\\apps\\editors\\CodeEdit.java");

            
        });
    }

    public static void main(String[] args) {
        //new File(ProjectPath.getDownloadsPath() + TecData.TEC_VERSION + "_jars.jar").delete(true);
        //new File(ProjectPath.getTecreationsPath() + "images" + File.separator + "tec_brand.png").delete(true);
        Properties props = new Properties(ProjectPath.getPropertiesPath() + SN + ".properties");
        launch(props);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
//        if (e.getSource() == bottomRight) {
//            bottomRight.setBackground(Color.blue);
//            bottomRight.repaint();
            System.out.println("entered");
//        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
//        if (e.getSource() == panel) {
//            panel.requestFocus();
//        } else 
        if (e.getSource() == status.getCommand()) {
            status.getCommand().requestFocus();
        }
    }

    public void mouseReleased(MouseEvent e) {
//        computeScrollerValues();
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        
    }
    
    public void open(String path) {
        textEditor.open(path);
    }
    
    public void paint(Graphics g) {
        if (trace) System.out.println(SN + ".paint");
        if (hsb == null) {
            hsb = textEditor.getScroller().getHorizontalScrollBar();
            vsb = textEditor.getScroller().getVerticalScrollBar();
        }
        if (hsb.getSize().height != 0 && firstRun) {
            tec_redoLayout();
            firstRun = false;
        }
        super.paint(g);
        paintElement(g);
        
    }
    
    public void paintElement(Graphics g) {
        if (trace) System.out.println(SN + ".paintElement");
        textEditor.repaint();
        lineNumbers.repaint();
        underNums.repaint();
        lineLocator.repaint();
        underLocator.repaint();
        status.repaint();
    }

    public void run() {
        
    }
    
    public void tec_redoLayout() {
        int lineNumsWidth = 43;//lineNumbers.getMaxWidth();
        int scrollerHeight = textEditor.getScroller().getSize().height;
        left.setSize(lineNumsWidth,scrollerHeight);
        lineNumbers.setSize(lineNumsWidth,scrollerHeight - hsb.getSize().height);
        underNums.setSize(lineNumsWidth,hsb.getSize().height);
        underNums.setLocation(0,lineNumbers.getSize().height);
        JScrollPane scroller = textEditor.getScroller();
        right.setSize(lineLocator.getSize().width,scrollerHeight);
        lineLocator.setSize(lineLocator.getSize().width,scrollerHeight - hsb.getSize().height);
        underLocator.setSize(lineLocator.getSize().width,hsb.getSize().height);
        underLocator.setLocation(0,lineLocator.getSize().height);
        int sWidth = scroller.getSize().width - lineNumbers.getSize().width;
        sWidth -= lineLocator.getSize().width;
        scroller.setSize(sWidth,scroller.getSize().height);
        repaint();
    }
}
