package ca.tecreations.apps._gui.renderer;

import ca.tecreations.FileEntry;
import ca.tecreations.StringTool;
import ca.tecreations.TecData;
import ca.tecreations.icons.Associations;
import ca.tecreations.TColor;

import java.awt.Component;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;

/**
 *
 * @author tim
 */
public class FileTypeRenderer extends DefaultTableCellRenderer {

    public FileTypeRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected,
            boolean hasFocus, int row, int column) {
        FileEntry entry = (FileEntry) value;
        if (entry != null) {
            String absPath = StringTool.getUnwrapped(entry.getAbsolutePath());
            setText(entry.getDisplayName());
            if (TecData.isDir(absPath)) {
                setIcon(Associations.FOLDER_ICON);
            } else {
                if (entry.isJava()) {
                    if (entry.hasMatchingClass() && entry.hasMain()) {
                        setIcon(Associations.RUN_JAVA);
                    } else {
                        setIcon(Associations.JAVA_POJO);
                    }
                } else {
                    setIcon(Associations.FILE_ICON);
                }
            }
            if (entry.isSelected()) {
                setOpaque(true);
                setBackground(TColor.TEC_SELECTED);
            } else {
                setOpaque(false);
                setBackground(table.getBackground());
            }
            if (entry.isWin() && entry.getDOSFileAttributes().contains("H")) {
                setForeground(TColor.red);
            } else if (entry.canRead() | absPath.equals("No data yet.")) {
                setForeground(TColor.black);
            } else {
                setForeground(TColor.magenta);
            }
        }
        return this;
    }

    
    public static void main(String[] args) {
        ca.tecreations.apps.filetool.FileTool.launch();
    }
}
