package ca.tecreations.apps._gui.renderer;

import ca.tecreations.TColor;
import ca.tecreations.FileEntry;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;

/**
 *
 * @author tim
 */
public class FilePermissonsRenderer extends JLabel implements TableCellRenderer {

    public FilePermissonsRenderer() {
        setHorizontalAlignment(SwingConstants.CENTER);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected,
            boolean hasFocus, int row, int column) {
        setForeground(TColor.TEC_PURPLE);
        FileEntry entry = (FileEntry) value;
        if (entry != null) {
            if (entry.isSelected()) {
                setOpaque(true);
                setBackground(TColor.TEC_SELECTED);
            } else {
                setOpaque(false);
                setBackground(table.getBackground());
            }
        }
        setText(entry.getPOSIXFilePermissions().toUpperCase());
        return this;
    }

}
 