package ca.tecreations;

import ca.tecreations.graphics.GraphicsUtil;

import java.awt.*;
import java.awt.image.*;

import javax.swing.*;



/**
 *
 * @author Tim
 */
public class WindowPartSizes extends JFrame {
    public static final String SN = WindowPartSizes.class.getSimpleName();
    public static WindowPartSizes INSTANCE = new WindowPartSizes();
    boolean debug = true;
    BufferedImage desktopImage = Platform.captureDesktop();
    Rectangle desktop = Platform.getDesktopSize();
    JPanel holder = new JPanel();
    Rectangle desktopSize = Platform.getDesktopSize();
    int taskbar = 0;
    int frameWidth;
    int frameHeight;
    int holderWidth;
    int holderHeight;
    public static int top = 0;
    public static int left = 0;
    public static int right = 0;
    public static int bottom = 0;
    public static int titleBar = 0;
    boolean taskBarAtTop;
    boolean taskBarAtBottom;
    boolean taskBarAtLeft;
    boolean taskBarAtRight;
    
    public WindowPartSizes() {
        super(); // automatically called if not specified
        //setSize(desktop.width,desktop.height);
        setExtendedState(JFrame.MAXIMIZED_BOTH);
        setLayout(new BorderLayout());
        add(holder,BorderLayout.CENTER);
        validate();
        setVisible(true);
        Platform.sleep(125);
        taskbar = 0;
        frameWidth = getSize().width;
        frameHeight = getSize().height;
        holderWidth = holder.getSize().width;
        holderHeight = holder.getSize().height;
        left = right = ((frameWidth - holderWidth) / 2);
        if (left == right && frameWidth != holderWidth) {
            top = bottom = left;
        }
        if (desktopSize.height != frameHeight) {
            taskbar = (desktopSize.height + top + bottom) - frameHeight;
        } else {
            taskbar = (desktopSize.width + left + right) - frameWidth;
        }
        titleBar = getSize().height - top - bottom - holder.getSize().height;
        taskBarAtTop = getSize().height < desktopSize.height && getLocation().y > 0;
        taskBarAtBottom = getSize().height < desktopSize.height && getLocation().y == 0;
        taskBarAtLeft = getSize().width < desktopSize.width && getLocation().x > 0;
        taskBarAtRight = getSize().width < desktopSize.width && getLocation().x == 0;
        setVisible(false);
        if (debug && TecData.GLOBAL_DEBUG) {
            System.out.println(SN + "(): Desktop Size: " + desktopSize);
            System.out.println(SN + "(): Frame : Location: " + getLocation());
            System.out.println(SN + "(): Frame : Width: " + frameWidth + " Height: " + frameHeight);
            System.out.println(SN + "(): Holder: Width: " + holderWidth + " Height: " + holder.getSize().height);
            System.out.println(SN + "(): Top: " + top);
            System.out.println(SN + "(): Left: " + left);
            System.out.println(SN + "(): Right: " + right);
            System.out.println(SN + "(): Bottom: " + bottom);
            System.out.println(SN + "(): Title Bar: " + titleBar);
            System.out.println(SN + "(): Taskbar: Height: " + taskbar + " Location: " + 
                (taskBarAtBottom ? "BOTTOM" : 
                  (taskBarAtTop ? "TOP" :
                    (taskBarAtRight ? "RIGHT" : "LEFT")))  
            );
            System.out.flush();
            System.out.println(".");
            System.err.println();
            System.err.println(WindowPartSizes.class.getPackageName() + "." + SN);
            System.err.println("Win10 & Win11 use a desktop sized panel when maximized and frame parts are calculated to be outside that area.");
            System.err.println("Linux Mint Cinnamon uses a desktop sized frame when maximized from which the taskbar height is computed.");
            System.err.flush();
        }
    }

    /*
      You should probably not put a main() in a static class that runs for initialization purposes. [read: search{ca.tecreations.FindInProjects}: Needle: 'public static void main(']
      I myself, like to delineate stuff like that in code, but standards vary and change.
      Do the best you can, for the Lord, Jesus Christ! It's His, After All!
    */
    
    
    public void paint(Graphics g) {
        g.drawImage(desktopImage,0,0,this);
        //GraphicsUtil.drawX(holder,Color.red);
        //GraphicsUtil.drawOutline(holder, Color.red);
    }
    
    public boolean taskBarAtBottom() { return taskBarAtBottom; }

    public boolean taskBarAtLeft() { return taskBarAtLeft; }

    public boolean taskBarAtRight() { return taskBarAtRight; }

    public boolean taskBarAtTop() { return taskBarAtTop; }

}
