package ca.tecreations;

import ca.tecreations.time.Time;
import ca.tecreations.lang.java.GetClassPathFor;
//import ca.tecreations.net.TecStreamPrinterClient;
//import ca.tecreations.net.TLS_TSPS;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
public class SystemTool { 
    public static final SystemTool INSTANCE = new SystemTool();
    public static final String SN = SystemTool.class.getSimpleName();
    public static String TARGET_JAVA_VERSION = "19";
    
    private final Object lock = new Object();
    private boolean debug = false;
    public static boolean verbose = false;
    static final Runtime runtime = Runtime.getRuntime();
    Process process;

    int exitValue;

    List<SystemToken> tokens = new ArrayList<>();
 
//    public TLS_TSPS tsps = null;
    
    boolean debugSamePackageNotCompiling = false;
    
    public SystemTool() {
    }
   
    public List<SystemToken> buildJava(String classPath,boolean debug) {
        List<SystemToken> result = new ArrayList<>();
        String unwrapped = StringTool.getUnwrapped(classPath);
        if (unwrapped.charAt(0) == '/') {
            if (!unwrapped.endsWith("/")) unwrapped += "/";
        } else {
            if (!unwrapped.endsWith("\\")) unwrapped += "\\";
        }
        classPath = unwrapped;
        String cpArg = new GetClassPathFor(classPath).getResult();
        if (new File(classPath).hasJava()) {
            String command = "javac -cp " + cpArg + " " + classPath + "*.java";
            List<SystemToken> tokens = runForOutput(command,debug);
            for(int i = 0; i < tokens.size();i++) {
                result.add(tokens.get(i));
            }
        }
        List<File> dirs = new File(classPath).getListDirs();
        for(int i = 0; i < dirs.size();i++) {
            List<SystemToken> recursed = buildJava(classPath, cpArg,dirs.get(i),debug);
            for(int j = 0; j < recursed.size();j++) {
                result.add(recursed.get(j));
            }
        }
        return result;
    }

    public List<SystemToken> buildJava(String classPath,String cpArg, File dir,boolean debug) {
        List<SystemToken> result = new ArrayList<>();
        File[] entries = new File(dir).tecListFiles();
        if (new File(dir).hasJava()) {
            String command = "javac -cp " + cpArg + " " + classPath + File.getSubPath(classPath,dir.getUnwrapped()) + "*.java";
            System.err.println(SN + ".buildJava(4): Command: " + command);
            List<SystemToken> tokens = runForOutput(command,debug);
            for(int i = 0; i < tokens.size();i++) {
                result.add(tokens.get(i));
            }
        }
        if (entries != null) {
            for(int i = 0;i < entries.length;i++) {
                if (entries[i].isDirectory()) {
                    List<SystemToken> recursed = buildJava(classPath,cpArg,entries[i],debug);
                    for(int j = 0; j < recursed.size();j++) {
                        result.add(recursed.get(j));
                    }
                }
            }
        }
        return result;
    }
    
    public List<SystemToken> buildPackage(String classPath, String pkg) {
        List<SystemToken> result = new ArrayList<>();
        classPath = StringTool.getUnwrapped(classPath);
        pkg = StringTool.getUnwrapped(pkg);
        if (pkg.length() > 0 && !pkg.endsWith(".")) pkg += ".";
        String subPath = pkg;
        subPath = StringTool.replaceAll(subPath,".",File.separator);
        Pair pair = new Pair(new File(classPath + subPath));
        List<File> dirs = pair.getDirs();
        List<File> files = pair.getFiles();
        
        for(int i = 0;i < files.size();i++) {
            compile(files.get(i),debug);
            for(int j = 0; j < tokens.size();j++) {
                result.add(tokens.get(j));
            }
        }
        for(int i = 0; i < dirs.size();i++) {
            List<SystemToken> tokens = buildPackage(classPath,pkg + dirs.get(i).getName());
            for(int j = 0; j < tokens.size();j++) {
                result.add(tokens.get(j));
            }
        }
        return result;
    }
       
    public List<SystemToken> buildSubPath(String classPath, String subPath) {
        List<SystemToken> result = new ArrayList<>();
        classPath = StringTool.getUnwrapped(classPath);
        subPath = StringTool.getUnwrapped(subPath);
        List<File> entries = new File(classPath + subPath).getListFiles();
        List<File> dirs = new ArrayList<>();
        List<File> files = new ArrayList<>();
        File entry;
        for(int i = 0;i < entries.size();i++) {
            entry = entries.get(i);
            if (entry.isFile() && entry.getExtension().equals("java")) {
                files.add(entry);
            } else if (entry.isDirectory()) {
                dirs.add(entry);
            }
        }
        dirs = Sort.sortListOfFile(dirs);
        files = Sort.sortListOfFile(files);
        
        for(int i = 0;i < files.size();i++) {
            compile(files.get(i),true);
            for(int j = 0; j < tokens.size();j++) {
                result.add(tokens.get(j));
            }
        }
        for(int i = 0; i < dirs.size();i++) {
            List<SystemToken> tokens = buildPackage(classPath,subPath + dirs.get(i).getName() + File.separator);
            for(int j = 0; j < tokens.size();j++) {
                result.add(tokens.get(j));
            }
        }
        return result;
    }
    
    public void clean(File root, boolean debug) {
        clean(root.getAbsolutePath(),debug);
    }
    
    public void clean(String root, boolean debug) {
        File[] entries = new File(root).tecListFiles();
        if (debug) System.out.println("Cleaning: " + root);
        if (entries != null) {
            for(int i = 0;i < entries.length;i++) {
                if (entries[i].isDirectory()) {
                    clean(entries[i].getAbsolutePath(),debug);
                } else {
                    if (entries[i].getExtension().equals("class")) {
                        entries[i].delete();
                    }
                }
            }
        }
    }
    
    public List<SystemToken> compile(File file, boolean debug) {
        int exitValue = -999;
        tokens = new ArrayList<>();
        String classPath = file.getClassPath();
        List<String> parts = getCompileCommand(classPath, file.getUnwrapped());
        String compileCommand = "";
        if (debug) {
            for(int i = 0; i < parts.size() - 1;i++) { 
                compileCommand += parts.get(i) + " ";
            }
            if (parts.size() > 0) compileCommand += parts.get(parts.size() - 1);
            System.err.println(SN + ".compile: cmd: " + compileCommand);
        } 
        if (debugSamePackageNotCompiling) {
            System.out.println("Compile parts: " + parts);
        }
        ProcessBuilder builder = new ProcessBuilder(parts);
        try { 
            process = builder.start();
        } catch (IOException ioe) {
            System.err.println("Unable to operate process: " + TypeToType.toSpacedString(parts));
        }
        if (debug) System.out.println("Process: " + process);
        readFromProcess(process);
        String appEventTime = new Time().getAppEventTime();
        try {
            process.waitFor();
        } catch (InterruptedException ie) {
            ExceptionHandler.handle(SN + ".compile", "process interrupted",ie,debug);
        }
        exitValue = process.exitValue();
        String debugStr = "SystemTool.compile: " + exitValue + " : " + new Time().getAppEventTime() + " : " + file.getFQCN();
        debugStr += " : " + TypeToType.toSpacedString(parts);
//            if (tsps != null) {
                    //tsps.send(debugStr);
//                  if (debug) { 
//                  System.out.println(SN + ".compile: " + debugStr);
//            }  
        tokens.add(new SystemToken(debugStr,TecData.SYS_OUT));
        return tokens;
    }  

    public void compileDir(String classPath, File dir) {
        List<String> parts = getCompileCommand(classPath);
        String compileCommand = "";
        for(int i = 0; i < parts.size() - 1;i++) {
            compileCommand += parts.get(i) + " ";
        }
        if (parts.size() > 0) compileCommand += parts.get(parts.size() - 1);
        String cpUnwrapped = StringTool.getUnwrapped(classPath);
        if (!cpUnwrapped.endsWith(File.separator)) cpUnwrapped += File.separator;
        String dirUnwrapped = dir.getUnwrapped();
        String subPath = dirUnwrapped.substring(cpUnwrapped.length());
        compileCommand += " " + classPath + subPath + "*.java";
        if (debug) {
            System.err.println(SN + ".compileDir: cmd: " + compileCommand);
            if (verbose) System.out.println(SN + ".compileDir: Compile parts: " + parts);
        }
        runAndWait(compileCommand,true);
    }
    
    public static void edit(String path) {
        if (Platform.isWin()) {
            spawn("C:\\Windows\\notepad.exe " + path,true);
        }
    }
    
    public static void main(String[] args) {
        File f = new File("/mnt/data/projects/BCTLSNetwork/ca/tecreations/SystemTool.java");
        List<SystemToken> tokens = INSTANCE.compile(f,true);
        for(int i = 0; i < tokens.size();i++) {
            tokens.get(i).printWithType();
        }
    }
    
    public List<String> getArgs(String args) {
        List<String> argsList = new ArrayList<>(); 
        String remainder = args;
        while (remainder.length() > 0) {
            String arg = getNextArg(remainder);
            argsList.add(arg);
            if (arg.length() + 1 < remainder.length()) {
                remainder = remainder.substring(arg.length() + 1);
            } else remainder = "";
        }
        return argsList;
    }
    
    public String getCommand(List<String> parts) {
        String command = "";
        for (int i = 0; i < parts.size() - 1; i++) {
            command += parts.get(i) + " ";
        }
        if (parts.size() > 0) {
            command += parts.get(parts.size() - 1);
        }
        return command;
    }

    public String getCommand(String[] parts) {
        String command = "";
        for (int i = 0; i < parts.length; i++) {
            command += parts[i] + " ";
        }
        if (parts.length > 0) {
            command += parts[parts.length - 1];
        }
        return command;
    }

    // https://docs.oracle.com/en/java/javase/17/docs/specs/man/javac.html#:~:text=Description,Java%20source%20files%20and%20classes.
    public List<String> getCompileCommand(String classPath, String srcPath) {
        classPath = StringTool.getUnwrapped(classPath);
        if (!classPath.endsWith(File.separator) && !classPath.equals(".") && !classPath.equals("..")) {
            classPath += File.separator;
        }
        List<String> parts = new ArrayList<>();
        String pathToJavac = "/usr/bin/javac";
        if (Platform.isWin()) {
            pathToJavac = "\"" + System.getProperty("java.home") + "\\bin\\javac.exe\""; //C:\\Program Files\\Java\\jdk-19\\bin\\javac.exe\"";
        } else if (Platform.isMac()) {
        } else {
            pathToJavac = "/usr/lib/jvm/jdk-19/bin/javac";
        }
        parts.add(pathToJavac); 
        parts.add("-cp"); 
        parts.add(new GetClassPathFor(StringTool.getDoubleQuoted(classPath)).getResult());
        //parts.add("--release");
        //parts.add(TARGET_JAVA_VERSION);;
        parts.add("--source");
        parts.add(TARGET_JAVA_VERSION);
        parts.add("--target");
        parts.add(TARGET_JAVA_VERSION); 
        if (Platform.isWin()) {
            parts.add("--system");
            String javaHome = System.getProperty("java.home"); 
            String sysPath;
            sysPath = javaHome.substring(0,javaHome.indexOf("jdk-"));
            sysPath += "jdk-" + TARGET_JAVA_VERSION + File.separator;
            parts.add("\"" + javaHome + "\"");
        }  
         
        // use these, if you want
        parts.add("-Xlint:deprecation");
        parts.add("-Xlint:unchecked");
        
        // ERRORED OUT
        //parts.add("-parameters");
        
        parts.add(srcPath);
        return parts;  
    } 

    public List<String> getCompileCommand(String classPath) {
        classPath = StringTool.getUnwrapped(classPath);
        if (!classPath.endsWith(File.separator) && !classPath.equals(".") && !classPath.equals("..")) {
            classPath += File.separator;
        }
        List<String> parts = new ArrayList<>();
        String pathToJavac = "/usr/bin/javac";
        if (Platform.isWin()) {
            pathToJavac = "\"" + System.getProperty("java.home") + "\\bin\\javac.exe\""; //C:\\Program Files\\Java\\jdk-19\\bin\\javac.exe\"";
        } else {
            pathToJavac = "/usr/lib/jvm/jdk-19/bin/javac";
        }
        parts.add(pathToJavac);
        parts.add("-cp"); 
        parts.add(new GetClassPathFor(StringTool.getDoubleQuoted(classPath)).getResult());
        //parts.add("--release");
        //parts.add(TARGET_JAVA_VERSION);;
        parts.add("--source");
        parts.add(TARGET_JAVA_VERSION);
        parts.add("--target");
        parts.add(TARGET_JAVA_VERSION); 
        if (Platform.isWin()) {
            parts.add("--system");
            String javaHome = System.getProperty("java.home"); 
            String sysPath;
            sysPath = javaHome.substring(0,javaHome.indexOf("jdk-"));
            sysPath += "jdk-" + TARGET_JAVA_VERSION + File.separator;
            parts.add("\"" + javaHome + "\"");
        }  
         
        // use these, if you want
        parts.add("-Xlint:deprecation");
        parts.add("-Xlint:unchecked");
        

        return parts;  
    } 

    public boolean getDebug() {
        return debug;
    }

    public int getExitValue() {
        return exitValue;
    }

    public String getNextArg(String s) {
        if (s.charAt(0) == '\"' && s.indexOf("\"",1) != -1) {
            return s.substring(0,s.indexOf("\"",1) + 1); 
        } else {
            if (s.indexOf(" ") != -1) {
                return s.substring(0,s.indexOf(" "));
            } else {
                return s;
            }
        }
    }

    public Process getProcess() {
        return process;
    }

    public List<String> getRunCommand(Jar jar, String className) {
        return getRunCommand(jar,className,"");
    }
    
        public List<String> getRunCommand(Jar jar, String className, List<String> args) {
        String argsString = "";
        for(int i = 0; i < args.size() - 1;i++) argsString += args.get(i) + " ";
        if (args.size() > 0) argsString += args.get(args.size() - 1);
        return getRunCommand(jar,className,argsString);
    }
    
    public List<String> getRunCommand(Jar jar, String className, String unwrappedArgs) {
        List<String> parts = new ArrayList<>();
        parts.add("java");
        parts.add("-cp");
        parts.add(new GetClassPathFor(jar.getAbsolutePath()).getResult());
        parts.add(className);
        List<String> args = getArgs(unwrappedArgs);
        for(int i = 0; i < args.size();i++) {
            parts.add(args.get(i));
        }
        return parts;
    }
    
    public List<String> getRunCommand(String classPath, String className) {
        return getRunCommand(classPath,className,"");
    }
    
    public List<String> getRunCommand(String classPath, String fqcn, String appArgs) {
        List<String> parts = new ArrayList<>();
        String unwrappedArgs = StringTool.getUnwrapped(appArgs);
        if (Platform.isWin()) {
            parts.add("java");
        } else if (Platform.isNix()) {
            parts.add("/usr/lib/jvm/jdk-19/bin/java");
        }
        parts.add("-cp");
        parts.add(new GetClassPathFor(classPath).getResult());
        parts.add(fqcn);
         
        // reify using StringTool.hasFile() && StringTool.getFileAndTrimmedRemainder();
        List<String> args = getArgs(unwrappedArgs);
        String remainder = StringTool.rTrimIfContains(appArgs," \t\n\r");
        while (remainder.length() > 0) {
            String arg = "";
            if (StringTool.hasFile(remainder)) {
                String[] fileAndRemainder = StringTool.getFileAndTrimmedRemainder(remainder);
                parts.add(fileAndRemainder[0]);
                remainder = fileAndRemainder[1];
            } else {
                if (StringTool.hasQuoted(remainder)) {
                    String[] argParts = StringTool.getQuotedAndTrimmedRemainder(remainder);
                    parts.add(argParts[0]);
                    remainder = argParts[1];
                } else {
                    parts.add(remainder);
                    remainder = "";
                }
            }
        }
        //for(int i = 0; i < args.size();i++) {
        //    parts.add(args.get(i));
        //}
        return parts;
    }
    
    public List<String> getRunCommand(String classPath, String className, String[] args) {
        List<String> parts = new ArrayList<>();
        parts.add("java");
        parts.add("-cp");
        parts.add(new GetClassPathFor(ProjectPath.INSTANCE.getProjectPath()).getResult());
        parts.add(className);
        if (args != null) {
            for(int i = 0;i < args.length;i++) {
                parts.add(args[i]);
            }
        }
        return parts;
    }
    
    public static String getShortPackageAndNameForJavaFilename(String src) {
        src = StringTool.replaceAll(src,File.separatorChar,".");
        //System.out.println("Src: " + src);
        String shortName = "";
        String remainder = "";
        if (src.contains(".")) {
            shortName += src.charAt(0) + ".";
            remainder = src.substring(src.indexOf(".") + 1);
        } else return src; // in default package
        //System.out.println("Remainder: " + remainder);
        while (remainder.indexOf(".") > 0) {
            shortName += remainder.charAt(0) + ".";
            remainder = remainder.substring(remainder.indexOf(".") + 1);
        }
        if (!remainder.contains(".")) shortName += remainder;
        return shortName;
    }
    
    public List<SystemToken> getTokens() {
        return tokens;
    }

    public boolean isPOSIX() { return !isWin(); }
    
    public boolean isWin() {
        return File.separator.equals("\\");
    }
    
    public boolean isWindows() { return isWin(); }
    
    public boolean isWrapped(String s) {
        s = s.trim();
        return s.startsWith("\"") && s.endsWith("\"");
    }
    
//    public static void main(String[] args) {
//        String javaHome = System.getProperty("java.home"); 
//        System.err.println("JavaHome: " + javaHome);
//        System.exit(0);

//        SystemTool tool = SystemTool.INSTANCE;

//        System.out.println("Command: " + tool.getRunCommand("F:\\projects\\TimsToy\\","ca.tecreations.apps.javacompiler.JavaCompiler","test arg2 \"arg3\" argN"));
//        System.exit(0);
        
//        String srcPath = "F:\\projects\\StusTwelve\\ca\\tecreations\\Diff.java";
//        tool.clean(new File("F:\\projects\\StusTwelve\\"),true);
//        tool.compile(new File(srcPath),true);
        
        
        //System.out.println("ShortPackage('A_SpawnSystemCompiler'): " + getShortPackageAndNameForJavaFilename("A_SpawnSystemCompiler"));
        //System.out.println("ShortPackage('ca" + File.separator + "tecreations" + File.separator + "BuildProject'): " + getShortPackageAndNameForJavaFilename("ca\\tecreations\\BuildProject"));
        //System.out.println("ShortPackage('ca" + File.separator + "Pair): " + getShortPackageAndNameForJavaFilename("ca\\Pair"));
        //System.exit(0);
        
//        new TecStreamPrinterServer();
//        TecStreamPrinterClient client = new SystemTool().spawnWithNetworkOutput(SystemTool.class.getSimpleName(),"java -cp " + new GetClassPathFor(ProjectPath.getSourceJarPath()).getResult() + " ca.tecreations.FindInFiles JarReader",true);
        //Process process = new SystemTool().spawnAndOutput(System.out,System.err,"java -cp " + new GetClassPathFor(ProjectPath.getSourceJarPath()).getResult() + " ca.tecreations.FindInFiles JarReader",true);
//        Process process = client.getProcess();
//        while (process.isAlive()) {
//            Platform.sleep(500); 
//        }
//        System.exit(0);

        
//    }
    
    /** readFromProcess(Process process);
     * 
     * Reads from a java.lang.Process? in a non-blocking way.
     * 
     * @param process The process.
     */

    public void readFromProcess(Process process) {
        debug = true;
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()))) {
                String line = reader.readLine();
                if (line != null) {
                    if (debug) System.out.println(line);
                    tokens.add(new SystemToken(line,TecData.SYS_OUT));
                    System.out.println("Tokens.size: " + tokens.size());
                }
                while ((line = reader.readLine()) != null) {
                    // Process the line of output
                    if (debug) System.out.println(line); 
//                    if (tsps != null) tsps.send(line);
                    tokens.add(new SystemToken(line, TecData.SYS_OUT)); 
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }).start();            
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()))) {
                String line;
                while ((line = reader.readLine()) != null) {
                    // Process the line of output
                    if (debug) System.err.println(line); 
//                    if (tsps != null) tsps.send(line);
                    tokens.add(new SystemToken(line, TecData.SYS_ERR)); 
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("run(2): tokens.size(): " + tokens.size());
        }).start();            
    }
 

    /**
     * Runs a process and returns the java.lang.Process unmodified.
     * @param command
     * @return 
     */
    
    public Process runAndGet(String command) {
        return runAndGet(command,false);
    }
    
    public Process runAndGet(List<String> parts, boolean debug) {
        if (debug) {
            System.out.println("SystemTool.runAndGet(1): " + TypeToType.toString(parts));
        }  
        ProcessBuilder builder = new ProcessBuilder(parts);
        try { 
            process = builder.start();
            while (!process.isAlive()) Platform.sleep(125);
        } catch (IOException ioe) {
            System.err.println("runAndGet: Unable to start process: " + TypeToType.toString(parts));
        }
        return process;
    }
    
    public Process runAndGet(String command,boolean debug) {
        if (debug) {
            System.out.println("SystemTool.runAndGet(2): " + command);
        }
        if (command.startsWith("`") && command.endsWith("`")) {
            command = command.substring(0,command.lastIndexOf("`"));
        }
        
        ProcessBuilder builder = new ProcessBuilder(StringTool.explode(command,' '));
        try {
            process = builder.start();
            while (!process.isAlive()) Platform.sleep(125);
        } catch (IOException ioe) {
            System.err.println("runAndGet: Unable to start process: " + command);
        }
        return process;
    }

    public Process runAndGet(String command, String[] args, boolean debug) {
        if (args.length > 0) {
            command += " " + args[0];
        }
        for(int i = 1;i < args.length;i++) {
            command += " " + args[i];
        }
        if (debug) System.out.println("SystemTool.runAndGet(3): " + command);
        return runAndGet(command);
    } 
    
    public Process runAndInheritIO(String command,boolean debug) {
        tokens = new ArrayList<>();
        ProcessBuilder builder = new ProcessBuilder(StringTool.explode(command,' '));
        if (debug) System.out.println("SystemTool.runAndInheritIO: " + new Time().getAppEventTime() + " : " + command);
        try {
            builder.inheritIO();
            process = builder.start();
            while (!process.isAlive()) Platform.sleep(125);
           
        } catch (IOException ioe) {
            System.err.println("Unable to start process: " + command);
        }
        return process;
    }
    
    public void runAndOutputAndWait(PrintStream out,PrintStream err, String command, boolean debug) {
        ProcessBuilder builder = new ProcessBuilder(StringTool.explode(command,' '));
        if (debug) System.out.println("SystemTool.runAndOutput: " + new Time().getAppEventTime() + " : " + command);
        try {
            process = builder.start();
        } catch (IOException ioe) {
            System.out.println("Unable to start process.");
        }
        readFromProcess(process);
        try {
            process.waitFor();
        } catch (InterruptedException ie) {
            System.out.println("While waiting: " + ie);
        }
    }

    public void runAndOutput(String command, boolean debug) {
        command = StringTool.getUnwrapped(command);
        tokens = new ArrayList<>();
        if (debug) {
            System.out.println("SystemTool.runAndOutput: " + command);
        }
        ProcessBuilder builder = new ProcessBuilder(StringTool.explode(command,' '));
        try {
            process = builder.start();
            //while (!process.isAlive()) Platform.sleep(125); // causes the program to stall on Ubuntu Linux 16.04
        } catch (IOException ioe) {
            System.err.println("Unable to start process: " + command);
        }
        readFromProcess(process);
        try {
            process.waitFor();
        } catch (InterruptedException ie) {
            System.err.println("Interrupted: " + ie);
        }
    }
     
    public int runAndWait(List<String> parts, boolean debug) {
        if (debug) {
            System.out.println("SystemTool.runAndWait(1): " + TypeToType.toString(parts));
        }  
        ProcessBuilder builder = new ProcessBuilder(parts);
        try { 
            process = builder.start();
            while (!process.isAlive()) Platform.sleep(125);
        } catch (IOException ioe) {
            System.err.println("runAndWait: Unable to start process: " + TypeToType.toString(parts));
        }
        try {
            process.waitFor();
        } catch (InterruptedException ie) {
            System.err.println("runAndWait: interrupted: " + parts);
        }
        return process.exitValue();
    }

    public int runAndWait(String command, String[] args, boolean debug) {
        if (args.length > 0) {
            command += " " + args[0];
        }
        for(int i = 1;i < args.length;i++) {
            command += " " + args[i];
        }
        if (debug) System.out.println("SystemTool.runAndWait(3): " + command);
        return runAndWait(command);
    } 
    
    public int runAndWait(String command) {
        return runAndWait(command,false);
    }
    
    public int runAndWait(String command,boolean debug) {
        if (debug) {
            System.out.println("SystemTool.runAndWait(2): " + command);
        }
        if (command.startsWith("`") && command.endsWith("`")) {
            command = command.substring(0,command.lastIndexOf("`"));
        }
        
        ProcessBuilder builder = new ProcessBuilder(StringTool.explode(command,' '));
        try {
            process = builder.start();
        } catch (IOException ioe) {
            System.err.println("runAndWait: unable to start process: " + command);
        }
        readFromProcess(process);
        try {
            process.waitFor();
        } catch (InterruptedException ie) {
            System.err.println("runAndWait: interrupted: " + command);
        }
        return process.exitValue();
    }

    public List<SystemToken> runForOutput(String command, boolean debug) {
        command = StringTool.getUnwrapped(command);
        if (debug) {
            System.out.println(SN + ".runForOutput: command: " + command);
        }
        ProcessReader reader = new ProcessReader(command,debug);
        reader.start();
        while (!reader.isDone()) { Platform.sleep(250); }
        List<SystemToken> tokens = reader.getTokens();
        //Print.listSystemToken(tokens);
        return tokens;
    }
     
    public List<SystemToken> runForOutputJava(String classPath, String fqcn, String appArgs, boolean debug) {
        tokens = new ArrayList<>();
        List<String> runCmd = getRunCommand(classPath,fqcn,appArgs);
        String cmd = "";
        for(int i = 0; i < runCmd.size();i++) cmd += runCmd.get(i) + " ";
        if (runCmd.size() > 0) cmd += runCmd.get(runCmd.size() - 1);
        if (debug) {
            System.out.println(SN + ".runForOutputJava: command: " + TypeToType.toString(runCmd));
        } 
        return runForOutput(cmd,true);
    }
    
    public Process runJava(String classPath, String className, String args) {
        List<String> parts = StringTool.explode(args,' ');
        String[] argsParts = new String[parts.size()];
        for(int i = 0; i < parts.size();i++) argsParts[i] = parts.get(i);
        return runJava(classPath,className,argsParts);
    }
 
    public Process runJava(String classpath, String className, List<String> args) {
        String[] argsParts = new String[args.size()];
        for(int i = 0; i < args.size();i++) argsParts[i] = args.get(i);
        return runJava(classpath,className,argsParts);
    }
 
    public Process runJava(String classpath, String className, String[] args) {
        List<String> parts = getRunCommand(classpath, className,args);
        ProcessBuilder builder = new ProcessBuilder(parts);
        System.out.println("SystemTool.runJava: " + new Time().getAppEventTime() + " : " + TypeToType.toSpacedString(parts));
        try {
            process = new ProcessBuilder(parts).start();
        } catch (IOException ioe) {
        }
        readFromProcess(process);
        return process;
    }
 
    
//    public void setTSPS(TLS_TSPS tsps) {
//        this.tsps = tsps;
//    }
    
    public static Process spawn(String command,boolean debug) {
        command = StringTool.getUnwrapped(command);
        if (debug) System.out.println("SystemTool.spawn: '" + command + "'");
        Process process = null;
        try { 
            process = runtime.exec(command);
        } catch (IOException ioe) {
            System.out.println("Unable to execute: " + command);
        }
        return process;
    }
  
    public Process spawnAndOutput(PrintStream out,PrintStream err,String command,boolean debug) {
        command = StringTool.getUnwrapped(command);
        if (debug) System.out.println("SystemTool.spawnAndOutput: '" + command + "'");
        try { 
            process = runtime.exec(command);
        } catch (IOException ioe) {
            System.out.println("Unable to execute: " + command);
        }
        readFromProcess(process);
        return process;
    }

    public Process spawnJava(String classPath, String className, String args, boolean debug) {
        List<String> parts = StringTool.explode(args,' ');
        String[] argsParts = new String[parts.size()];
        for(int i = 0; i < parts.size();i++) argsParts[i] = parts.get(i);
        return spawnJava(classPath,className,argsParts,debug);
    }
 
    public Process spawnJava(String classpath, String className, List<String> args, boolean debug) {
        String[] argsParts = new String[args.size()];
        for(int i = 0; i < args.size();i++) argsParts[i] = args.get(i);
        return spawnJava(classpath,className,argsParts,debug);
    }
 
    public Process spawnJava(String classPath, String className, String[] args,boolean debug)  {
        List<String> parts = getRunCommand(classPath, className,args);
        if (debug) System.out.println("SystemTool.spawnJava: " + new Time().getAppEventTime() + " : " + TypeToType.toSpacedString(parts));
        ProcessBuilder pb = new ProcessBuilder(parts);
        pb.inheritIO();
        try {
            process = pb.start();
        } catch (IOException ioe) {
            System.err.println("Process starting: " + ioe);
        }
        return process;
    }

/*
    public TecStreamPrinterClient spawnWithNetworkOutput(String sourceClassName, String command,boolean debug) {
        command = StringTool.getUnwrapped(command);
        if (debug) System.out.println("SystemTool.spawnWithNetworkOutput: '" + command + "'");
        try { 
            process = runtime.exec(command);
            while (!process.isAlive()) Platform.sleep(125);
        } catch (IOException ioe) {
            System.out.println("Unable to execute: " + command);
        } 
        return new TecStreamPrinterClient(process,sourceClassName);
    }
*/
    
    public List<SystemToken> spawnWithOutput(String cmd, boolean debug) {
        tokens = new ArrayList<>();
        tokens.add(new SystemToken("test",TecData.SYS_ERR));
        cmd = StringTool.getUnwrapped(cmd);
        if (debug) System.out.println("SystemTool.spawnWithOutput: '" + cmd + "'");
        try { 
            process = runtime.exec(cmd);
        } catch (IOException ioe) {
            System.out.println("Unable to execute: " + cmd);
        }
        readFromProcess(process);
        try {
            process.waitFor();
        } catch (InterruptedException ie) {
            System.out.println("Interrupted");
        }
        return tokens;
    }
}

/*
    Tim Notes:

    Using the readFromProcess(process) works better than StreamPrinter.


*/