package ca.tecreations;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
public class ProcessReader extends Thread {
    public static final String SN = ProcessReader.class.getSimpleName();
    String command;
    List<SystemToken> tokens = new ArrayList<>();
    Process process;
    boolean done = false;
    
    public ProcessReader(String command, boolean debug) {
        this.command = StringTool.getUnwrapped(command);
        if (debug) {
            System.out.println(SN + "(): command: " + command);
        }
    }
    
    public List<SystemToken> getTokens() { return tokens; }

    public boolean isDone() { return done; }
    
    public void run() {
        List<String> parts = StringTool.explode(command,' ');
        ProcessBuilder builder = new ProcessBuilder(parts);
        try {
            process = builder.start();
        } catch (IOException ioe) {
            System.err.println(SN + "(): Unable to start process: " + command);
        }
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()))) {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    tokens.add(new SystemToken(line, TecData.SYS_OUT)); 
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }).start();            
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()))) {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    tokens.add(new SystemToken(line, TecData.SYS_ERR)); 
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }).start();            
        try {
            process.waitFor();
        } catch (InterruptedException ie) {
            System.err.println(SN + "(): Interrupted: " + ie);
        }
        done = true;
    }

    public static void main(String[] args) {
        String command = "/usr/bin/hostname -I";
        ProcessReader reader = new ProcessReader(command,true);
        reader.start();
        while (!reader.isDone()) { Platform.sleep(250); }
        System.out.println("Tokens: ");
        List<SystemToken> tokens = reader.getTokens();
        for(int i = 0; i < tokens.size();i++) {
            tokens.get(i).tPrintln();
        }
        
        
        
    }
    
}
