package ca.tecreations;

/**
 *
 * @author Tim
 */
public class MouseWheel {
    public static final String SN = MouseWheel.class.getSimpleName();
    int notches;
    boolean alt = false;
    boolean ctrl = false;
    boolean shift = false;
    
    public MouseWheel(int notches, boolean alt, boolean ctrl, boolean shift) {
        this.notches = notches;
        this.alt = alt;
        this.ctrl = ctrl;
        this.shift = shift;
    }
    
    public static MouseWheel fromString(String s) {
        System.out.println(SN + ".fromString: " + s);
        String remainder = s.substring(s.indexOf("[") + 1,s.lastIndexOf("]")); 

        String notchesPart = remainder.substring(0,remainder.indexOf(":"));
        int notches = Integer.parseInt(notchesPart);
        
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        String next;
        
        next = remainder.substring(0,remainder.indexOf(":")).toLowerCase();
        boolean alt = next.equals("alt");
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        next = remainder.substring(0,remainder.indexOf(":")).toLowerCase();
        boolean ctrl = next.equals("ctrl");
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        next = remainder.substring(0).toLowerCase();
        boolean shift = next.equals("shift"); 

        return new MouseWheel(notches,alt,ctrl,shift);
    }
    
    public int getNotches() { return notches; }
    
    public boolean isAltDown() { return alt; }
    
    public boolean isCtrlDown() { return ctrl; }
    
    public boolean isShiftDown() { return shift; }
    
    
    
    
    public String toString() {                                                     
        String transportString = "MouseWheel[" + notches + ":"; // MouseWheel[+/-d:
        transportString += (alt ? "alt:" : ":");                               // [{alt}]:           -- : if not present/down
        transportString += (ctrl ? "ctrl:" : ":");                             // [{ctrl}]:          -- : if not present/down
        transportString += (shift ? "shift" : "");                           // [{shift}] :          -- '' if not present/down
        transportString += "]";                                                    // ]
        return transportString;
    }
    
    
    
}
