package ca.tecreations;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;


/**
 *
 * @author Tim
 */
public class Mouse {
    Point scrPoint;
    Point compPoint;
    boolean altDown = false;
    boolean ctrlDown = false;
    boolean shiftDown = false;
    int count = -1;
    public Integer mButton;
    public Boolean isDown = null;

    public Mouse(MouseEvent e, boolean isDown) {
        scrPoint = new Point(e.getLocationOnScreen());
        compPoint = new Point(e.getX(),e.getY());
        if (SwingUtilities.isLeftMouseButton(e)) {
            mButton = InputEvent.BUTTON1_DOWN_MASK;
        } else if (SwingUtilities.isRightMouseButton(e)) {
            mButton = InputEvent.BUTTON3_DOWN_MASK;
        } else {
            mButton = InputEvent.BUTTON2_DOWN_MASK;
        }
        if (isDown) count = 0;
        else count = e.getClickCount();
        altDown = e.isAltDown();
        ctrlDown = e.isControlDown();
        shiftDown = e.isShiftDown();
        this.isDown = isDown;
    }
    
    public Mouse(Point screen, Point component, int mButton, int count, boolean altDown, boolean ctrlDown, boolean shiftDown, Boolean isDown) {
        this.scrPoint = screen;
        this.compPoint = component;
        this.mButton = mButton;
        this.count = count;
        this.altDown = altDown;
        this.ctrlDown = ctrlDown;
        this.shiftDown = shiftDown;
        this.isDown = isDown;
    }
    
    public static boolean debug = false;
    
    public static Mouse fromString(String s) {
        boolean verbose = false;
        System.out.println("Mouse.fromString: " + s);
        // for location
        int x = Integer.parseInt(s.substring(s.indexOf("(") + 1,s.indexOf(",")));
        int y = Integer.parseInt(s.substring(s.indexOf(",") + 1,s.indexOf(")")));
        Point screenPoint = new Point(x,y); 
        // we can garbage x and y but we use them again
        if (debug && verbose) System.out.println("screenPoint: " + screenPoint);
        String remainder = s.substring(s.indexOf(":") + 1);
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        
        // for event
        String intPart = remainder.substring(remainder.indexOf("(") + 1,remainder.indexOf(","));
        x = Integer.parseInt(intPart);
        y = Integer.parseInt(remainder.substring(remainder.indexOf(",") + 1,remainder.indexOf(")")));
        Point componentPoint = new Point(x,y);
        remainder = remainder.substring(remainder.indexOf(":") + 1); 
        if (debug && verbose) System.out.println("componentPoint: " + componentPoint);
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        
        String next = remainder.substring(0,remainder.indexOf(":"));
        if (debug && verbose) System.out.println("Next: " + next);
        int mButton = Integer.parseInt(next);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        if (debug && verbose) System.out.println("mButton: " + mButton);
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        
        next = remainder.substring(0,remainder.indexOf(":"));
        int count = Integer.parseInt(next);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        if (debug && verbose) System.out.println("count: " + count);
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        
        next = remainder.substring(0,remainder.indexOf(":")).toLowerCase();
        boolean altDown = next.equals("alt");
        if (debug && verbose) System.out.println("altDown: " + altDown);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        next = remainder.substring(0,remainder.indexOf(":")).toLowerCase();
        boolean ctrlDown = next.equals("ctrl");
        if (debug && verbose) System.out.println("ctrlDown: " + ctrlDown);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        next = remainder.substring(0,remainder.indexOf(":")).toLowerCase();
        boolean shiftDown = next.equals("shift");
        if (debug && verbose) System.out.println("shiftDown: " + shiftDown);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        next = remainder.substring(0,remainder.indexOf("]"));
        Boolean isDown;
        if (next.equals("down")) isDown = true;
        else if (next.equals("up")) isDown = false;
        else isDown = null; // storage-wise, you could use a :: type separator, indicating 'NOT_PRESENT' similar to altDown etc.
        if (debug && verbose) System.out.println("isDown: " + isDown);

        return new Mouse(screenPoint,componentPoint,mButton,count,altDown,ctrlDown,shiftDown,isDown);
    }
    
    //--------------------------------------------------------------------------
    

    public Point getComponentPoint() { return compPoint; }
    
    public int getCount() { return count; }
    
    public int getDownMask() { return mButton; }
    
    public int getComponentX() { return compPoint.x; }
    
    public int getComponentY() { return compPoint.y; }
    
    public Point getScreenPoint() { return scrPoint; }

    public int getScreenX() { return scrPoint.x; }
    
    public int getScreenY() { return scrPoint.y; }
    
    public boolean isAltDown() { return altDown; }
    
    public boolean isControlDown() { return ctrlDown; }
    
    public boolean isCtrlDown() { return ctrlDown; }
    
    public boolean isDown() { return isDown; }

    public boolean isLeft() { return mButton == InputEvent.BUTTON1_DOWN_MASK; }
    
    public boolean isMiddle() { return mButton == InputEvent.BUTTON2_DOWN_MASK; }
    
    public boolean isRight() { return mButton == InputEvent.BUTTON3_DOWN_MASK; }
    
    public boolean isShiftDown() { return shiftDown; }
    
    public boolean isUp() { return !isDown; }
    
    public static void main(String[] args) {
        Point loc = new Point(100,100);
        Point evt = new Point(1024,1024);
        Mouse mouse = new Mouse(loc,evt,7,0,true,true,true,false);
        System.out.println(mouse.toString());
        
        Mouse mouseFrom = Mouse.fromString(mouse.toString());
        mouse = new Mouse(loc,evt,7,1,true,true,true,null);
        System.out.println(mouse.toString());
        
        System.out.println(Mouse.fromString("Mouse[(88,99):(188,199):1:0::ctrl::up]").toString());
    }
    
    
    public void setDownMask(int mButton) {
        this.mButton = mButton;
    }
    

    public String toString() {                                                     // [{}] denotes a possible value
                                                                                   // () wraps entities : @see scrPoint, compPoint
                                                                                   // ':' separates parts
                                                                                   
        String transportString = "Mouse[(" + scrPoint.x + "," + scrPoint.y + "):"; // Mouse[(scrX,scrY): -- screen point
        transportString += "(" + compPoint.x + "," + compPoint.y + "):";           // (compX,compY):     -- evtXY in component
        transportString += mButton + ":";                                          // InputEvent.xxx:    -- mouse button num
        transportString += count + ":";                                            // d*d:               -- click count, min 0, max?
        transportString += (altDown ? "alt:" : ":");                               // [{alt}]:           -- : if not present/down
        transportString += (ctrlDown ? "ctrl:" : ":");                             // [{ctrl}]:          -- : if not present/down
        transportString += (shiftDown ? "shift:" : ":");                           // [{shift}]:         -- : if not present/down
        if (count == 0) {                                                          // [null|up|down)]    -- null if count > 0
            if (isDown) transportString += "down";
            else transportString += "up";
        } else {
            transportString += "null";
        }
        transportString += "]";                                                    // ]
        return transportString;
    }
}