package a;

import ca.tecreations.*;
import ca.tecreations.components.*;


import java.awt.Graphics;
/**
 *
 * @author Tim
 */
public class App extends TFrame {
    public static Properties properties = new Properties(ProjectPath.getPropertiesPath() + "App.properties");
    
    public App() {
        super(properties,"App");
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        
        Point3D p = new Point3D( 50, 20, 100);
        Point projected = project(p,getWidth(), getHeight());
        g.fillRect(projected.x,projected.y,2,2);
    }
    
    Point project(Point3D p3d, int width, int height) {
        float scaleFactor = width / 4.0f;
        float near = 3.0f;
        float nearToObj = 1.5f;
        
        float x1 = p3d.x;
        float y1 = p3d.y;
        float z1 = p3d.z;
        
        x1 = x1 * near / (z1 + near + nearToObj);
        y1 = y1 * near / (z1 + near + nearToObj);
        
        return new Point((int)(width / 2 + scaleFactor * x1 + 0.5),
                          (int)(height / 2 - scaleFactor * y1 + 0.5));
    }
    
    public static void main(String[] args) {
        App app = new App();
        app.setVisible(true);
        app.setExitOnClose(true);
    }
}
