package ca.tecreations.wip.toy;
//CodeJava
import ca.tecreations.TColor;
import ca.tecreations.File;
import ca.tecreations.StringTool;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;
import ca.tecreations.TextToken;
import ca.tecreations.text.TextPoints;
import ca.tecreations.text.TextTokenPainter;

import java.awt.event.MouseEvent;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 */
public class CodeJava extends CodeFile {
    TextPoints points = TecData.CODE_POINTS;
    List<List<TextToken>> tokens = new ArrayList<>();
    List<List<TextTokenPainter>> painters = new ArrayList<>();
    int maxWidth = 0;
        
    public CodeJava(File f) {
        this(f.getAbsolutePath());
    }
    
    public CodeJava(String absPath) {
        super(absPath);
        tokens = parse();
        List<TextToken> tokensLine;
        List<TextTokenPainter> linePainters;
        TextTokenPainter painter;
        int width;
        for(int i = 0; i < tokens.size();i++) {
            tokensLine = tokens.get(i);
            linePainters = new ArrayList<>();
            width = 0;
            for(int j = 0; j < tokensLine.size();j++) {
                painter = new TextTokenPainter(points,tokensLine.get(j),TColor.black);
                width += painter.getTextWidth();
                linePainters.add(painter);
//                System.out.print(painter.getText());
            }
            painters.add(linePainters);
//            System.out.println();
            maxWidth = Math.max(maxWidth,width);
        }
        //System.out.println("Width: " + maxWidth + " Height: " + (lines.size() * points.getFontSize()));
        //setSize(maxWidth,lines.size() * points.getFontSize());
    }

    public static void main(String[] args) {
        Toy.launch();
    }
    
    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        repaint();
    }
    
    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        repaint();
    }
    
    public void paintElement(Graphics g) {
        //System.err.println("CodeJava.paintElement");
        g = getGraphics();
        List<TextTokenPainter> linePainter;
        TextTokenPainter painter;
        int x;
        int y = 0;
        //System.out.println("Painters.size: " + painters.size());
        for(int i = 0; i < painters.size();i++) {
            x = 0;
            linePainter = painters.get(i);
            //for(int j = 0; j < linePainter.size();j++) {
            //    System.out.print(linePainter.get(i).getText());
            //}
            //System.out.println();
            for(int j = 0; j < linePainter.size();j++) {
                painter = linePainter.get(j);
                painter.paintAt(g, x, y);
                x += painter.getTextWidth();
                //System.out.print(painter.getText());
            }
            //System.out.println();
            y += points.getFontSize();
            if (y > getSize().height) break;
        }
        g.drawLine(0,0,getSize().width,getSize().height);
    }
    
    public void paint(Graphics g) {
        paintElement(g);
    }
    
    public final List<List<TextToken>> parse() {
        List<List<TextToken>> tokens = new ArrayList<>();
        List<TextToken> line;
        for(int i = 0; i < lines.size();i++) {
            //System.out.println(i + ": " + lines.get(i));
            line = tokenize(lines.get(i));
            tokens.add(line);
        }
        return tokens;
    }
    
    public List<TextToken> tokenize(String line) {
        List<String> parts = StringTool.explodeWith(line,' ');
        //System.out.println(line + ": " + parts);
        List<TextToken> lineTokens = new ArrayList<>();
        for(int i = 0;i < parts.size() - 1;i++) {
            lineTokens.add(new TextToken(parts.get(i)));
        }
        if (!parts.isEmpty()) lineTokens.add(new TextToken(parts.get(parts.size() - 1)));
        return lineTokens;
    }
    
    
}
