package ca.tecreations;

import ca.tecreations.net.SharedCode;

/**
 *
 * @author Tim
 */
public class Drag {
    Mouse start;
    Mouse stop;
    int dx;
    int dy;
    byte v; 
    byte h;
    public static final byte UP = 1;
    public static final byte DOWN = -1;

    public static final byte LEFT = -1;
    public static final byte RIGHT = 1;
    
    public static final byte CENTER = 0;
    
    public static boolean debug = true;
    
    public Drag(Mouse start, Mouse stop) {
        this.start = start;
        this.stop = stop;
        int startx = start.getLocX();
        int starty = start.getLocY();
        int stopx = stop.getLocX();
        int stopy = stop.getLocY();
        if (startx < stopx) {
            dx = stopx - startx;
            h = RIGHT;
        } else if (startx > stopx) {
            dx = startx - stopx;
            h = LEFT;
        } else {
            dx = 0;
            h = CENTER;
        }
        if (starty < stopy) {
            dy = stopy - starty;
            v = UP;
        } else if (starty < stopy) {
            dy = starty - stopy;
            v = DOWN;
        } else {
            dy = 0;
            v = CENTER;
        }
    }
    

    public static Drag fromString(String s) {
        boolean verbose = true;
        String remainder = s.substring(s.indexOf("[" + 1),s.indexOf("]"));
        Mouse start = null;
        Mouse stop = null;
        String quotedStart = SharedCode.getFirstQuoted(remainder);
        start = Mouse.fromString(StringTool.getUnwrapped(SharedCode.getFirstQuoted(remainder)));
        remainder = SharedCode.getNextChunk(remainder,quotedStart.length());
        if (debug && verbose) System.out.println("Remainder (1): " + remainder);
        if (remainder.startsWith(",")) {
            remainder = remainder.substring(1).trim();
        }
        stop = Mouse.fromString(StringTool.getUnwrapped(remainder));
            
        Drag drag = new Drag(start,stop);
        return drag;
    }
    
    public Mouse getStart() { return start; }
    
    public Mouse getStop() { return stop; }
    
    public void setStart(Mouse start) {
        this.start = start;
    }
    
    public void setStop(Mouse stop) {
        this.stop = stop;
    }

    public String toString() {
        return "Drag[" + StringTool.getDoubleQuoted(start.toString()) + "," + StringTool.getDoubleQuoted(stop.toString()) + "]";
    }
    
}
