package ca.tecreations.time;

import java.time.LocalDate;
import java.util.Calendar;
/**
 *
 * @author tim
 */
public class DateCarrier {
    public static String TODAY = getTodaysDate();
    String ymd;
    int year = -999;
    int month = -999;
    int day = 999;

    public DateCarrier(String asYMD) {
        if (asYMD.contains("-")) {
            int first = asYMD.indexOf("-");
            int second = asYMD.indexOf("-",first + 1);
            year = Integer.parseInt(asYMD.substring(0,first));
            month = Integer.parseInt(asYMD.substring(first + 1,second));
            day = Integer.parseInt(asYMD.substring(second + 1));
        } else if (asYMD.contains("/")) {
            int first = asYMD.indexOf("/");
            int second = asYMD.indexOf("/",first + 1);
            year = Integer.parseInt(asYMD.substring(0,first));
            month = Integer.parseInt(asYMD.substring(first + 1,second));
            day = Integer.parseInt(asYMD.substring(second + 1));
        } else if (asYMD.contains("\\")) {
            int first = asYMD.indexOf("\\");
            int second = asYMD.indexOf("\\",first + 1);
            year = Integer.parseInt(asYMD.substring(0,first));
            month = Integer.parseInt(asYMD.substring(first + 1,second));
            day = Integer.parseInt(asYMD.substring(second + 1));
        } else if (asYMD.contains(".")) { 
            int first = asYMD.indexOf(".");
            int second = asYMD.indexOf(".",first + 1);
            year = Integer.parseInt(asYMD.substring(0,first));
            month = Integer.parseInt(asYMD.substring(first + 1,second));
            day = Integer.parseInt(asYMD.substring(second + 1));
        } else {
            int yearPart = asYMD.length() - 4;
            year = Integer.parseInt(asYMD.substring(0,yearPart));
            month = Integer.parseInt(asYMD.substring(yearPart, yearPart+ 2));
            day = Integer.parseInt(asYMD.substring(yearPart + 2));
        }
    }

    public java.util.Date getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        return calendar.getTime();
    }
    
    public LocalDate getLocalDate() {
        return LocalDate.parse(year + "-" + month + "-" + day);
    }
    
    public String getParsedDate() {
        if (isUnset()) return "UNSET";
        return year + "_" + month + "_" + day;
    }
    
    public static String getTodaysDate() {
        LocalDate today = LocalDate.now();
        String date = "";
        date += today.getYear() + "-";
        date += today.getMonthValue() + "-";
        date += today.getDayOfMonth();
        return date;
    }

    public String getWith(char ch) {
        if (isUnset()) return "UNSET";
        if (month < 10 && day < 10) {
            return "" + year + ch + "0" + month + ch + "0" + day;
        } else if (month < 10) {
            return "" + year + ch + "0" + month + ch + day;
        } else if (day < 10) {
            return "" + year + ch + month + ch + "0" + day;
        } else {
            return "" + year + ch + month + ch + day;
        }
    }
    
    public String getWith(String s) {
        if (isUnset()) return "UNSET";
        if (month < 10 && day < 10) {
            return year + s + "0" + month + s + "0" + day;
        } else if (month < 10) {
            return year + s + "0" + month + s + day;
        } else if (day < 10) {
            return year + s + month + s + "0" + day;
        } else {
            return year + s + month + s + day;
        }
    }
    
    /** Excel compatible, 1900 is considered a leap year, although not divisble by 400 or 4 && 100. 
     * @return boolean ...
     * @param year the year in question
     */
    public static boolean isLeapYear(int year) {
        // configure any user-defined "hook's"
        if (year == 1900) return false; // conform to MS-EXCEL
        
        if (year % 4 == 0) { // step 1
            if (year % 100 == 0) { // step 2
                if (year % 400 == 0) { // step 3
                    // step 4
                    return true;
                } else {
                    // step 5
                    return false;
                }
            } else {
                // step 4
                return true;
            }
        } else {
            // step 5
            return false;
        }
    }
    
    public boolean isUnset() {
        return year == -999 && month == -999 && day == -999;
    }
            
    public static void main(String[] args) {
        System.out.println(new DateCarrier("19700618").getWith(""));
        System.out.println(new DateCarrier("1970.06.18").getWith('.'));
        System.out.println(new DateCarrier("1970-06-18").getWith('-'));
        System.out.println(new DateCarrier("1970/06/18").getWith('/'));
        System.out.println(new DateCarrier("1970\\06\\18").getWith('\\'));
        System.out.println("Leap(1992): " + isLeapYear(1992));
        System.out.println("Leap(2000): " + isLeapYear(2000));
        System.out.println("Leap(1900): " + isLeapYear(1900));
    }
    
    public void setYMD(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
        ymd = year + "-" + month + "-" + day;
    }
}
