package ca.tecreations.net;

import ca.tecreations.*;
import ca.tecreations.components.*;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.*;
 
import javax.swing.*;
/**
 *
 * @author Tim
 */
public class NameServiceConfigurer_AddHost extends TDialog implements ActionListener {
    public static Properties properties = NameServiceConfigurer.properties;
    
    JLabel hostLabel = new JLabel("Host: "); 
    JTextField host = new JTextField(15);
    JLabel ipLabel = new JLabel("IP: ");
    JTextField ip = new JTextField(15);
    
    public JButton cancel = new JButton("Cancel");
    public JButton ok = new JButton("Ok");
    
    public NameServiceConfigurer_AddHost(TFrame frame) {
        super(frame,"NameServiceConfigurer_AddHost");
        JPanel fields = new JPanel(new GridBagLayout());
        
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 6;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        fields.add(new SizedPanel(20,20, getBackground()),gbc);

        gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        fields.add(hostLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.gridx = 2;
        gbc.gridy = 1;
        fields.add(host,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridwidth = 6;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 2;
        fields.add(new SizedPanel(20,20,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 3;
        fields.add(ipLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        fields.add(ip,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridwidth = 6;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 4;
        fields.add(new SizedPanel(20,20,getBackground()),gbc);
        
        add(fields,BorderLayout.CENTER);
        
        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(cancel);
        buttons.add(ok);
        cancel.addActionListener(this);
        ok.addActionListener(this);
        add(buttons,BorderLayout.SOUTH);
        validate();
        setSize(240,200);
        setLocationRelativeTo(frame);
        setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == cancel) {
            setVisible(false);
        } else if (e.getSource() == ok) {
            setVisible(false);
        }
    }
    
    public String getHost() { return host.getText(); }
    
    public String getIP() { return ip.getText(); }
    
}
