package ca.tecreations.misc;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.Vector;
import javax.swing.SwingUtilities;


/**
 *
 * @author Timothy
 */
public class MouseInterpreter {
    MouseEvent event;
    int numClicks;
    int button;
    boolean shift = false;
    boolean ctrl = false;
    boolean meta = false;
    boolean alt = false;
    
    public MouseInterpreter(MouseEvent event) {
        this.event = event;
        numClicks = event.getClickCount();
        button = event.getButton();
        shift = event.isShiftDown();
        ctrl = event.isControlDown();
        meta = event.isMetaDown();
        alt = event.isAltDown();
    }

    public MouseInterpreter printClickPoint() {
        System.out.println("MouseClick: " + event.getX() + "," + event.getY());
        return this;
    }
    
    public MouseInterpreter printState() {
        printClickPoint();
        if (singleClick()) System.out.println("Single Click");
        if (doubleClick()) System.out.println("Double Click");
        if (tripleClick()) System.out.println("Triple Click");
        if (leftButton()) System.out.println("Left Button  : " + leftButton());
        if (middleButton()) System.out.println("Middle Button: " + middleButton());
        if (rightButton()) System.out.println("Right Button : " + rightButton());
        if (shift) System.out.println("Shift        : " + shift());
        if (ctrl) System.out.println("Ctrl         : " + ctrl());
        if (alt) System.out.println("Alt          : " + alt());
        if (meta) System.out.println("Meta         : " + meta());
        return this;
    }
    
    public boolean isSingleClick() { return numClicks == 1; }
    
    public boolean isDoubleClick() { return numClicks == 2; }
    
    public boolean isTripleClick() { return numClicks == 3; }
    
    public boolean isLeftButton() { return SwingUtilities.isLeftMouseButton(event); }
                
    public boolean isMiddleButton() { return !leftButton() && !rightButton(); }
    
    public boolean isRightButton() { return SwingUtilities.isRightMouseButton(event); }
    
    public boolean isShift() { return shift == true; }
        
    public boolean isCtrl() { return ctrl == true; }
    
    public boolean isAlt() { return alt == true; }

    public boolean isMeta() { return meta == true; }
    
    public boolean singleClick() { return numClicks == 1; }
    
    public boolean doubleClick() { return numClicks == 2; }
    
    public boolean tripleClick() { return numClicks == 3; }
    
    public boolean leftButton() { return SwingUtilities.isLeftMouseButton(event); }
                
    public boolean middleButton() { return !leftButton() && !rightButton(); }
    
    public boolean rightButton() { return SwingUtilities.isRightMouseButton(event); }
    
    public boolean shift() { return shift == true; }
        
    public boolean ctrl() { return ctrl == true; }
    
    public boolean alt() { return alt == true; }

    public boolean meta() { return meta == true; }
} 
        