package ca.tecreations.misc;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.*;
/**
 *
 * @author Tim
 */
public class ImageSelection implements Transferable {
     
    private Image image;
    
    public ImageSelection(Image src) {
        this.image = image;
        BufferedImage newImage = new BufferedImage(
                src.getWidth(null), src.getHeight(null), BufferedImage.TYPE_INT_RGB);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(src, 0, 0, null);
        g.dispose();
        this.image = newImage;
    }
    
    public boolean isDataFlavorSupported(DataFlavor flavor){
        return DataFlavor.imageFlavor.equals(flavor);
    }
    
    public Object getTransferData(DataFlavor flavor) 
            throws UnsupportedFlavorException, IOException {
        if (!DataFlavor.imageFlavor.equals(flavor)) { 
            throw new UnsupportedFlavorException(flavor);
        }
        return image;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[] { DataFlavor.imageFlavor };
    }


}
