package ca.tecreations.components;

import ca.tecreations.File;
import ca.tecreations.Properties;
import ca.tecreations.components.TDialog;
import ca.tecreations.components.TFrame;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.*;
import java.util.List;

import javax.swing.*;
/**
 *
 * @author tim
 */
public class CommandInput_History extends TDialog implements ActionListener {
    CommandInput commandInput;
    Properties properties;
    JScrollPane scroller;
    JList commands;
    DefaultListModel model;
    JButton load = new JButton("Load");
    JButton remove = new JButton("Remove");
    JButton removeAll = new JButton("Remove All");
    JButton close = new JButton("Close");
    
    public CommandInput_History(TFrame app, CommandInput commandInput,String propsPath) {
        super(app,"CommandInput_History");
        this.commandInput = commandInput;
        properties = new Properties(new File(propsPath),false,true);
        setupGUI();
        setSize(640,480);
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == close) {
            setVisible(false);
        } else if (e.getSource() == load) {
            String selected = "";
            commandInput.setText((String)commands.getSelectedValue());
        } else if (e.getSource() == remove) {
            List<String> cmds = properties.getList("commands");
            cmds.remove((String)commands.getSelectedValue());
            properties.set("commands",cmds);
            model.remove(commands.getSelectedIndex());
        } else if (e.getSource() == removeAll) {
            properties.set("commands","");
            model.removeAllElements();
        }
    }
    
    public void addCommand(String cmd) {
        List<String> cmds = properties.getList("commands");
        if (!cmds.contains(cmd)) {
            cmds.add(cmd);
            properties.set("commands",cmds);
            model.addElement(cmd);
        }
    }
    
    public void close() {
        setVisible(false);
    }
    
    public void remove() {
        List<String> cmds = properties.getList("commands");
        cmds.remove(commands.getSelectedIndex());
        properties.set("commands",cmds);
        model.remove(commands.getSelectedIndex());
    }
    
    @Override
    public void setVisible(boolean show) {
        if (show) {
            Point loc = commandInput.getHistoryButton().getLocationOnScreen();
            setLocation(loc.x - (getSize().width / 2),loc.y - getSize().height);
        }
        super.setVisible(show);
    }
    
    public void setupGUI() { 
        model = new DefaultListModel();
        List<String> cmds = properties.getList("commands");
        for(int i = 0; i < cmds.size();i++) model.addElement(cmds.get(i));
        commands = new JList(model);
        commands.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        commands.setVisibleRowCount(-1);

        scroller = new JScrollPane(commands,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
//        scroller.setPreferredSize(new Dimension(250,380));
        add(scroller,BorderLayout.CENTER);
        
        JPanel holder = new JPanel(new BorderLayout());
        JPanel buttons = new JPanel(new GridLayout(3,1));
        buttons.add(load);
        buttons.add(remove);
        buttons.add(removeAll);
        holder.add(buttons,BorderLayout.NORTH);
        holder.add(close,BorderLayout.SOUTH);
        add(holder,BorderLayout.EAST);
        validate();
        load.addActionListener(this);
        remove.addActionListener(this);
        removeAll.addActionListener(this);
        close.addActionListener(this);
    }
}