package ca.tecreations.apps.filetool;

import ca.tecreations.File;
import ca.tecreations.StringTool;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;
import ca.tecreations.net.backup.TLSClient_TVS12;

import java.util.List;
/**
 *
 * @author Tim
 */
public class CopyOnHostDropIn extends Thread {
    FileTool app;
    TextFile log;
    TLSClient_TVS12 client;
    List<String> names;
    String dstPath;
    boolean doCopy = true;
    
    public CopyOnHostDropIn(FileTool app, TextFile log, TLSClient_TVS12 client, List<String> names, String dstPath) {
        this.app = app;
        this.log = log;
        this.client = client;
        this.names = names;
        this.dstPath = dstPath;
    }

    public CopyOnHostDropIn(FileTool app, TextFile log, TLSClient_TVS12 client, List<String> names, String dstPath, boolean doCopy) {
        this.app = app;
        this.log = log;
        this.client = client;
        this.names = names;
        this.dstPath = dstPath;
        this.doCopy = doCopy;
    }

    public void run() {
        String name;
        for(int i = 0;i < names.size();i++) {
            name = names.get(i);
            if (TecData.isDir(name)) {
                String newDstDir = StringTool.getUnwrapped(dstPath) + 
                        new File(name).getDeepestDirectoryName() + 
                        client.getFileSeparator();
                client.copyDirectory(name, newDstDir);
            } else {
                client.copyFileToDir(name,dstPath);
            }
        }
    }
    
}

