package ca.tecreations.apps.filetool;

import ca.tecreations.FileEntry;
import ca.tecreations.File;
import ca.tecreations.StringTool;
import ca.tecreations.TecData;
import ca.tecreations.apps.App;
import ca.tecreations.net.backup.TLSClient_TVS12;

import java.util.List;
/**
 *
 * @author Tim
 */
public class Cleaner extends Thread {
    App app;
    TLSClient_TVS12 client;
    String path;
    List<String> types;
    
    public Cleaner(App app,TLSClient_TVS12 client, String path,List<String> types) {
        this.app = app;
        this.client = client;
        this.path = path;
        System.err.println("Cleaner(): path: " + path + " types: " + types);
        this.types = types;
        start();
    }
    
    public void run() {
        cleanFromHere(path);
        app.refreshLast();
    }
    
    public void cleanFromHere(String path) throws NullPointerException {
        List<String> entries = client.getAll(path);
        if (entries != null) {
            if (!entries.get(0).equals(TecData.TEC_NULL)) {
                for(int i = 0; i < entries.size();i++) {
                    String name = entries.get(i).substring(0,entries.get(i).indexOf(","));
                    if (TecData.isDir(name)) {
                        String unwrapped = StringTool.getUnwrapped(path); 
                        if (!unwrapped.endsWith(client.getFileSeparator())) {
                            unwrapped += client.getFileSeparator();
                        }
                        String newPath = unwrapped + new File(name).getFilenameOnly() + 
                                            client.getFileSeparator();
                        cleanFromHere(StringTool.getDoubleQuoted(newPath)); 
                    } else {
                        String extension = new FileEntry(client,name,"","","","").getExtension();
                        if (inList(extension)) {
                            client.delete(name);         
                        }
                    }
                }
            } else {
                throw new NullPointerException("Cleaner.cleanFromHere");
            }
        }
    }    

    public boolean inList(String s) {
        for(int i = 0; i < types.size();i++) {
            if (types.get(i).equals(s)) return true;
        }
        return false;
    }
}
