package ca.tecreations;

import ca.tecreations.File;
import ca.tecreations.components.TFrame;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.event.*;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

import javax.swing.*;
      
/**
 *
 * @author Timothy
 */
public class PropertiesViewer extends TFrame implements ActionListener {

    private static final long serialVersionUID = 9096223315269278885L;
    public static final String className = "PropertiesViewer";
    private static Properties systemProperties;
    private Properties properties;
    private boolean autoFlush = true;    
    private String filename;
    private String[] keys;
    private String[] values;
    static DefaultListModel<String> model = new DefaultListModel<String>();
    JList<String> list = new JList<String>(model);
    JButton system = new JButton("System");
    JButton select = new JButton("Select");
    public String lineSeparator;
    
    public PropertiesViewer() {
        super(ProjectPath.INSTANCE.getTecPropsPath() + "PropertiesViewer.properties","PropertiesViewer");
        JPanel buttons = new JPanel(new FlowLayout(FlowLayout.LEFT));
        buttons.add(system,BorderLayout.WEST);
        buttons.add(select,BorderLayout.EAST);
        add(buttons,BorderLayout.NORTH);
        system.addActionListener(this);
        select.addActionListener(this);
        add(new JScrollPane(list, 
                            JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, 
                            JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS),BorderLayout.CENTER);
        properties = new Properties(); 
        try {
            systemProperties = System.getProperties();
        } catch (SecurityException se) {
        }
        lineSeparator = systemProperties.getProperty("line.separator");
        sortAscending(true);
        List<String> lines = getOutput();
        for(int i = 0; i < lines.size();i++) {
            model.addElement(lines.get(i));
        }
        if (!new File(ProjectPath.INSTANCE.getTecPropsPath() + "PropertiesViewer." + getStrippedOSName() + ".txt").exists()) {
            write(ProjectPath.INSTANCE.getTecPropsPath() + "PropertiesViewer." + getStrippedOSName() + ".txt");
        }
    }
    
    public PropertiesViewer(String _filename) {
        this();
        setFilename(_filename);
        
        //sortAscending(false);
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == system) {
            model.removeAllElements();
            properties = new Properties();
            List<String> lines = getOutput();
            for(int i = 0; i < lines.size();i++) {
                model.addElement(lines.get(i));
            }
            setBackground(Color.black);
            //list.setBackground(Color.black);
            //list.setForeground(Color.white);
            //repaint();
        } else if (e.getSource() == select) {
            String filename = selectPropertiesFile();
            if (filename != "") {
                List<String> lines = File.getTextFile(filename);
                if (lines.size() > 0) {
                    model.removeAllElements();
                    for(int i = 0; i < lines.size();i++) {
                        model.addElement(lines.get(i));
                    }
                    setTitle("PropertiesViewer: " + filename);
                }
            }
            //list.setBackground(Color.white);
            //list.setForeground(Color.black);
            //repaint();
             
        } 
        
    }

    public static void createAndShowGUI(PropertiesViewer app) {
        if (app.getProperties().wasCreated()) {
            app.setSize(640,480);
            app.setLocationRelativeTo(null);
        }
        app.setVisible(true);
    }
    
    public int countAll(boolean includeSystem) {
        int k = 0;
        if (includeSystem) for(int i = 0; i < systemProperties.size();i++) { k++; }
        for(int i = 0; i < properties.size();i++) { k++; }
        return k;
    }
    
    /**
     * @returns -1  if not found in properties list        
     */
    public int getIndexOf(String property) { 
        for(int i = 0; i < keys.length;i++) {
            if (keys[i].equals(property)) return i;
        }
        return -1; // not found
    }
    
    public String[] getKeys() { return keys; }
    
    public String getLineSeparatorString(String separator) {
        String lineSeparator = "";
        if (separator.equals("\r\n")) lineSeparator = "\\r\\n";
        if (separator.equals("\n")) lineSeparator = "\\n";
        return lineSeparator;
    }
    
    public List<String> getOutput() {
        List<String> lines = new ArrayList<>();
        for(int i = 0; i < keys.length;i++) {
            if (keys[i] != null) {
                if (keys[i].equals("line.separator")) {
                    lines.add(keys[i] + ": " + getLineSeparatorString(values[i]));
                } else {
                    lines.add(keys[i] + ": " + values[i]);
                }
            } else {
                lines.add(className + ".output: Null at index: " + i);
            }
        }
        return lines;
    }
    
    public String getProperty(int index) { return values[index]; }

    public String getPropertyKey(int index) { return keys[index]; }
    
    public String[] getSortedPropertiesAsText() {
        sortAscending(true);
        String[] lines = new String[keys.length];
        for(int i = 0; i < keys.length;i++) {
            lines[i] = keys[i] + ":" + values[i];
        }
        return lines;
    }
         
    public String getStrippedOSName() {
        String os = System.getProperty("os.name");
        StringBuffer buf = new StringBuffer();
        for(int i = 0; i < os.length();i++) {
            if (os.charAt(i) != ' ' && os.charAt(i) != '\t' && os.charAt(i) != '\\' && os.charAt(i) != '/') {
                buf.append(os.charAt(i));
            }
        }
        return buf.toString();
    }
    
    public java.util.Properties getSystemProperties() { 
        return systemProperties; 
    }
      
    
    public java.util.Properties getUserProperties() { 
        return properties; 
    }
    
    public String[] getValues() { return values; }

    public static void launch(final String[] args) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        PropertiesViewer app;
        if (ge.isHeadlessInstance()) {
            List<String> properties;
            if (args.length == 1) {
                app = new PropertiesViewer(args[0]);
                properties = app.getOutput();
            } else {
                app = new PropertiesViewer();
                properties = app.getOutput();
            }
            for(int i = 0; i < properties.size();i++) {
                System.out.println(properties.get(i));
            }
        } else {
            app = new PropertiesViewer();
            final PropertiesViewer finalApp = app;
            javax.swing.SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    createAndShowGUI(finalApp);
                }
            });
        }
    }
 
    public static void main(String[] args) {
        final String[] finalArgs = args;
        launch(finalArgs);
    }
    
    public void read() {
        InputStream is = null;
        try {
            File f = new File(filename);
            is = new FileInputStream(f);
            properties.load(is);
            is.close();
        } catch (Exception e) {
            try { if (is != null) is.close(); } catch (IOException ioe) {}
            write(filename);
            try {
                read();
            } catch (Exception e2) {
                System.err.println("PropertiesViewer.read(): Something really bad happened.");
            }
        }
    }
    
    public String selectPropertiesFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(new java.io.File(ProjectPath.INSTANCE.getTecPropsPath() + "PropertiesViewer." + getStrippedOSName() + ".txt"));
        int returnVal = chooser.showOpenDialog(this);
        if(returnVal == JFileChooser.APPROVE_OPTION) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return "";
    }
    
    
    public void set(String key, String value) {
        properties.setProperty(key.toLowerCase(),value);
        if (autoFlush) write(filename);
    }

    public void setFilename(String filename) {
        this.filename = filename;
        read();
        sortAscending(false);
    }
    
    public void sortAscending(boolean includeSystem) {
        //int size = systemProperties.size() + properties.size();
        int size = countAll(includeSystem);
        keys = new String[size];
        values = new String[size];
        int index = 0;
        Enumeration e;
        if (includeSystem) {
            e = systemProperties.propertyNames();
            while (e.hasMoreElements()) {
                keys[index] = (String)e.nextElement();
                values[index] = systemProperties.getProperty(keys[index]);
                index++;
            }
        }
        e = properties.propertyNames();
        while (e.hasMoreElements()) {
            keys[index] = (String)e.nextElement();
            values[index] = properties.getProperty(keys[index]);
            index++;
        } 
        Sort.sortStringBubbleKVByKey(keys,values);
    }
    
    public void write(String filename) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(filename);
            String[] lines = getSortedPropertiesAsText();      
            for(int i = 0; i < lines.length;i++) {
                out.println(lines[i]);
                //System.out.println(lines[i]);
            }   
            out.flush();
            out.close();
        } catch (Exception e) {
            System.err.println(className + ": Couldn't write: " + filename);
        }
    }
}
 
