package ca.tecreations;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/**
 *
 * @author Tim 
 */
public class BuildProject {
    private static boolean standalone = false;
    private final Object lock = new Object();
    List<SystemToken> tokens = new ArrayList<>();
    
    boolean debug = true;
    boolean quiet = true;
    public static boolean clean = true;
    
    int filesCount = 0;
    int outCount = 0;
    int errCount = 0;
    int warnings = 0;
    int errors = 0;
    
    boolean debugSamePackageNotCompiling = false;
    
    public BuildProject(String classpathRoot, boolean clean) {
//        tool.setDebug(true);
        long start = 0L;
        long stop = 0L;
        start = System.currentTimeMillis();
        System.out.println("Started: " + start);
        
        if (clean) {
            new Clean(classpathRoot, quiet);
        }
        doOp(classpathRoot, new File(classpathRoot));

        stop = System.currentTimeMillis();
        System.out.println("Stopped: " + stop);
        printElapsedTime(start, stop);
        // show our results;
        System.out.println("===================================================");
        System.out.println("Compiled: Files: " + filesCount + " Out: " + outCount + " Err: " + errCount + " Errors: " + errors + " Warnings: " + warnings);
        //if (tokens.size() > 0) tokens.get(0).tPrintSubst(tokens, true);
        if (standalone) System.exit(0);
    }

    public void doOp(String classPath, File target) {
        if (debug) {
            System.out.println("Processing: " + target.getAbsolutePath());
        }
        Pair pair = new Pair(target);
        List<File> files = pair.getFiles();
        List<File> dirs = pair.getDirs();
        File file;
        if (files != null) {
            for (int i = 0; i < files.size(); i++) {
                file = files.get(i);
                if (files.get(i).is("java")) {
                    ++filesCount;
                    if (debugSamePackageNotCompiling) {
                        System.out.println("ClassPath: " + classPath + " file(" + i + "): " + files.get(i).getAbsolutePath());
                    }
                    List<SystemToken> tokens = TecData.st.compile(files.get(i), false);
                    for(int j = 0; j < tokens.size();j++) {
                        String token = tokens.get(j).getRaw();
                        if (token.contains("warning:")) warnings++;
                        else if (token.contains("error:")) errors++;
                        if (tokens.get(j).isSystemErr()) {
                            errCount++;
                        } else {
                            outCount++;
                        }
                        tokens.get(j).println();
                    }
                }
            }
        }
        if (dirs != null) {
            for (int i = 0; i < dirs.size(); i++) {
                doOp(classPath, dirs.get(i));
            }
        }
    }

    public static void launch(String classPath, boolean clean) {
        System.out.println("BuildProject.launch: " + classPath);
        new BuildProject(classPath, clean);
    }

    public static void main(String[] args) {
        if (Platform.getRuntimePath().endsWith(".jar")) {
            System.err.println("BuildProject doesn't work on jars, yet.");
        }
        clean = false;
        standalone = true; 
        launch(ProjectPath.getProjectPath(), clean);
    }

    public static void printElapsedTime(long start, long stop) {
        long total = stop - start;
        Date date = new Date(total);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String formatted = formatter.format(date);
        System.out.println("Elapsed Time: (" + total + "): " + formatted);
    }

    public static void usage() {
        System.out.println("Usage: java -cp ... BuildProject [projectDir||classpath||.]");
        System.exit(0);
    }
}
